/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerInitializationException;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOWriter;
import org.fcrepo.server.utilities.status.ServerState;
import org.fcrepo.server.utilities.status.ServerStatusFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BasicServer
extends Server {
    private static final Logger logger = LoggerFactory.getLogger(BasicServer.class);

    public BasicServer(File fedoraHomeDir) throws ServerInitializationException, ModuleInitializationException {
        super(fedoraHomeDir);
    }

    public BasicServer(Element rootElement, File fedoraHomeDir) throws ServerInitializationException, ModuleInitializationException {
        super(rootElement, fedoraHomeDir);
    }

    public BasicServer(Map<String, String> params, File fedoraHomeDir) throws ServerInitializationException, ModuleInitializationException {
        super(params, fedoraHomeDir);
    }

    @Override
    public void initServer() throws ServerInitializationException {
        String fedoraServerHost = null;
        String fedoraServerPort = null;
        fedoraServerHost = this.getParameter("fedoraServerHost");
        if (fedoraServerHost == null) {
            throw new ServerInitializationException("Parameter fedoraServerHost not given, but it's required.");
        }
        fedoraServerPort = this.getParameter("fedoraServerPort");
        if (fedoraServerPort == null) {
            throw new ServerInitializationException("Parameter fedoraServerPort not given, but it's required.");
        }
        logger.info("Fedora Version: " + Server.VERSION);
        logger.info("Fedora Build Date: " + Server.BUILD_DATE);
        ServerStatusFile status = this.getStatusFile();
        try {
            status.append(ServerState.STARTING, "Fedora Version: " + Server.VERSION);
            status.append(ServerState.STARTING, "Fedora Build Date: " + Server.BUILD_DATE);
            status.append(ServerState.STARTING, "Server Host Name: " + fedoraServerHost);
            status.append(ServerState.STARTING, "Server Port: " + fedoraServerPort);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServerInitializationException("Unable to write to status file: " + e.getMessage());
        }
    }

    @Override
    public String[] getRequiredModuleRoles() {
        return new String[]{DOManager.class.getName()};
    }

    @Override
    public void postInitServer() throws ServerInitializationException {
        DOManager doManager = (DOManager)((Object)this.getModule(DOManager.class.getName()));
        try {
            boolean firstRun = this.checkFirstRun();
            this.preIngestIfNeeded(firstRun, doManager, Models.CONTENT_MODEL_3_0);
            this.preIngestIfNeeded(firstRun, doManager, Models.FEDORA_OBJECT_3_0);
            this.preIngestIfNeeded(firstRun, doManager, Models.SERVICE_DEFINITION_3_0);
            this.preIngestIfNeeded(firstRun, doManager, Models.SERVICE_DEPLOYMENT_3_0);
        }
        catch (Exception e) {
            throw new ServerInitializationException("Failed to ingest system object(s)", e);
        }
    }

    private boolean checkFirstRun() throws IOException {
        File hasStarted = new File(FEDORA_HOME, "server/fedora-internal-use/has-started.txt");
        if (hasStarted.exists()) {
            return false;
        }
        hasStarted.createNewFile();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preIngestIfNeeded(boolean firstRun, DOManager doManager, RDFName objectName) throws Exception {
        PID pid = new PID(objectName.uri.substring("info:fedora/".length()));
        boolean exists = doManager.objectExists(pid.toString());
        if (exists && firstRun) {
            logger.info("Purging old system object: " + pid.toString());
            ReadOnlyContext context = ReadOnlyContext.getContext(null, null, null, false);
            DOWriter w = doManager.getWriter(false, context, pid.toString());
            w.remove();
            try {
                w.commit("Purged by Fedora at startup (to be re-ingested)");
                exists = false;
            }
            finally {
                doManager.releaseWriter(w);
            }
        }
        if (!exists) {
            logger.info("Ingesting new system object: " + pid.toString());
            InputStream xml = this.getStream("org/fcrepo/server/resources/" + pid.toFilename() + ".xml");
            ReadOnlyContext context = ReadOnlyContext.getContext(null, null, null, false);
            DOWriter w = doManager.getIngestWriter(false, context, xml, Constants.FOXML1_1.uri, "UTF-8", null);
            try {
                w.commit("Pre-ingested by Fedora at startup");
            }
            finally {
                doManager.releaseWriter(w);
            }
        }
    }

    private InputStream getStream(String path) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (stream == null) {
            throw new IOException("Classloader cannot find resource: " + path);
        }
        return stream;
    }
}

