/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiValueMap {
    private static final Logger logger = LoggerFactory.getLogger(MultiValueMap.class);
    private boolean locked = false;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    protected static final String here = "MultiValueMap";

    public String setReturn(String name, Object value) throws Exception {
        this.set(name, value);
        return name;
    }

    public void set(String name, Object value) throws Exception {
        if (name == null) {
            String msg = here + ": set() has null name, value=" + value;
            logger.debug(msg);
            throw new Exception(msg);
        }
        if (this.locked) {
            String msg = here + ": set() has object locked";
            logger.debug(msg);
            throw new Exception(msg);
        }
        if (!(value instanceof String)) {
            if (value instanceof String[]) {
                if (((String[])value).length == 1) {
                    value = ((String[])value)[0];
                }
            } else if (value == null) {
                value = "";
            } else {
                String msg = here + ": set() has unhandled type";
                logger.debug(msg);
                throw new Exception(msg);
            }
        }
        this.attributes.put(name, value);
    }

    public void lock() {
        this.locked = true;
    }

    public Iterator<String> names() {
        return this.attributes.keySet().iterator();
    }

    public int length(String name) {
        if (this.attributes.get(name) instanceof String) {
            return 1;
        }
        if (this.attributes.get(name) instanceof String[]) {
            return ((String[])this.attributes.get(name)).length;
        }
        return 0;
    }

    public String getString(String name) {
        return (String)this.attributes.get(name);
    }

    public String[] getStringArray(String name) {
        Object value = this.attributes.get(name);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return (String[])value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String key : this.attributes.keySet()) {
            buffer.append(key + "=[");
            if (this.attributes.get(key) instanceof String) {
                String value = (String)this.attributes.get(key);
                buffer.append(value);
            } else if (this.attributes.get(key) instanceof String[]) {
                String[] temp = (String[])this.attributes.get(key);
                String comma = "";
                for (String element : temp) {
                    buffer.append(comma + element);
                    comma = ",";
                }
            }
            buffer.append("]\n");
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(MultiValueMap.class)) {
            return false;
        }
        MultiValueMap that = (MultiValueMap)obj;
        return this.locked == that.locked && MultiValueMap.equalMaps(this.attributes, that.attributes);
    }

    private static boolean equalMaps(Map thisMap, Map thatMap) {
        if (!((Object)thisMap.keySet()).equals(thatMap.keySet())) {
            return false;
        }
        for (Object key : thisMap.keySet()) {
            if (MultiValueMap.equalValues(thisMap.get(key), thatMap.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalValues(Object thisValue, Object thatValue) {
        if (thisValue instanceof Object[]) {
            if (thatValue instanceof Object[]) {
                return Arrays.equals((Object[])thisValue, (Object[])thatValue);
            }
            return false;
        }
        return thisValue.equals(thatValue);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode() + (this.locked ? 1 : 0);
    }
}

