/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.handler.MessageContext;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.security.servletfilters.ExtendedHttpServletRequest;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyContext
implements Context {
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyContext.class);
    public static ReadOnlyContext EMPTY = new ReadOnlyContext(null, null, null, "", true);
    private final Date now = new Date();
    private MultiValueMap m_environmentAttributes;
    private MultiValueMap m_subjectAttributes;
    private MultiValueMap m_actionAttributes;
    private MultiValueMap m_resourceAttributes;
    private final String password;
    private static final String NOOP_PARAMETER_NAME = "noOp";
    public static final boolean NO_OP = true;
    public static final boolean DO_OP = false;
    public static final String BACKEND_SERVICE = "backendService";
    private boolean noOp = false;
    private ExtendedHttpServletRequest extendedHttpServletRequest = null;
    private static final Class STRING_ARRAY_CLASS;

    @Override
    public final MultiValueMap getEnvironmentAttributes() {
        return this.m_environmentAttributes;
    }

    private ReadOnlyContext(HttpServletRequest request, MultiValueMap environmentAttributes, MultiValueMap subjectAttributes, String password, boolean noOp) {
        this.setEnvironmentValues(environmentAttributes);
        this.m_subjectAttributes = subjectAttributes;
        if (this.m_subjectAttributes == null) {
            logger.debug("subject map parm is null");
            this.m_subjectAttributes = new MultiValueMap();
        }
        this.m_subjectAttributes.lock();
        logger.debug("subject attributes in readonlycontext constructor == " + this.m_subjectAttributes);
        this.m_actionAttributes = new MultiValueMap();
        this.m_actionAttributes.lock();
        this.m_resourceAttributes = new MultiValueMap();
        this.m_resourceAttributes.lock();
        if (password == null) {
            password = "";
        }
        this.password = password;
        this.noOp = noOp;
        if (request instanceof ExtendedHttpServletRequest) {
            this.extendedHttpServletRequest = (ExtendedHttpServletRequest)request;
        }
    }

    public void setEnvironmentValues(MultiValueMap environmentAttributes) {
        this.m_environmentAttributes = environmentAttributes;
        if (this.m_environmentAttributes == null) {
            this.m_environmentAttributes = new MultiValueMap();
        }
        this.m_environmentAttributes.lock();
    }

    @Override
    public Iterator<String> environmentAttributes() {
        return this.m_environmentAttributes.names();
    }

    @Override
    public int nEnvironmentValues(String name) {
        return this.m_environmentAttributes.length(name);
    }

    @Override
    public String getEnvironmentValue(String name) {
        return this.m_environmentAttributes.getString(name);
    }

    @Override
    public String[] getEnvironmentValues(String name) {
        return this.m_environmentAttributes.getStringArray(name);
    }

    @Override
    public Iterator<String> subjectAttributes() {
        return this.m_subjectAttributes.names();
    }

    @Override
    public int nSubjectValues(String name) {
        int n = this.m_subjectAttributes.length(name);
        logger.debug("N SUBJECT VALUES without == " + n);
        if (this.extendedHttpServletRequest != null && this.extendedHttpServletRequest.isUserInRole(name)) {
            ++n;
        }
        logger.debug("N SUBJECT VALUES with == " + n);
        return n;
    }

    @Override
    public String getSubjectValue(String name) {
        String value = null;
        if (this.m_subjectAttributes.length(name) == 1) {
            value = this.m_subjectAttributes.getString(name);
            logger.debug("SINGLE SUBJECT VALUE from map == " + value);
        } else if (this.extendedHttpServletRequest != null && this.extendedHttpServletRequest.isUserInRole(name)) {
            value = "";
            logger.debug("SINGLE SUBJECT VALUE from iuir() == " + value);
        }
        return value;
    }

    @Override
    public String[] getSubjectValues(String name) {
        int n = this.m_subjectAttributes.length(name);
        if (this.extendedHttpServletRequest != null && this.extendedHttpServletRequest.isUserInRole(name)) {
            ++n;
        }
        String[] values = new String[n];
        String[] temp = this.m_subjectAttributes.getStringArray(name);
        for (int i = 0; i < temp.length; ++i) {
            values[i] = temp[i];
        }
        if (this.extendedHttpServletRequest != null && this.extendedHttpServletRequest.isUserInRole(name)) {
            values[n - 1] = "";
        }
        if (values == null) {
            logger.debug("INNER RETURNING NO VALUES FOR " + name);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("INNER RETURNING " + values.length + " VALUES FOR " + name + " ==");
            for (int i = 0; i < values.length; ++i) {
                sb.append(" " + values[i]);
            }
            logger.debug(sb.toString());
        }
        return values;
    }

    @Override
    public void setActionAttributes(MultiValueMap actionAttributes) {
        this.m_actionAttributes = actionAttributes;
        if (this.m_actionAttributes == null) {
            this.m_actionAttributes = new MultiValueMap();
        }
        this.m_actionAttributes.lock();
    }

    @Override
    public Iterator<String> actionAttributes() {
        return this.m_actionAttributes.names();
    }

    @Override
    public int nActionValues(String name) {
        return this.m_actionAttributes.length(name);
    }

    @Override
    public String getActionValue(String name) {
        return this.m_actionAttributes.getString(name);
    }

    @Override
    public String[] getActionValues(String name) {
        return this.m_actionAttributes.getStringArray(name);
    }

    @Override
    public Iterator<String> resourceAttributes() {
        return this.m_resourceAttributes.names();
    }

    @Override
    public void setResourceAttributes(MultiValueMap resourceAttributes) {
        this.m_resourceAttributes = resourceAttributes;
        if (this.m_resourceAttributes == null) {
            this.m_resourceAttributes = new MultiValueMap();
        }
        this.m_resourceAttributes.lock();
    }

    @Override
    public int nResourceValues(String name) {
        return this.m_resourceAttributes.length(name);
    }

    @Override
    public String getResourceValue(String name) {
        return this.m_resourceAttributes.getString(name);
    }

    @Override
    public String[] getResourceValues(String name) {
        return this.m_resourceAttributes.getStringArray(name);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("READ-ONLY CONTEXT:\n");
        buffer.append(this.m_environmentAttributes);
        buffer.append(this.m_subjectAttributes);
        buffer.append(this.m_actionAttributes);
        buffer.append(this.m_resourceAttributes);
        buffer.append("(END-READ ONLY CONTEXT)\n");
        return buffer.toString();
    }

    @Override
    public Date now() {
        return this.now;
    }

    private static final MultiValueMap beginEnvironmentMap(String messageProtocol) throws Exception {
        MultiValueMap environmentMap = new MultiValueMap();
        environmentMap.set(Constants.HTTP_REQUEST.MESSAGE_PROTOCOL.uri, messageProtocol);
        Date now = new Date();
        environmentMap.set(Constants.ENVIRONMENT.CURRENT_DATE_TIME.uri, DateUtility.convertDateToString((Date)now));
        environmentMap.set(Constants.ENVIRONMENT.CURRENT_DATE.uri, DateUtility.convertDateToDateString((Date)now));
        environmentMap.set(Constants.ENVIRONMENT.CURRENT_TIME.uri, DateUtility.convertDateToTimeString((Date)now));
        return environmentMap;
    }

    public static Context getSoapContext(MessageContext ctx) {
        HttpServletRequest req = (HttpServletRequest)ctx.get((Object)"HTTP.REQUEST");
        return ReadOnlyContext.getContext(Constants.HTTP_REQUEST.SOAP.uri, req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ReadOnlyContext getContext(HttpServletRequest request, MultiValueMap environmentMap, String subjectId, String password, Map auxSubjectRoles, boolean noOp) {
        MultiValueMap subjectMap = new MultiValueMap();
        try {
            subjectMap.set(Constants.SUBJECT.LOGIN_ID.uri, subjectId == null ? "" : subjectId);
            if (auxSubjectRoles == null) {
                logger.debug("IN CONTEXT auxSubjectRoles == null");
            } else {
                logger.debug("IN CONTEXT processing auxSubjectRoles==" + auxSubjectRoles);
                logger.debug("IN CONTEXT processing auxSubjectRoles.keySet()==" + auxSubjectRoles.keySet());
                logger.debug("IN CONTEXT processing auxSubjectRoles.keySet().isEmpty()==" + auxSubjectRoles.keySet().isEmpty());
                Iterator auxSubjectRoleKeys = auxSubjectRoles.keySet().iterator();
                logger.debug("IN CONTEXT processing auxSubjectRoleKeys==" + auxSubjectRoleKeys);
                while (auxSubjectRoleKeys.hasNext()) {
                    Object name = auxSubjectRoleKeys.next();
                    logger.debug("IN CONTEXT name==" + name);
                    if (!(name instanceof String)) continue;
                    logger.debug("IN CONTEXT name is string==" + name);
                    Object value = auxSubjectRoles.get(name);
                    if (value instanceof String || value instanceof String[]) {
                        logger.debug("IN CONTEXT value is string([])");
                        if (value instanceof String) {
                            logger.debug("IN CONTEXT value is string==" + (String)value);
                        }
                        if (value instanceof String[]) {
                            logger.debug("IN CONTEXT value is string[]");
                            for (int z = 0; z < ((String[])value).length; ++z) {
                                logger.debug("IN CONTEXT this value==" + ((String[])value)[z]);
                            }
                        }
                        subjectMap.set((String)name, value);
                        continue;
                    }
                    if (!(value instanceof Set)) continue;
                    String[] temp = new String[((Set)value).size()];
                    int i = 0;
                    for (String singleValue : (Set)value) {
                        logger.debug("IN CONTEXT singleValue is string==" + singleValue);
                        temp[i++] = singleValue;
                    }
                    subjectMap.set((String)name, temp);
                }
                logger.debug("IN CONTEXT after while");
            }
        }
        catch (Exception e) {
            logger.error("caught exception building subjectMap " + e.getMessage(), (Throwable)e);
        }
        finally {
            subjectMap.lock();
        }
        return new ReadOnlyContext(request, environmentMap, subjectMap, password == null ? "" : password, noOp);
    }

    public static final ReadOnlyContext getContext(String messageProtocol, String subjectId, String password, boolean noOp) throws Exception {
        MultiValueMap environmentMap = ReadOnlyContext.beginEnvironmentMap(messageProtocol);
        environmentMap.lock();
        return ReadOnlyContext.getContext(null, environmentMap, subjectId, password, null, noOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ReadOnlyContext getContext(String messageProtocol, HttpServletRequest request) {
        MultiValueMap environmentMap = null;
        try {
            environmentMap = ReadOnlyContext.beginEnvironmentMap(messageProtocol);
            environmentMap.set(Constants.HTTP_REQUEST.SECURITY.uri, request.isSecure() ? Constants.HTTP_REQUEST.SECURE.uri : Constants.HTTP_REQUEST.INSECURE.uri);
            environmentMap.set(Constants.HTTP_REQUEST.SESSION_STATUS.uri, request.isRequestedSessionIdValid() ? "valid" : "invalid");
            String sessionEncoding = null;
            if (request.isRequestedSessionIdFromCookie()) {
                sessionEncoding = "cookie";
            } else if (request.isRequestedSessionIdFromURL()) {
                sessionEncoding = "url";
            }
            if (request.getContextPath() != null) {
                environmentMap.set("FEDORA_CONTEXT_NAME", request.getContextPath().replace("/", ""));
            }
            if (request.getContentLength() > -1) {
                environmentMap.set(Constants.HTTP_REQUEST.CONTENT_LENGTH.uri, "" + request.getContentLength());
            }
            if (request.getLocalPort() > -1) {
                environmentMap.set(Constants.HTTP_REQUEST.SERVER_PORT.uri, "" + request.getLocalPort());
            }
            if (request.getProtocol() != null) {
                environmentMap.set(Constants.HTTP_REQUEST.PROTOCOL.uri, request.getProtocol());
            }
            if (request.getScheme() != null) {
                environmentMap.set(Constants.HTTP_REQUEST.SCHEME.uri, request.getScheme());
            }
            if (request.getAuthType() != null) {
                environmentMap.set(Constants.HTTP_REQUEST.AUTHTYPE.uri, request.getAuthType());
            }
            if (request.getMethod() != null) {
                environmentMap.set(Constants.HTTP_REQUEST.METHOD.uri, request.getMethod());
            }
            if (sessionEncoding != null) {
                environmentMap.set(Constants.HTTP_REQUEST.SESSION_ENCODING.uri, sessionEncoding);
            }
            if (request.getContentType() != null) {
                environmentMap.set(Constants.HTTP_REQUEST.CONTENT_TYPE.uri, request.getContentType());
            }
            if (request.getLocalAddr() != null) {
                logger.debug("Request Server IP Address is '" + request.getLocalAddr() + "'");
                environmentMap.set(Constants.HTTP_REQUEST.SERVER_IP_ADDRESS.uri, request.getLocalAddr());
            }
            if (request.getRemoteAddr() != null) {
                logger.debug("Request Client IP Address is '" + request.getRemoteAddr() + "'");
                environmentMap.set(Constants.HTTP_REQUEST.CLIENT_IP_ADDRESS.uri, request.getRemoteAddr());
            }
            if (request.getRemoteHost() != null && !request.getRemoteHost().matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                environmentMap.set(Constants.HTTP_REQUEST.CLIENT_FQDN.uri, request.getRemoteHost().toLowerCase());
            }
            if (request.getLocalName() != null && !request.getLocalName().matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                environmentMap.set(Constants.HTTP_REQUEST.SERVER_FQDN.uri, request.getLocalName().toLowerCase());
            }
        }
        catch (Exception e) {
        }
        finally {
            environmentMap.lock();
        }
        String subjectId = request.getRemoteUser();
        String password = null;
        try {
            if (request instanceof ExtendedHttpServletRequest) {
                password = ((ExtendedHttpServletRequest)request).getPassword();
            }
        }
        catch (Throwable th) {
            logger.error("in context, can't grok password from extended request " + th.getMessage());
        }
        if (subjectId == null) {
            subjectId = "";
        }
        if (password == null) {
            password = "";
        }
        boolean noOp = true;
        try {
            noOp = new Boolean(request.getParameter(NOOP_PARAMETER_NAME));
            logger.debug("NOOP_PARAMETER_NAME=noOp");
            logger.debug("request.getParameter(NOOP_PARAMETER_NAME)=" + request.getParameter(NOOP_PARAMETER_NAME));
            logger.debug("noOp=" + noOp);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Map auxSubjectRoles = null;
        Object testFedoraAuxSubjectAttributes = request.getAttribute("FEDORA_AUX_SUBJECT_ATTRIBUTES");
        if (testFedoraAuxSubjectAttributes != null && testFedoraAuxSubjectAttributes instanceof Map) {
            auxSubjectRoles = (Map)testFedoraAuxSubjectAttributes;
        }
        return ReadOnlyContext.getContext(request, environmentMap, subjectId, password, auxSubjectRoles, noOp);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean getNoOp() {
        return this.noOp;
    }

    static {
        EMPTY.setActionAttributes(null);
        EMPTY.setResourceAttributes(null);
        String[] temp = new String[]{""};
        STRING_ARRAY_CLASS = temp.getClass();
    }
}

