/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.common.Constants;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.SpringServlet;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.authorization.AuthzDeniedException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.errors.authorization.AuthzPermittedException;
import org.fcrepo.server.errors.servletExceptionExtensions.BadRequest400Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.Continue100Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.Forbidden403Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.NotFound404Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.Ok200Exception;
import org.fcrepo.server.management.DefaultManagement;
import org.fcrepo.server.management.ManagementModule;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.utilities.PIDStreamIterableWrapper;
import org.fcrepo.server.utilities.ServerUtilitySerializer;
import org.fcrepo.server.utilities.status.ServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerController
extends SpringServlet {
    private static final Logger logger = LoggerFactory.getLogger(DefaultManagement.class);
    private static final long serialVersionUID = 1L;
    private static String PROTOCOL_FILE = "file:///";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String actionLabel = "server control";
        String action = request.getParameter("action");
        if (action == null) {
            throw new BadRequest400Exception(request, actionLabel, "no action", new String[0]);
        }
        if (action.equals("status")) {
            this.statusAction(request, response);
        } else if (action.equals("reloadPolicies")) {
            this.reloadPoliciesAction(request, response);
        } else if (action.equals("modifyDatastreamControlGroup")) {
            this.modifyDatastreamControlGroupAction(request, response);
        } else {
            throw new BadRequest400Exception(request, actionLabel, "bad action:  " + action, new String[0]);
        }
    }

    private void statusAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String actionLabel = "getting server status";
        ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
        if (this.m_server == null) {
            throw new InternalError500Exception(request, actionLabel, "server not available", new String[0]);
        }
        try {
            this.m_server.status(context);
        }
        catch (AuthzOperationalException aoe) {
            throw new Forbidden403Exception(request, actionLabel, "authorization failed", new String[0]);
        }
        catch (AuthzDeniedException ade) {
            throw new Forbidden403Exception(request, actionLabel, "authorization denied", new String[0]);
        }
        catch (AuthzPermittedException ape) {
            throw new Continue100Exception(request, actionLabel, "authorization permitted", new String[0]);
        }
        catch (Throwable t) {
            throw new InternalError500Exception(request, actionLabel, "error performing action2", new String[0]);
        }
        throw new Ok200Exception(request, actionLabel, "server running", new String[0]);
    }

    private void reloadPoliciesAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String actionLabel = "reloading repository policies";
        ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
        if (this.m_server == null) {
            throw new InternalError500Exception(request, actionLabel, "server not available", new String[0]);
        }
        Authorization authModule = null;
        authModule = this.m_server.getBean("org.fcrepo.server.security.Authorization", Authorization.class);
        if (authModule == null) {
            throw new InternalError500Exception(request, actionLabel, "Required Authorization module not available", new String[0]);
        }
        try {
            authModule.reloadPolicies(context);
        }
        catch (AuthzOperationalException aoe) {
            throw new Forbidden403Exception(request, actionLabel, "authorization failed", new String[0]);
        }
        catch (AuthzDeniedException ade) {
            throw new Forbidden403Exception(request, actionLabel, "authorization denied", new String[0]);
        }
        catch (AuthzPermittedException ape) {
            throw new Continue100Exception(request, actionLabel, "authorization permitted", new String[0]);
        }
        catch (Throwable t) {
            throw new InternalError500Exception(request, actionLabel, "error performing action2", new String[0]);
        }
        throw new Ok200Exception(request, actionLabel, "server running", new String[0]);
    }

    private boolean getParameterAsBoolean(HttpServletRequest request, String name, boolean defaultValue) {
        boolean res;
        String parameter = request.getParameter(name);
        if (parameter == null || parameter.equals("")) {
            res = defaultValue;
        } else if (parameter.toLowerCase().equals("true") || parameter.toLowerCase().equals("yes")) {
            res = true;
        } else if (parameter.toLowerCase().equals("false") || parameter.toLowerCase().equals("no")) {
            res = false;
        } else {
            throw new IllegalArgumentException("Invalid value " + parameter + " supplied for " + name + ".  Please use true or false");
        }
        return res;
    }

    private void modifyDatastreamControlGroupAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean singlePID;
        String actionLabel = "modifying datastream control group";
        ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
        if (this.m_server == null) {
            throw new InternalError500Exception(request, actionLabel, "server not available", new String[0]);
        }
        ManagementModule apimDefault = (ManagementModule)this.m_server.getModule("org.fcrepo.server.management.Management");
        String pid = request.getParameter("pid");
        String dsID = request.getParameter("dsID");
        String controlGroup = request.getParameter("controlGroup");
        boolean addXMLHeader = this.getParameterAsBoolean(request, "addXMLHeader", false);
        boolean reformat = this.getParameterAsBoolean(request, "reformat", false);
        boolean setMIMETypeCharset = this.getParameterAsBoolean(request, "setMIMETypeCharset", false);
        String[] datastreams = dsID.split(",");
        Iterable<String> pids = null;
        if (pid.startsWith(PROTOCOL_FILE)) {
            File pidFile = new File(pid.substring(PROTOCOL_FILE.length()));
            pids = new PIDStreamIterableWrapper(new FileInputStream(pidFile));
            singlePID = false;
        } else {
            String[] pidList = pid.split(",");
            pids = new ArrayList<String>(Arrays.asList(pidList));
            singlePID = pidList.length == 1;
        }
        try {
            response.setStatus(200);
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            if (singlePID && datastreams.length == 1) {
                response.setContentType("text/xml; charset=UTF-8");
                Date[] versions = apimDefault.modifyDatastreamControlGroup(context, pid, dsID, controlGroup, addXMLHeader, reformat, setMIMETypeCharset);
                pw.write("<versions>\n");
                for (Date version : versions) {
                    pw.write("<version>" + version.toString() + "</version>\n");
                }
                pw.write("</versions>\n");
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                ServerUtilitySerializer ser = new ServerUtilitySerializer(pw);
                for (String curpid : pids) {
                    ser.startObject(curpid);
                    for (String curdsID : datastreams) {
                        Date[] versions;
                        ser.startDatastream(curdsID);
                        try {
                            versions = apimDefault.modifyDatastreamControlGroup(context, curpid, curdsID, controlGroup, addXMLHeader, reformat, setMIMETypeCharset);
                        }
                        catch (DatastreamNotFoundException e) {
                            versions = null;
                        }
                        ser.writeVersions(versions);
                        ser.endDatastream();
                    }
                    ser.endObject();
                }
                ser.finish();
            }
            pw.flush();
        }
        catch (ObjectNotFoundException e) {
            logger.error("Object not found: " + pid + " - " + e.getMessage());
            throw new NotFound404Exception(request, actionLabel, e.getMessage(), new String[0]);
        }
        catch (DatastreamNotFoundException e) {
            logger.error("Datastream not found: " + pid + "/" + dsID + " - " + e.getMessage());
            throw new NotFound404Exception(request, actionLabel, e.getMessage(), new String[0]);
        }
        catch (GeneralException e) {
            logger.error(e.getMessage());
            throw new InternalError500Exception(request, actionLabel, e.getMessage(), new String[0]);
        }
        catch (AuthzOperationalException aoe) {
            throw new Forbidden403Exception(request, actionLabel, "authorization failed", new String[0]);
        }
        catch (AuthzDeniedException ade) {
            throw new Forbidden403Exception(request, actionLabel, "authorization denied", new String[0]);
        }
        catch (AuthzPermittedException ape) {
            throw new Continue100Exception(request, actionLabel, "authorization permitted", new String[0]);
        }
        catch (ServerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new InternalError500Exception(request, actionLabel, "Unexpected error: " + e.getMessage(), new String[0]);
        }
    }

    public void init() throws ServletException {
        super.init();
    }

    @Override
    public void destroy() {
        if (this.m_server != null) {
            try {
                this.m_status.append(ServerState.STOPPING, "Shutting down Fedora Server and modules");
                this.m_server.shutdown(null);
                this.m_status.append(ServerState.STOPPED, "Shutdown Successful");
            }
            catch (Throwable th) {
                try {
                    this.m_status.appendError(ServerState.STOPPED_WITH_ERR, th);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_server = null;
        }
        super.destroy();
    }
}

