/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.access.DynamicAccessModule;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.access.dissemination.DisseminationService;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.DisseminationException;
import org.fcrepo.server.errors.DisseminatorNotFoundException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.InvalidUserParmException;
import org.fcrepo.server.errors.MethodNotFoundException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DeploymentDSBindRule;
import org.fcrepo.server.storage.types.DeploymentDSBindSpec;
import org.fcrepo.server.storage.types.DisseminationBindingInfo;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.MethodDefOperationBind;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.PredicateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccess
extends Module
implements Access {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAccess.class);
    private DOManager m_manager;
    private String m_repositoryDomainName;
    private DynamicAccessModule m_dynamicAccess;
    private ExternalContentManager m_externalContentManager;
    private Authorization m_authorizationModule;
    private static final Hashtable<String, String> accessActionAttributes = new Hashtable();

    public DefaultAccess(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        String dsMediation = this.getParameter("doMediateDatastreams");
        if (dsMediation == null) {
            throw new ModuleInitializationException("doMediateDatastreams parameter must be specified.", this.getRole());
        }
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        this.m_manager = (DOManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.DOManager"));
        if (this.m_manager == null) {
            throw new ModuleInitializationException("Can't get a DOManager from Server.getModule", this.getRole());
        }
        this.m_dynamicAccess = (DynamicAccessModule)this.getServer().getModule("org.fcrepo.server.access.DynamicAccess");
        this.m_externalContentManager = (ExternalContentManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ExternalContentManager"));
        Module oaiProvider = this.getServer().getModule("org.fcrepo.oai.OAIProvider");
        if (oaiProvider == null) {
            throw new ModuleInitializationException("DefaultAccess module requires that the server has an OAIProvider module configured so that it can get the repositoryDomainName parameter.", this.getRole());
        }
        this.m_repositoryDomainName = oaiProvider.getParameter("repositoryDomainName");
        if (this.m_repositoryDomainName == null) {
            throw new ModuleInitializationException("DefaultAccess module requires that the OAIProvider module has the repositoryDomainName parameter specified.", this.getRole());
        }
        this.m_authorizationModule = this.getServer().getBean("org.fcrepo.server.security.Authorization", Authorization.class);
        if (this.m_authorizationModule == null) {
            throw new ModuleInitializationException("Can't get an Authorization module (in default access) from Server.getModule", this.getRole());
        }
    }

    @Override
    public MIMETypedStream getDissemination(Context context, String PID2, String sDefPID, String methodName, Property[] userParms, Date asOfDateTime) throws ServerException {
        PID2 = Server.getPID(PID2).toString();
        sDefPID = Server.getPID(sDefPID).toString();
        long initStartTime = new Date().getTime();
        long startTime = new Date().getTime();
        ServiceDeploymentReader deploymentReader = null;
        DOReader reader = this.m_manager.getReader(asOfDateTime == null, context, PID2);
        String authzAux_objState = reader.GetObjectState();
        if (this.m_dynamicAccess.isDynamicService(context, PID2, sDefPID)) {
            this.m_authorizationModule.enforceGetDissemination(context, PID2, sDefPID, methodName, asOfDateTime, authzAux_objState, "A", "fedora-system:4", "A", "A");
            MIMETypedStream retVal = this.m_dynamicAccess.getDissemination(context, PID2, sDefPID, methodName, userParms, asOfDateTime);
            long stopTime = new Date().getTime();
            long interval = stopTime - startTime;
            logger.debug("Roundtrip DynamicDisseminator: " + interval + " milliseconds.");
            return retVal;
        }
        String serviceDeploymentPID = null;
        for (String cModelURI : reader.getContentModels()) {
            String cModelPID = cModelURI.substring("info:fedora/".length());
            String foundDeploymentPID = this.m_manager.lookupDeploymentForCModel(cModelPID, sDefPID);
            if (foundDeploymentPID != null) {
                if (serviceDeploymentPID != null && !foundDeploymentPID.equals(serviceDeploymentPID)) {
                    throw new DisseminationException("More than one deployment (" + foundDeploymentPID + ", " + serviceDeploymentPID + ") found for service " + sDefPID + " in model " + cModelPID);
                }
                serviceDeploymentPID = foundDeploymentPID;
                continue;
            }
            logger.debug("No deployment for (" + cModelPID + ", " + sDefPID + ")");
        }
        if (serviceDeploymentPID != null) {
            deploymentReader = this.m_manager.getServiceDeploymentReader(false, context, serviceDeploymentPID);
        }
        ServiceDefinitionReader sDefReader = this.m_manager.getServiceDefinitionReader(asOfDateTime == null, context, sDefPID);
        String authzAux_sdefState = sDefReader.GetObjectState();
        String authzAux_dissState = "unknown";
        if (deploymentReader == null) {
            boolean suitableModelFound = false;
            String cModelPID = null;
            String message = null;
            block3: for (String cm : reader.getContentModels()) {
                cModelPID = cm.substring(12);
                if (Models.contains((String)("info:fedora/" + cModelPID))) continue;
                for (RelationshipTuple r : this.m_manager.getReader(false, context, cModelPID).getRelationships((PredicateNode)DefaultAccess.MODEL.HAS_SERVICE, null)) {
                    if (!sDefPID.equals(r.getObjectPID())) continue;
                    suitableModelFound = true;
                    break block3;
                }
            }
            message = suitableModelFound ? "Unable to find deployment for service " + sDefPID + " on " + reader.GetObjectPID() + " in model " + cModelPID : reader.GetObjectPID() + " does not have a model with service " + sDefPID;
            throw new DisseminatorNotFoundException(message);
        }
        long stopTime = new Date().getTime();
        long interval = stopTime - startTime;
        logger.debug("Roundtrip Looping Diss: " + interval + " milliseconds.");
        String authzAux_sDepState = deploymentReader.GetObjectState();
        String authzAux_sDepPID = deploymentReader.GetObjectPID();
        this.m_authorizationModule.enforceGetDissemination(context, PID2, sDefPID, methodName, asOfDateTime, authzAux_objState, authzAux_sdefState, authzAux_sDepPID, authzAux_sDepState, authzAux_dissState);
        Hashtable<String, String> h_userParms = new Hashtable<String, String>();
        MIMETypedStream dissemination = null;
        MethodParmDef[] defaultMethodParms = null;
        startTime = new Date().getTime();
        if (userParms != null) {
            for (Property element : userParms) {
                h_userParms.put(element.name, element.value);
            }
        }
        this.validateUserParms(context, PID2, sDefPID, deploymentReader, methodName, h_userParms, asOfDateTime);
        stopTime = new Date().getTime();
        interval = stopTime - startTime;
        logger.debug("Roundtrip Get/Validate User Parms: " + interval + " milliseconds.");
        startTime = new Date().getTime();
        defaultMethodParms = deploymentReader.getServiceMethodParms(methodName, asOfDateTime);
        for (int i = 0; i < defaultMethodParms.length; ++i) {
            if (defaultMethodParms[i].parmType.equals("fedora:datastreamInputType") || h_userParms.containsKey(defaultMethodParms[i].parmName)) continue;
            logger.debug("addedDefaultName: " + defaultMethodParms[i].parmName);
            String pdv = defaultMethodParms[i].parmDefaultValue;
            try {
                if (pdv.equalsIgnoreCase("$pid")) {
                    pdv = URLDecoder.decode(PID2, "UTF-8");
                } else if (pdv.equalsIgnoreCase("$objuri")) {
                    pdv = "info:fedora/" + URLDecoder.decode(PID2, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            logger.debug("addedDefaultValue: " + pdv);
            h_userParms.put(defaultMethodParms[i].parmName, pdv);
        }
        stopTime = new Date().getTime();
        interval = stopTime - startTime;
        logger.debug("Roundtrip Get Deployment Parms: " + interval + " milliseconds.");
        startTime = new Date().getTime();
        DisseminationBindingInfo[] dissBindInfo = this.getDisseminationBindingInfo(context, reader, deploymentReader, methodName, asOfDateTime);
        DisseminationService dissService = new DisseminationService(this.getServer());
        dissemination = dissService.assembleDissemination(context, PID2, h_userParms, dissBindInfo, authzAux_sDepPID, deploymentReader, methodName);
        stopTime = new Date().getTime();
        interval = stopTime - startTime;
        logger.debug("Roundtrip Assemble Dissemination: " + interval + " milliseconds.");
        stopTime = new Date().getTime();
        interval = stopTime - initStartTime;
        logger.debug("Roundtrip GetDissemination: " + interval + " milliseconds.");
        return dissemination;
    }

    private DisseminationBindingInfo[] getDisseminationBindingInfo(Context context, DOReader dObj, ServiceDeploymentReader bmReader, String methodName, Date versDateTime) throws MethodNotFoundException, ServerException {
        MethodParmDef[] methodParms = bmReader.getServiceMethodParms(methodName, versDateTime);
        MethodDefOperationBind[] opBindings = bmReader.getServiceMethodBindings(versDateTime);
        String addressLocation = null;
        String operationLocation = null;
        String protocolType = null;
        boolean foundMethod = false;
        for (MethodDefOperationBind element : opBindings) {
            if (!element.methodName.equals(methodName)) continue;
            foundMethod = true;
            addressLocation = element.serviceBindingAddress;
            operationLocation = element.operationLocation;
            protocolType = element.protocolType;
        }
        if (!foundMethod) {
            throw new MethodNotFoundException("Method " + methodName + " was not found in " + bmReader.GetObjectPID() + "'s operation " + " binding.");
        }
        DeploymentDSBindSpec dsBindSpec = bmReader.getServiceDSInputSpec(versDateTime);
        DeploymentDSBindRule[] dsBindRules = dsBindSpec.dsBindRules == null ? new DeploymentDSBindRule[]{} : dsBindSpec.dsBindRules;
        ArrayList<DisseminationBindingInfo> bindingInfoList = new ArrayList<DisseminationBindingInfo>();
        for (int i = 0; i < dsBindRules.length; ++i) {
            DeploymentDSBindRule dsBindRule = dsBindRules[i];
            String dsPid = dsBindRule.pid == null ? dObj.GetObjectPID() : dsBindRule.pid;
            String dsId = dsBindRule.bindingKeyName;
            DOReader reader = this.m_manager.getReader(false, context, dsPid);
            Datastream ds = reader.GetDatastream(dsId, versDateTime);
            if (ds == null) continue;
            DisseminationBindingInfo bindingInfo = new DisseminationBindingInfo();
            bindingInfo.DSBindKey = dsId;
            bindingInfo.dsLocation = ds.DSLocation;
            bindingInfo.dsControlGroupType = ds.DSControlGrp;
            bindingInfo.dsID = ds.DatastreamID;
            bindingInfo.dsVersionID = ds.DSVersionID;
            bindingInfo.dsState = ds.DSState;
            bindingInfo.dsCreateDT = ds.DSCreateDT;
            bindingInfo.methodParms = methodParms;
            bindingInfo.AddressLocation = addressLocation;
            bindingInfo.OperationLocation = operationLocation;
            bindingInfo.ProtocolType = protocolType;
            bindingInfoList.add(bindingInfo);
        }
        return bindingInfoList.toArray(new DisseminationBindingInfo[0]);
    }

    @Override
    public ObjectMethodsDef[] listMethods(Context context, String PID2, Date asOfDateTime) throws ServerException {
        long startTime = new Date().getTime();
        PID2 = Server.getPID(PID2).toString();
        this.m_authorizationModule.enforceListMethods(context, PID2, asOfDateTime);
        DOReader reader = this.m_manager.getReader(false, context, PID2);
        ObjectMethodsDef[] methodDefs = reader.listMethods(asOfDateTime);
        long stopTime = new Date().getTime();
        long interval = stopTime - startTime;
        logger.debug("Roundtrip listMethods: " + interval + " milliseconds.");
        ObjectMethodsDef[] dynamicMethodDefs = this.m_dynamicAccess.listMethods(context, PID2, asOfDateTime);
        ArrayList<ObjectMethodsDef> methodList = new ArrayList<ObjectMethodsDef>();
        for (ObjectMethodsDef element : methodDefs) {
            methodList.add(element);
        }
        for (ObjectMethodsDef element : dynamicMethodDefs) {
            methodList.add(element);
        }
        return methodList.toArray(new ObjectMethodsDef[0]);
    }

    @Override
    public DatastreamDef[] listDatastreams(Context context, String PID2, Date asOfDateTime) throws ServerException {
        long startTime = new Date().getTime();
        PID2 = Server.getPID(PID2).toString();
        this.m_authorizationModule.enforceListDatastreams(context, PID2, asOfDateTime);
        DOReader reader = this.m_manager.getReader(false, context, PID2);
        Datastream[] datastreams = reader.GetDatastreams(asOfDateTime, null);
        DatastreamDef[] dsDefs = new DatastreamDef[datastreams.length];
        for (int i = 0; i < datastreams.length; ++i) {
            dsDefs[i] = new DatastreamDef(datastreams[i].DatastreamID, datastreams[i].DSLabel, datastreams[i].DSMIME);
        }
        long stopTime = new Date().getTime();
        long interval = stopTime - startTime;
        logger.debug("Roundtrip listDatastreams: " + interval + " milliseconds.");
        return dsDefs;
    }

    @Override
    public ObjectProfile getObjectProfile(Context context, String PID2, Date asOfDateTime) throws ServerException {
        PID2 = Server.getPID(PID2).toString();
        this.m_authorizationModule.enforceGetObjectProfile(context, PID2, asOfDateTime);
        DOReader reader = this.m_manager.getReader(asOfDateTime == null, context, PID2);
        Date versDateTime = asOfDateTime;
        ObjectProfile profile = new ObjectProfile();
        profile.PID = reader.GetObjectPID();
        profile.objectLabel = reader.GetObjectLabel();
        profile.objectOwnerId = reader.getOwnerId();
        profile.objectModels = new HashSet<String>();
        profile.objectCreateDate = reader.getCreateDate();
        profile.objectLastModDate = reader.getLastModDate();
        profile.objectState = reader.GetObjectState();
        profile.objectModels.addAll(reader.getContentModels());
        String securityUri = context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri);
        if (securityUri != null) {
            String reposBaseURL = this.getReposBaseURL(securityUri.equals(Constants.HTTP_REQUEST.SECURE.uri) ? "https" : "http", context.getEnvironmentValue(Constants.HTTP_REQUEST.SERVER_PORT.uri));
            profile.dissIndexViewURL = this.getDissIndexViewURL(reposBaseURL, context.getEnvironmentValue("FEDORA_CONTEXT_NAME"), reader.GetObjectPID(), versDateTime);
            profile.itemIndexViewURL = this.getItemIndexViewURL(reposBaseURL, context.getEnvironmentValue("FEDORA_CONTEXT_NAME"), reader.GetObjectPID(), versDateTime);
        }
        return profile;
    }

    @Override
    public FieldSearchResult findObjects(Context context, String[] resultFields, int maxResults, FieldSearchQuery query) throws ServerException {
        this.m_authorizationModule.enforceFindObjects(context);
        return this.m_manager.findObjects(context, resultFields, maxResults, query);
    }

    @Override
    public FieldSearchResult resumeFindObjects(Context context, String sessionToken) throws ServerException {
        this.m_authorizationModule.enforceFindObjects(context);
        return this.m_manager.resumeFindObjects(context, sessionToken);
    }

    @Override
    public RepositoryInfo describeRepository(Context context) throws ServerException {
        this.m_authorizationModule.enforceDescribeRepository(context);
        RepositoryInfo repositoryInfo = new RepositoryInfo();
        repositoryInfo.repositoryName = this.getServer().getParameter("repositoryName");
        String reposBaseURL = this.getReposBaseURL(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri).equals(Constants.HTTP_REQUEST.SECURE.uri) ? "https" : "http", context.getEnvironmentValue(Constants.HTTP_REQUEST.SERVER_PORT.uri));
        repositoryInfo.repositoryBaseURL = reposBaseURL + "/" + context.getEnvironmentValue("FEDORA_CONTEXT_NAME");
        repositoryInfo.repositoryVersion = Server.VERSION;
        Module domgr = this.getServer().getModule("org.fcrepo.server.storage.DOManager");
        repositoryInfo.repositoryPIDNamespace = domgr.getParameter("pidNamespace");
        repositoryInfo.defaultExportFormat = domgr.getParameter("defaultExportFormat");
        repositoryInfo.OAINamespace = this.m_repositoryDomainName;
        repositoryInfo.adminEmailList = this.getAdminEmails();
        repositoryInfo.samplePID = repositoryInfo.repositoryPIDNamespace + ":100";
        repositoryInfo.sampleOAIIdentifer = "oai:" + repositoryInfo.OAINamespace + ":" + repositoryInfo.samplePID;
        repositoryInfo.sampleSearchURL = repositoryInfo.repositoryBaseURL + "/objects";
        repositoryInfo.sampleAccessURL = repositoryInfo.repositoryBaseURL + "/objects/" + "demo:5";
        repositoryInfo.sampleOAIURL = repositoryInfo.repositoryBaseURL + "/oai?verb=Identify";
        repositoryInfo.retainPIDs = this.getRetainPIDs();
        return repositoryInfo;
    }

    @Override
    public String[] getObjectHistory(Context context, String PID2) throws ServerException {
        PID2 = Server.getPID(PID2).toString();
        this.m_authorizationModule.enforceGetObjectHistory(context, PID2);
        DOReader reader = this.m_manager.getReader(false, context, PID2);
        return reader.getObjectHistory(PID2);
    }

    private String[] getAdminEmails() {
        String emailsCSV = this.convertToCSV(this.getServer().getParameter("adminEmailList"));
        Vector<Object> emails = new Vector<Object>();
        StringTokenizer st = new StringTokenizer(emailsCSV, ",");
        while (st.hasMoreElements()) {
            emails.add(st.nextElement());
        }
        return emails.toArray(new String[0]);
    }

    private String[] getRetainPIDs() {
        String retainPIDsCSV = this.convertToCSV(this.getServer().getModule("org.fcrepo.server.storage.DOManager").getParameter("retainPIDs"));
        Vector<Object> retainPIDs = new Vector<Object>();
        StringTokenizer st = new StringTokenizer(retainPIDsCSV, ",");
        while (st.hasMoreElements()) {
            retainPIDs.add(st.nextElement());
        }
        return retainPIDs.toArray(new String[0]);
    }

    private String convertToCSV(String list) {
        if (list == null) {
            return "*";
        }
        String original = list.trim();
        Pattern spaces = Pattern.compile(" ++");
        Matcher m = spaces.matcher(original);
        String interim = m.replaceAll(",");
        Pattern multcommas = Pattern.compile(",++");
        Matcher m2 = multcommas.matcher(interim);
        String csv = m2.replaceAll(",");
        return csv;
    }

    private void validateUserParms(Context context, String PID2, String sDefPID, ServiceDeploymentReader sdepreader, String methodName, Hashtable<String, String> h_userParms, Date versDateTime) throws ServerException {
        Enumeration<Object> e;
        PID2 = Server.getPID(PID2).toString();
        sDefPID = Server.getPID(sDefPID).toString();
        MethodParmDef[] methodParms = null;
        MethodParmDef methodParm = null;
        StringBuffer sb = new StringBuffer();
        Hashtable<String, MethodParmDef> h_validParms = new Hashtable<String, MethodParmDef>();
        boolean isValid = true;
        if (sdepreader != null) {
            MethodDef[] methods = sdepreader.getServiceMethods(versDateTime);
            for (MethodDef methodDef : methods) {
                MethodParmDef[] parms;
                if (!methodDef.methodName.equalsIgnoreCase(methodName)) continue;
                ArrayList<MethodParmDef> filteredParms = new ArrayList<MethodParmDef>();
                for (MethodParmDef element2 : parms = methodDef.methodParms) {
                    if (!element2.parmType.equalsIgnoreCase("fedora:userInputType")) continue;
                    filteredParms.add(element2);
                }
                methodParms = filteredParms.toArray(new MethodParmDef[0]);
            }
        } else {
            String message = "[DefaultAccess] Old-style disseminators are no longer supported ";
            throw new DisseminatorNotFoundException(message);
        }
        if (methodParms != null) {
            for (int i = 0; i < methodParms.length; ++i) {
                methodParm = methodParms[i];
                h_validParms.put(methodParm.parmName, methodParm);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("methodParms[" + i + "]: " + methodParms[i].parmName + "\nlabel: " + methodParms[i].parmLabel + "\ndefault: " + methodParms[i].parmDefaultValue + "\nrequired: " + methodParms[i].parmRequired + "\ntype: " + methodParms[i].parmType);
                for (String string : methodParms[i].parmDomainValues) {
                    logger.debug("domainValue: " + (String)string);
                }
            }
        }
        if (!h_validParms.isEmpty()) {
            e = h_validParms.keys();
            while (e.hasMoreElements()) {
                String validName = (String)e.nextElement();
                MethodParmDef mp = (MethodParmDef)h_validParms.get(validName);
                if (!mp.parmRequired || h_userParms.get(validName) != null) continue;
                sb.append("The required parameter \"" + validName + "\" was not found in the " + "user-supplied parameter list.");
                throw new InvalidUserParmException("[Invalid User Parameters] " + sb.toString());
            }
            Enumeration<String> parmNames = h_userParms.keys();
            while (parmNames.hasMoreElements()) {
                String parmName = parmNames.nextElement();
                methodParm = (MethodParmDef)h_validParms.get(parmName);
                if (methodParm != null && methodParm.parmName != null) {
                    String value = h_userParms.get(methodParm.parmName);
                    if (value == null || value.equalsIgnoreCase("")) {
                        if (methodParm.parmDefaultValue != null) {
                            h_userParms.put(methodParm.parmName, methodParm.parmDefaultValue);
                            continue;
                        }
                        logger.warn("The method parameter \"" + methodParm.parmName + "\" has no default value and no " + "value was specified by the user.  " + "The value of the empty string has " + "been assigned to this parameter.");
                        continue;
                    }
                    String[] stringArray = methodParm.parmDomainValues;
                    if (stringArray.length <= 0 || stringArray[0].equalsIgnoreCase("null")) continue;
                    boolean isValidValue = false;
                    String userValue = h_userParms.get(methodParm.parmName);
                    for (String element : stringArray) {
                        if (!userValue.equalsIgnoreCase(element) && !element.equalsIgnoreCase("null")) continue;
                        isValidValue = true;
                    }
                    if (isValidValue) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == stringArray.length - 1) {
                            sb.append(stringArray[i]);
                            continue;
                        }
                        sb.append(stringArray[i] + ", ");
                    }
                    sb.append("The method parameter \"" + methodParm.parmName + "\" with a value of \"" + h_userParms.get(methodParm.parmName) + "\" is not allowed for the method \"" + methodName + "\". Allowed values for this " + "method include \"" + sb.toString() + "\".");
                    isValid = false;
                    continue;
                }
                sb.append("The method parameter \"" + parmName + "\" is not valid for the method \"" + methodName + "\".");
                isValid = false;
            }
        } else if (!h_userParms.isEmpty()) {
            e = h_userParms.keys();
            while (e.hasMoreElements()) {
                sb.append("The method parameter \"" + (String)e.nextElement() + "\" is not valid for the method \"" + methodName + "\"." + "The method \"" + methodName + "\" defines no method parameters.");
            }
            throw new InvalidUserParmException("[Invalid User Parameters] " + sb.toString());
        }
        if (!isValid) {
            throw new InvalidUserParmException("[Invalid User Parameter] " + sb.toString());
        }
    }

    private String getDissIndexViewURL(String reposBaseURL, String fedoraContext, String PID2, Date versDateTime) {
        String dissIndexURL = null;
        try {
            dissIndexURL = versDateTime == null ? reposBaseURL + "/" + fedoraContext + "/objects/" + URLEncoder.encode(PID2, "UTF-8") + "/methods/" + URLEncoder.encode("fedora-system:3", "UTF-8") + "/viewMethodIndex" : reposBaseURL + "/" + fedoraContext + "/objects/" + URLEncoder.encode(PID2, "UTF-8") + "/methods" + URLEncoder.encode("fedora-system:3", "UTF-8") + "/viewMethodIndex?asOfDateTime=" + DateUtility.convertDateToString((Date)versDateTime);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return dissIndexURL;
    }

    private String getItemIndexViewURL(String reposBaseURL, String fedoraContext, String PID2, Date versDateTime) {
        String itemIndexURL = null;
        try {
            itemIndexURL = versDateTime == null ? reposBaseURL + "/" + fedoraContext + "/objects/" + URLEncoder.encode(PID2, "UTF-8") + "/methods/" + URLEncoder.encode("fedora-system:3", "UTF-8") + "/viewItemIndex" : reposBaseURL + "/" + fedoraContext + "/objects/" + URLEncoder.encode(PID2, "UTF-8") + "/methods/" + URLEncoder.encode("fedora-system:3", "UTF-8") + "/viewItemIndex?asOfDateTime=" + DateUtility.convertDateToString((Date)versDateTime);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return itemIndexURL;
    }

    private String getReposBaseURL(String protocol, String port) {
        String reposBaseURL = null;
        String fedoraServerHost = this.getServer().getParameter("fedoraServerHost");
        if (fedoraServerHost == null || fedoraServerHost.equals("")) {
            logger.warn("Configuration parameter fedoraServerHost is empty.");
            try {
                InetAddress hostIP = InetAddress.getLocalHost();
                fedoraServerHost = hostIP.getHostName();
            }
            catch (UnknownHostException e) {
                logger.error("Unable to resolve host of Fedora server", (Throwable)e);
                fedoraServerHost = "localhost";
            }
        }
        reposBaseURL = protocol + "://" + fedoraServerHost + ":" + port;
        return reposBaseURL;
    }

    @Override
    public MIMETypedStream getDatastreamDissemination(Context context, String PID2, String dsID, Date asOfDateTime) throws ServerException {
        DatastreamReferencedContent drc;
        PID2 = Server.getPID(PID2).toString();
        this.m_authorizationModule.enforceGetDatastreamDissemination(context, PID2, dsID, asOfDateTime);
        MIMETypedStream mimeTypedStream = null;
        long startTime = new Date().getTime();
        DOReader reader = this.m_manager.getReader(false, context, PID2);
        Datastream ds = reader.GetDatastream(dsID, asOfDateTime);
        if (ds == null) {
            String message = "[DefaulAccess] No datastream could be returned. Either there is no datastream for the digital object \"" + PID2 + "\" with datastream ID of \"" + dsID + " \"  OR  there are no datastreams that match the specified " + "date/time value of \"" + DateUtility.convertDateToString((Date)asOfDateTime) + " \"  .";
            throw new DatastreamNotFoundException(message);
        }
        if (ds.DSControlGrp.equalsIgnoreCase("E")) {
            drc = (DatastreamReferencedContent)reader.GetDatastream(dsID, asOfDateTime);
            ContentManagerParams params = new ContentManagerParams(drc.DSLocation, drc.DSMIME, null, null);
            params.setContext(context);
            mimeTypedStream = this.m_externalContentManager.getExternalContent(params);
        } else if (ds.DSControlGrp.equalsIgnoreCase("M")) {
            DatastreamManagedContent dmc = (DatastreamManagedContent)reader.GetDatastream(dsID, asOfDateTime);
            mimeTypedStream = new MIMETypedStream(ds.DSMIME, dmc.getContentStream(context), null, ds.DSSize);
        } else if (ds.DSControlGrp.equalsIgnoreCase("X")) {
            DatastreamXMLMetadata dxm = (DatastreamXMLMetadata)reader.GetDatastream(dsID, asOfDateTime);
            mimeTypedStream = new MIMETypedStream(ds.DSMIME, dxm.getContentStream(context), null, ds.DSSize);
        } else if (ds.DSControlGrp.equalsIgnoreCase("R")) {
            drc = (DatastreamReferencedContent)reader.GetDatastream(dsID, asOfDateTime);
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(drc.DSLocation.getBytes("UTF-8"));
                mimeTypedStream = new MIMETypedStream("application/fedora-redirect", inStream, null);
            }
            catch (UnsupportedEncodingException uee) {
                String message = "[DefaultAccess] An error has occurred. The error was a \"" + uee.getClass().getName() + "\"  . The " + "Reason was \"" + uee.getMessage() + "\"  . String value: " + drc.DSLocation + "  . ";
                logger.error(message);
                throw new GeneralException(message);
            }
        }
        long stopTime = new Date().getTime();
        long interval = stopTime - startTime;
        logger.debug("Roundtrip getDatastreamDissemination: " + interval + " milliseconds.");
        return mimeTypedStream;
    }

    static {
        accessActionAttributes.put("api", "apia");
    }
}

