/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.access.RepositoryInfo;
import org.fcrepo.server.access.defaultdisseminator.DefaultDisseminatorImpl;
import org.fcrepo.server.access.defaultdisseminator.ServiceMethodDispatcher;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.MethodNotFoundException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.Property;

public class DynamicAccessImpl {
    private final Access m_access;
    private final ServiceMethodDispatcher dispatcher = new ServiceMethodDispatcher();
    private File reposHomeDir = null;
    private Hashtable dynamicServiceToDeployment = null;

    public DynamicAccessImpl(Access m_access, File reposHomeDir, Hashtable dynamicSDefToDep) {
        this.m_access = m_access;
        this.reposHomeDir = reposHomeDir;
        this.dynamicServiceToDeployment = dynamicSDefToDep;
    }

    public String[] getServiceDefinitions(Context context, String PID2, Date asOfDateTime) throws ServerException {
        ArrayList sdefs = new ArrayList();
        Iterator iter = this.dynamicServiceToDeployment.keySet().iterator();
        while (iter.hasNext()) {
            sdefs.add(iter.next());
        }
        return sdefs.toArray(new String[0]);
    }

    public MethodDef[] getMethods(Context context, String PID2, String sDefPID, Date asOfDateTime) throws ServerException {
        Class deploymentClass = (Class)this.dynamicServiceToDeployment.get(sDefPID);
        if (deploymentClass != null) {
            try {
                Method method = deploymentClass.getMethod("reflectMethods", null);
                return (MethodDef[])method.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                throw new GeneralException("[DynamicAccessImpl] returned error when attempting to get dynamic method definitions. The underlying error class was: " + e.getClass().getName() + ". The message " + "was \"" + e.getMessage() + "\"");
            }
        }
        throw new MethodNotFoundException("[DynamicAccessImpl] The object, " + PID2 + " does not have the dynamic Service Definition " + sDefPID);
    }

    public MIMETypedStream getMethodsXML(Context context, String PID2, String sDefPID, Date asOfDateTime) throws ServerException {
        return null;
    }

    private String getReposBaseURL(String protocol, String port) {
        String reposBaseURL = null;
        String fedoraServerHost = ((Module)((Object)this.m_access)).getServer().getParameter("fedoraServerHost");
        reposBaseURL = protocol + "://" + fedoraServerHost + ":" + port;
        return reposBaseURL;
    }

    public MIMETypedStream getDissemination(Context context, String PID2, String sDefPID, String methodName, Property[] userParms, Date asOfDateTime, DOReader reader) throws ServerException {
        if (sDefPID.equalsIgnoreCase("fedora-system:3")) {
            String reposBaseURL = this.getReposBaseURL(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri).equals(Constants.HTTP_REQUEST.SECURE.uri) ? "https" : "http", context.getEnvironmentValue(Constants.HTTP_REQUEST.SERVER_PORT.uri));
            Object result = this.dispatcher.invokeMethod(new DefaultDisseminatorImpl(context, asOfDateTime, reader, this.m_access, reposBaseURL, this.reposHomeDir), methodName, userParms);
            if (result.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.types.MIMETypedStream")) {
                return (MIMETypedStream)result;
            }
            throw new GeneralException("[DynamicAccessImpl] returned error. Internal service must return a MIME typed stream. (see org.fcrepo.server.storage.types.MIMETypedStream)");
        }
        return null;
    }

    public ObjectMethodsDef[] listMethods(Context context, String PID2, Date asOfDateTime) throws ServerException {
        String[] sDefPIDs = this.getServiceDefinitions(context, PID2, asOfDateTime);
        Date versDateTime = asOfDateTime;
        ArrayList<ObjectMethodsDef> objectMethods = new ArrayList<ObjectMethodsDef>();
        for (String element : sDefPIDs) {
            MethodDef[] methodDefs;
            for (MethodDef element2 : methodDefs = this.getMethods(context, PID2, element, asOfDateTime)) {
                ObjectMethodsDef method = new ObjectMethodsDef();
                method.PID = PID2;
                method.asOfDate = versDateTime;
                method.sDefPID = element;
                method.methodName = element2.methodName;
                method.methodParmDefs = element2.methodParms;
                objectMethods.add(method);
            }
        }
        return objectMethods.toArray(new ObjectMethodsDef[0]);
    }

    public ObjectProfile getObjectProfile(Context context, String PID2, Date asOfDateTime) throws ServerException {
        return null;
    }

    public FieldSearchResult findObjects(Context context, String[] resultFields, int maxResults, FieldSearchQuery query) throws ServerException {
        return null;
    }

    public FieldSearchResult resumeFindObjects(Context context, String sessionToken) throws ServerException {
        return null;
    }

    public RepositoryInfo describeRepository(Context context) throws ServerException {
        return null;
    }

    public String[] getObjectHistory(Context context, String PID2) throws ServerException {
        return null;
    }

    public boolean isDynamicDeployment(Context context, String PID2, String sDefPID) throws ServerException {
        return this.dynamicServiceToDeployment.containsKey(sDefPID);
    }

    public MIMETypedStream getDatastreamDissemination(Context context, String PID2, String dsID, Date asOfDateTime) throws ServerException {
        return null;
    }

    public DatastreamDef[] listDatastreams(Context context, String PID2, Date asOfDateTime) throws ServerException {
        return null;
    }
}

