/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.SpringAccessServlet;
import org.fcrepo.server.errors.DisseminationException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.BadRequest400Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.NotFound404Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListMethodsServlet
extends SpringAccessServlet
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(ListMethodsServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    private String requestURI = null;
    private static String HTTP = "http";
    private static String HTTPS = "https";
    private static final String ACTION_LABEL = "List Methods";
    private String m_fedoraServerHost = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String PID2 = null;
        Date asOfDateTime = null;
        Date versDateTime = null;
        boolean xml = false;
        this.requestURI = request.getRequestURL().toString() + "?" + request.getQueryString();
        String[] URIArray = request.getRequestURL().toString().split("/");
        if (URIArray.length == 6 || URIArray.length == 7) {
            try {
                PID2 = Server.getPID(URIArray[5]).toString();
            }
            catch (Throwable th) {
                logger.error("Bad pid syntax in request", th);
                throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
            }
            if (URIArray.length == 7) {
                try {
                    versDateTime = DateUtility.parseDateStrict((String)URIArray[6]);
                }
                catch (ParseException e) {
                    logger.error("Bad date format in request");
                    throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
                }
                asOfDateTime = versDateTime;
            }
        } else {
            logger.error("Bad syntax (expected 6 or 7 parts) in request");
            throw new BadRequest400Exception(request, ACTION_LABEL, "", new String[0]);
        }
        logger.debug("Listing methods (PID=" + PID2 + ", asOfDate=" + versDateTime + ")");
        if (request.getParameter("xml") != null) {
            xml = new Boolean(request.getParameter("xml"));
        }
        try {
            ReadOnlyContext context = ReadOnlyContext.getContext(ListMethodsServlet.HTTP_REQUEST.REST.uri, request);
            this.listMethods(context, PID2, asOfDateTime, xml, request, response);
            logger.debug("Finished listing methods");
        }
        catch (ObjectNotFoundException e) {
            logger.error("Object not found for request: " + this.requestURI + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e);
            throw new NotFound404Exception(request, ACTION_LABEL, "", new String[0]);
        }
        catch (DisseminationException e) {
            logger.error("Error Listing Methods: " + this.requestURI + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e);
            throw new NotFound404Exception("Error Listing Methods", e, request, ACTION_LABEL, "", new String[0]);
        }
        catch (ObjectNotInLowlevelStorageException e) {
            logger.error("Object not found for request: " + this.requestURI + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e);
            throw new NotFound404Exception(request, ACTION_LABEL, "", new String[0]);
        }
        catch (AuthzException ae) {
            logger.error("Authorization error listing methods", (Throwable)ae);
            throw RootException.getServletException(ae, request, ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            logger.error("Error listing methods", th);
            throw new InternalError500Exception("Error listing methods", th, request, ACTION_LABEL, "", new String[0]);
        }
    }

    public void listMethods(Context context, String PID2, Date asOfDateTime, boolean xml, HttpServletRequest request, HttpServletResponse response) throws ServerException {
        OutputStreamWriter out = null;
        Date versDateTime = asOfDateTime;
        ObjectMethodsDef[] methodDefs = null;
        PipedWriter pw = null;
        PipedReader pr = null;
        try {
            pw = new PipedWriter();
            pr = new PipedReader(pw);
            methodDefs = this.m_access.listMethods(context, PID2, asOfDateTime);
            new ObjectMethodsDefSerializerThread(context, PID2, methodDefs, versDateTime, pw).start();
            if (xml) {
                response.setContentType(CONTENT_TYPE_XML);
                out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                int bufSize = 4096;
                char[] buf = new char[bufSize];
                int len = 0;
                while ((len = pr.read(buf, 0, bufSize)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
            } else {
                response.setContentType(CONTENT_TYPE_HTML);
                out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                File xslFile = new File(this.m_server.getHomeDir(), "access/listMethods.xslt");
                TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
                Templates template = factory.newTemplates(new StreamSource(xslFile));
                Transformer transformer = template.newTransformer();
                transformer.setParameter("fedora", context.getEnvironmentValue("FEDORA_CONTEXT_NAME"));
                transformer.transform(new StreamSource(pr), new StreamResult(out));
            }
            out.flush();
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Throwable th) {
            String message = "Error listing methods";
            logger.error(message, th);
            throw new GeneralException(message, th);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable th) {
                String message = "[ListMethodsServlet] An error has occured.  The error was a \" " + th.getClass().getName() + " \". Reason: " + th.getMessage();
                throw new StreamIOException(message);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_fedoraServerHost = this.m_server.getParameter("fedoraServerHost");
    }

    public class ObjectMethodsDefSerializerThread
    extends Thread {
        private PipedWriter pw = null;
        private String PID = null;
        private ObjectMethodsDef[] methodDefs = null;
        private Date versDateTime = null;
        private String fedoraServerProtocol = null;
        private String fedoraServerPort = null;
        private String fedoraAppServerContext = null;

        public ObjectMethodsDefSerializerThread(Context context, String PID2, ObjectMethodsDef[] methodDefs, Date versDateTime, PipedWriter pw) {
            this.pw = pw;
            this.PID = PID2;
            this.methodDefs = methodDefs;
            this.versDateTime = versDateTime;
            this.fedoraServerPort = context.getEnvironmentValue(Constants.HTTP_REQUEST.SERVER_PORT.uri);
            this.fedoraAppServerContext = context.getEnvironmentValue("FEDORA_CONTEXT_NAME");
            if (Constants.HTTP_REQUEST.SECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                this.fedoraServerProtocol = HTTPS;
            } else if (Constants.HTTP_REQUEST.INSECURE.uri.equals(context.getEnvironmentValue(Constants.HTTP_REQUEST.SECURITY.uri))) {
                this.fedoraServerProtocol = HTTP;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pw != null) {
                try {
                    this.pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.pw.write("<objectMethods");
                    this.pw.write(" pid=\"" + this.PID + "\"");
                    if (this.versDateTime != null) {
                        this.pw.write(" asOfDateTime=\"");
                        this.pw.write(DateUtility.convertDateToString((Date)this.versDateTime));
                        this.pw.write("\"");
                    }
                    this.pw.write(" baseURL=\"" + StreamUtility.enc(this.fedoraServerProtocol) + "://" + StreamUtility.enc(ListMethodsServlet.this.m_fedoraServerHost) + ":" + StreamUtility.enc(this.fedoraServerPort) + "/" + this.fedoraAppServerContext + "/\"");
                    this.pw.write(" xmlns=\"" + Constants.OBJ_METHODS1_0.namespace.uri + "\" ");
                    this.pw.write(" xmlns:xsi=\"" + Constants.XSI.uri + "\" ");
                    this.pw.write(" xsi:schemaLocation=\"" + Constants.OBJ_METHODS1_0.namespace.uri);
                    this.pw.write(" " + Constants.OBJ_METHODS1_0.xsdLocation + "\">");
                    String nextSdef = "null";
                    String currentSdef = "";
                    for (int i = 0; i < this.methodDefs.length; ++i) {
                        MethodParmDef[] methodParms;
                        currentSdef = this.methodDefs[i].sDefPID;
                        if (!currentSdef.equalsIgnoreCase(nextSdef)) {
                            if (i != 0) {
                                this.pw.write("</sDef>");
                            }
                            this.pw.write("<sDef pid=\"" + StreamUtility.enc(this.methodDefs[i].sDefPID) + "\" >");
                        }
                        this.pw.write("<method name=\"" + StreamUtility.enc(this.methodDefs[i].methodName) + "\" >");
                        for (MethodParmDef element : methodParms = this.methodDefs[i].methodParmDefs) {
                            this.pw.write("<methodParm parmName=\"" + StreamUtility.enc(element.parmName) + "\" parmDefaultValue=\"" + StreamUtility.enc(element.parmDefaultValue) + "\" parmRequired=\"" + element.parmRequired + "\" parmLabel=\"" + StreamUtility.enc(element.parmLabel) + "\" >");
                            if (element.parmDomainValues.length > 0) {
                                this.pw.write("<methodParmDomain>");
                                for (String element2 : element.parmDomainValues) {
                                    this.pw.write("<methodParmValue>" + StreamUtility.enc(element2) + "</methodParmValue>");
                                }
                                this.pw.write("</methodParmDomain>");
                            }
                            this.pw.write("</methodParm>");
                        }
                        this.pw.write("</method>");
                        nextSdef = currentSdef;
                    }
                    this.pw.write("</sDef>");
                    this.pw.write("</objectMethods>");
                    this.pw.flush();
                    this.pw.close();
                }
                catch (IOException ioe) {
                    logger.error("WriteThread error", (Throwable)ioe);
                }
                finally {
                    try {
                        if (this.pw != null) {
                            this.pw.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("WriteThread error", (Throwable)ioe);
                    }
                }
            }
        }
    }
}

