/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodParameterResolverServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(MethodParameterResolverServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String HTML_CONTENT_TYPE = "text/html; charset=UTF-8";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String PID2 = null;
        String sDefPID = null;
        String methodName = null;
        String versDateTime = null;
        StringBuffer methodParms = new StringBuffer();
        response.setContentType(HTML_CONTENT_TYPE);
        Hashtable<String, String> h_methodParms = new Hashtable<String, String>();
        Enumeration parms = request.getParameterNames();
        while (parms.hasMoreElements()) {
            String name = (String)parms.nextElement();
            if (name.equals("PID")) {
                PID2 = request.getParameter(name);
                continue;
            }
            if (name.equals("sDefPID")) {
                sDefPID = request.getParameter(name);
                continue;
            }
            if (name.equals("methodName")) {
                methodName = request.getParameter(name);
                continue;
            }
            if (name.equals("asOfDateTime")) {
                versDateTime = request.getParameter(name).trim();
                if (!versDateTime.equalsIgnoreCase("null") && !versDateTime.equalsIgnoreCase("")) continue;
                versDateTime = null;
                continue;
            }
            if (name.equals("Submit")) continue;
            h_methodParms.put(name, request.getParameter(name));
        }
        if (PID2 == null || PID2.equalsIgnoreCase("") || sDefPID == null || sDefPID.equalsIgnoreCase("") || methodName == null || methodName.equalsIgnoreCase("")) {
            String message = "[MethodParameterResolverServlet] Insufficient information to construct dissemination request. Parameters received from web form were: PID: " + PID2 + " -- sDefPID: " + sDefPID + " -- methodName: " + methodName + " -- methodParms: " + methodParms.toString() + "\".  ";
            logger.error(message);
            response.setStatus(500);
            response.sendError(500, message);
        } else {
            StringBuffer redirectURL = new StringBuffer();
            redirectURL.append(request.getContextPath() + "/get/" + PID2 + "/" + sDefPID + "/" + methodName);
            int i = 0;
            Enumeration e = h_methodParms.keys();
            while (e.hasMoreElements()) {
                String name = URLEncoder.encode((String)e.nextElement(), "UTF-8");
                String value = URLEncoder.encode((String)h_methodParms.get(name), "UTF-8");
                if (++i == h_methodParms.size()) {
                    methodParms.append(name + "=" + value);
                    continue;
                }
                methodParms.append(name + "=" + value + "&");
            }
            if (h_methodParms.size() > 0) {
                if (versDateTime == null || versDateTime.equalsIgnoreCase("")) {
                    redirectURL.append("?" + methodParms.toString());
                } else {
                    redirectURL.append("/" + versDateTime + "?" + methodParms.toString());
                }
            } else if (versDateTime == null || versDateTime.equalsIgnoreCase("")) {
                redirectURL.append("/");
            } else {
                redirectURL.append("/" + versDateTime + "/");
            }
            response.sendRedirect(redirectURL.toString());
        }
    }

    public void destroy() {
    }
}

