/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.common.Constants;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.access.SpringAccessServlet;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.security.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TriplestoreReader;
import org.trippi.TriplestoreWriter;
import org.trippi.TupleIterator;
import org.trippi.server.TrippiServer;
import org.trippi.server.http.Styler;

public class RISearchServlet
extends SpringAccessServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RISearchServlet.class);
    private static final String ACTION_LABEL = "Resource Index Search";
    private Authorization m_authorization;
    private ResourceIndex m_writer;
    private TrippiServer m_trippi;
    private Styler m_styler;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_writer = this.m_server.getBean("org.fcrepo.server.resourceIndex.ResourceIndex", ResourceIndex.class);
        this.m_authorization = this.m_server.getBean("org.fcrepo.server.security.Authorization", Authorization.class);
        try {
            String indexStylesheetPath = this.getPath(this.getIndexStylesheetLocation());
            String formStylesheetPath = this.getPath(this.getFormStylesheetLocation());
            String errorStylesheetPath = this.getPath(this.getErrorStylesheetLocation());
            this.m_styler = new Styler(indexStylesheetPath, formStylesheetPath, errorStylesheetPath);
        }
        catch (Exception e) {
            throw new ServletException("Error loading stylesheet(s)", (Throwable)e);
        }
    }

    private String getPath(String loc) {
        if (loc == null) {
            return null;
        }
        if (loc.startsWith("/")) {
            String foo = this.getServletContext().getRealPath("/foo");
            File dir = new File(foo).getParentFile().getParentFile();
            File file = new File(dir, loc);
            return file.toString();
        }
        return this.getServletContext().getRealPath(loc);
    }

    public TrippiServer getTrippiServer() throws ServletException {
        if (this.m_trippi == null) {
            this.m_trippi = new TrippiServer(this.getWriter());
        }
        return this.m_trippi;
    }

    public TriplestoreWriter getWriter() throws ServletException {
        if (this.m_writer == null || this.m_writer.getIndexLevel() == 0) {
            throw new ServletException("The Resource Index Module is not enabled.");
        }
        return this.m_writer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        try {
            this.doGet(this.getTrippiServer(), request, response);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable th) {
            try {
                response.setContentType("text/html; charset=UTF-8");
                response.setStatus(500);
                StringWriter sWriter = new StringWriter();
                PrintWriter out = new PrintWriter(sWriter);
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                out.println("<error context=\"" + this.enc(this.getContext(request.getContextPath())) + "\">");
                out.println("<message>" + this.enc(this.getLongestMessage(th, "Error")) + "</message>");
                out.print("<detail><![CDATA[");
                th.printStackTrace(out);
                out.println("]]></detail>");
                out.println("</error>");
                out.flush();
                out.close();
                PrintWriter reallyOut = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
                this.m_styler.sendError(sWriter.toString(), reallyOut);
                reallyOut.flush();
                reallyOut.close();
            }
            catch (Exception e2) {
                this.log("Error sending error response to browser.", e2);
                throw new ServletException(th);
            }
        }
    }

    private String enc(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '\'') {
                out.append("&apos;");
                continue;
            }
            if (c == '\"') {
                out.append("&quot;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private String getLongestMessage(Throwable th, String longestSoFar) {
        Throwable cause;
        if (th.getMessage() != null && th.getMessage().length() > longestSoFar.length()) {
            longestSoFar = th.getMessage();
        }
        if ((cause = th.getCause()) == null) {
            return longestSoFar;
        }
        return this.getLongestMessage(cause, longestSoFar);
    }

    private void doGet(TrippiServer server, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("doGet()\n  type: " + request.getParameter("type") + "\n" + "  template: " + request.getParameter("template") + "\n" + "  lang: " + request.getParameter("lang") + "\n" + "  query: " + request.getParameter("query") + "\n" + "  limit: " + request.getParameter("limit") + "\n" + "  distinct: " + request.getParameter("distinct") + "\n" + "  format: " + request.getParameter("format") + "\n" + "  flush: " + request.getParameter("flush") + "\n" + "  dumbTypes: " + request.getParameter("dumbTypes") + "\n");
        }
        try {
            ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
            this.m_authorization.enforceRIFindObjects(context);
            this.doSearch(server, request, response);
        }
        catch (AuthzException e) {
            logger.error("Authorization failed for request: " + request.getRequestURI() + " (actionLabel=" + ACTION_LABEL + ")", (Throwable)e);
            throw RootException.getServletException(e, request, ACTION_LABEL, new String[0]);
        }
        catch (Throwable th) {
            logger.error("Unexpected error servicing API-A request", th);
            throw new InternalError500Exception("", th, request, ACTION_LABEL, "", new String[0]);
        }
    }

    private void doSearch(TrippiServer server, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (server == null) {
            throw new ServletException("No such triplestore.");
        }
        String type = request.getParameter("type");
        String template = request.getParameter("template");
        String lang = request.getParameter("lang");
        String query = request.getParameter("query");
        String limit = request.getParameter("limit");
        String distinct = request.getParameter("distinct");
        String format = request.getParameter("format");
        String dumbTypes = request.getParameter("dt");
        String stream = request.getParameter("stream");
        boolean streamImmediately = stream != null && (stream.toLowerCase().startsWith("t") || stream.toLowerCase().equals("on"));
        String flush = request.getParameter("flush");
        if (type == null && template == null && lang == null && query == null && limit == null && distinct == null && format == null) {
            TriplestoreWriter writer;
            boolean doFlush;
            if (flush == null || flush.equals("")) {
                flush = "false";
            }
            if ((doFlush = flush.toLowerCase().startsWith("t")) && (writer = server.getWriter()) != null) {
                writer.flushBuffer();
            }
            response.setContentType("text/html; charset=UTF-8");
            this.doForm(server, new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8")), request.getRequestURL().toString(), request.getContextPath());
        } else {
            this.doFind(server, type, template, lang, query, limit, distinct, format, dumbTypes, streamImmediately, flush, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doForm(TrippiServer server, PrintWriter out, String requestURI, String contextPath) throws Exception {
        try {
            int i;
            int i2;
            StringWriter sWriter = new StringWriter();
            PrintWriter sout = new PrintWriter(sWriter);
            sout.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            TriplestoreReader reader = server.getReader();
            String href = this.enc(requestURI.replaceAll("/$", ""));
            sout.println("<query-service href=\"" + href + "\" context=\"" + this.enc(this.getContext(contextPath)) + "\">");
            sout.println("  <alias-map>");
            Map map = reader.getAliasMap();
            for (String name : map.keySet()) {
                String uri = (String)map.get(name);
                sout.println("    <alias name=\"" + name + "\" uri=\"" + this.enc(uri) + "\"/>");
            }
            sout.println("  </alias-map>");
            sout.println("  <triple-languages>");
            String[] langs = reader.listTripleLanguages();
            for (i2 = 0; i2 < langs.length; ++i2) {
                sout.println("    <language name=\"" + this.enc(langs[i2]) + "\"/>");
            }
            sout.println("  </triple-languages>");
            langs = reader.listTupleLanguages();
            sout.println("  <tuple-languages>");
            for (i2 = 0; i2 < langs.length; ++i2) {
                sout.println("    <language name=\"" + this.enc(langs[i2]) + "\"/>");
            }
            sout.println("  </tuple-languages>");
            sout.println("  <triple-output-formats>");
            RDFFormat[] formats = TripleIterator.OUTPUT_FORMATS;
            for (i = 0; i < formats.length; ++i) {
                sout.println("    <format name=\"" + this.enc(formats[i].getName()) + "\" encoding=\"" + formats[i].getEncoding() + "\" media-type=\"" + formats[i].getMediaType() + "\" extension=\"" + formats[i].getExtension() + "\"/>");
            }
            sout.println("  </triple-output-formats>");
            sout.println("  <tuple-output-formats>");
            formats = TupleIterator.OUTPUT_FORMATS;
            for (i = 0; i < formats.length; ++i) {
                sout.println("    <format name=\"" + this.enc(formats[i].getName()) + "\" encoding=\"" + formats[i].getEncoding() + "\" media-type=\"" + formats[i].getMediaType() + "\" extension=\"" + formats[i].getExtension() + "\"/>");
            }
            sout.println("  </tuple-output-formats>");
            sout.println("</query-service>");
            sout.flush();
            this.m_styler.sendForm(sWriter.toString(), out);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                this.log("Error closing response", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFind(TrippiServer server, String type, String template, String lang, String query, String limit, String distinct, String format, String dumbTypes, boolean streamImmediately, String flush, HttpServletResponse response) throws Exception {
        block12: {
            OutputStream out = null;
            File tempFile = null;
            try {
                if (streamImmediately) {
                    String mediaType = TrippiServer.getResponseMediaType((String)format, (type == null || !type.equals("triples") ? 1 : 0) != 0, (boolean)TrippiServer.getBoolean((String)dumbTypes, (boolean)false));
                    try {
                        response.setContentType(mediaType + "; charset=UTF-8");
                        out = response.getOutputStream();
                        server.find(type, template, lang, query, limit, distinct, format, dumbTypes, flush, out);
                        break block12;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ServletException("Error querying", (Throwable)e);
                    }
                }
                tempFile = File.createTempFile("trippi", "result");
                FileOutputStream tempOut = new FileOutputStream(tempFile);
                String mediaType = server.find(type, template, lang, query, limit, distinct, format, dumbTypes, flush, (OutputStream)tempOut);
                tempOut.close();
                response.setContentType(mediaType + "; charset=UTF-8");
                out = response.getOutputStream();
                FileInputStream results = new FileInputStream(tempFile);
                this.sendStream(results, out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                this.log("Could not close result inputstream.");
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getIndexStylesheetLocation() {
        return "ri/index.xsl";
    }

    private String getFormStylesheetLocation() {
        return "ri/form.xsl";
    }

    private String getErrorStylesheetLocation() {
        return "ri/error.xsl";
    }

    private String getContext(String origContext) {
        return "ri";
    }
}

