/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.access.dissemination;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.DisseminationBindingInfoNotFoundException;
import org.fcrepo.server.errors.DisseminationException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.security.BackendSecurity;
import org.fcrepo.server.security.BackendSecuritySpec;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.types.DatastreamMediation;
import org.fcrepo.server.storage.types.DeploymentDSBindRule;
import org.fcrepo.server.storage.types.DeploymentDSBindSpec;
import org.fcrepo.server.storage.types.DisseminationBindingInfo;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.MethodParmDef;
import org.fcrepo.server.utilities.ServerUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisseminationService {
    private static final Logger logger = LoggerFactory.getLogger(DisseminationService.class);
    private static final String LOCAL_ADDRESS_LOCATION = "LOCAL";
    private static int datastreamExpirationLimit = 0;
    private static int counter = 0;
    private boolean m_doDatastreamMediation;
    private boolean m_useNewUrlEncodingTest;
    private String m_fedoraServerHost = null;
    private String m_fedoraServerPort = null;
    private String m_fedoraAppServerContext = null;
    private String m_fedoraServerRedirectPort = null;
    private BackendSecuritySpec m_beSS = null;
    private final BackendSecurity m_beSecurity;
    private final ExternalContentManager m_ecm;
    private final Authorization m_authorization;
    protected static Hashtable<String, DatastreamMediation> dsRegistry = new Hashtable(1000);

    public DisseminationService(Server server) {
        this.m_fedoraServerHost = server.getParameter("fedoraServerHost");
        this.m_fedoraServerPort = server.getParameter("fedoraServerPort");
        this.m_fedoraAppServerContext = server.getParameter("fedoraAppServerContext");
        this.m_fedoraServerRedirectPort = server.getParameter("fedoraRedirectPort");
        this.m_beSecurity = (BackendSecurity)((Object)server.getModule("org.fcrepo.server.security.BackendSecurity"));
        this.m_beSS = this.m_beSecurity.getBackendSecuritySpec();
        String expireLimit = server.getParameter("datastreamExpirationLimit");
        if (expireLimit == null || expireLimit.equalsIgnoreCase("")) {
            logger.info("datastreamExpirationLimit unspecified; defaulting to 300 seconds");
            datastreamExpirationLimit = 300;
        } else {
            datastreamExpirationLimit = new Integer(expireLimit);
            logger.info("datastreamExpirationLimit=" + datastreamExpirationLimit);
        }
        String dsMediation = server.getModule("org.fcrepo.server.access.Access").getParameter("doMediateDatastreams");
        if (dsMediation == null || dsMediation.equalsIgnoreCase("")) {
            logger.info("doMediateDatastreams unspecified; defaulting to false");
        } else {
            this.m_doDatastreamMediation = new Boolean(dsMediation);
        }
        String useNewUrlEncodingTest = server.getModule("org.fcrepo.server.access.Access").getParameter("useNewUrlEncoding");
        if (useNewUrlEncodingTest == null || useNewUrlEncodingTest.equalsIgnoreCase("")) {
            logger.info("useNewUrlEncodingTest unspecified; defaulting to false");
        } else {
            this.m_useNewUrlEncodingTest = new Boolean(useNewUrlEncodingTest);
        }
        this.m_ecm = server.getBean("org.fcrepo.server.storage.ExternalContentManager", ExternalContentManager.class);
        this.m_authorization = server.getBean("org.fcrepo.server.security.Authorization", Authorization.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MIMETypedStream assembleDissemination(Context context, String PID2, Hashtable<String, String> h_userParms, DisseminationBindingInfo[] dissBindInfoArray, String deploymentPID, ServiceDeploymentReader bmReader, String methodName) throws ServerException {
        logger.debug("Started assembling dissemination");
        String dissURL = null;
        String protocolType = null;
        DisseminationBindingInfo dissBindInfo = null;
        MIMETypedStream dissemination = null;
        boolean isRedirect = false;
        if (logger.isDebugEnabled()) {
            DisseminationService.printBindingInfo(dissBindInfoArray);
        }
        if (dissBindInfoArray != null && dissBindInfoArray.length > 0) {
            DeploymentDSBindRule[] rules;
            String replaceString = null;
            int numElements = dissBindInfoArray.length;
            for (int i = 0; i < dissBindInfoArray.length; ++i) {
                String[] parts;
                this.m_authorization.enforce_Internal_DSState(context, dissBindInfoArray[i].dsID, dissBindInfoArray[i].dsState);
                dissBindInfo = dissBindInfoArray[i];
                if (dissBindInfo.dsLocation != null && (dissBindInfo.dsLocation.startsWith("http://") || dissBindInfo.dsLocation.startsWith("https://")) && (parts = dissBindInfo.dsLocation.split("=\\(")).length > 1) {
                    StringBuffer replaced = new StringBuffer();
                    replaced.append(parts[0]);
                    for (int x = 1; x < parts.length; ++x) {
                        replaced.append('=');
                        int rightParenPos = parts[x].indexOf(")");
                        if (rightParenPos != -1 && rightParenPos > 0) {
                            String key = parts[x].substring(0, rightParenPos);
                            String val = h_userParms.get(key);
                            if (val != null) {
                                try {
                                    replaced.append(URLEncoder.encode(val, "UTF-8"));
                                }
                                catch (UnsupportedEncodingException uee) {
                                    // empty catch block
                                }
                                if (rightParenPos >= parts[x].length()) continue;
                                replaced.append(parts[x].substring(rightParenPos + 1));
                                continue;
                            }
                            replaced.append('(');
                            replaced.append(parts[x]);
                            continue;
                        }
                        replaced.append('(');
                        replaced.append(parts[x]);
                    }
                    dissBindInfo.dsLocation = replaced.toString();
                }
                String bindingKeyPattern = "\\(" + dissBindInfo.DSBindKey + "\\)";
                if (i == 0) {
                    if (dissBindInfo.AddressLocation.equalsIgnoreCase(LOCAL_ADDRESS_LOCATION)) {
                        dissURL = dissBindInfo.OperationLocation;
                    } else {
                        dissURL = dissBindInfo.AddressLocation + dissBindInfo.OperationLocation;
                        dissURL = dissURL.replaceAll(this.m_fedoraServerHost + ":" + this.m_fedoraServerPort + "/fedora/", this.m_fedoraServerHost + ":" + this.m_fedoraServerPort + "/" + this.m_fedoraAppServerContext + "/");
                    }
                    protocolType = dissBindInfo.ProtocolType;
                }
                String callbackRole = deploymentPID;
                Hashtable<String, String> beHash = this.m_beSS.getSecuritySpec(callbackRole, methodName);
                boolean callbackBasicAuth = new Boolean(beHash.get("callbackBasicAuth"));
                boolean callbackSSL = new Boolean(beHash.get("callbackSSL"));
                String dsMediatedServletPath = null;
                dsMediatedServletPath = callbackBasicAuth ? "/" + this.m_fedoraAppServerContext + "/getDSAuthenticated?id=" : "/" + this.m_fedoraAppServerContext + "/getDS?id=";
                String dsMediatedCallbackHost = null;
                dsMediatedCallbackHost = callbackSSL ? "https://" + this.m_fedoraServerHost + ":" + this.m_fedoraServerRedirectPort : "http://" + this.m_fedoraServerHost + ":" + this.m_fedoraServerPort;
                String datastreamResolverServletURL = dsMediatedCallbackHost + dsMediatedServletPath;
                if (logger.isDebugEnabled()) {
                    logger.debug("******************Checking backend service dsLocation: {}", (Object)dissBindInfo.dsLocation);
                    logger.debug("******************Checking backend service dsControlGroupType: {}", (Object)dissBindInfo.dsControlGroupType);
                    logger.debug("******************Checking backend service callbackBasicAuth: {}", (Object)callbackBasicAuth);
                    logger.debug("******************Checking backend service callbackSSL: {}", (Object)callbackSSL);
                    logger.debug("******************Checking backend service callbackRole: {}", (Object)callbackRole);
                    logger.debug("******************DatastreamResolverServletURL: {}", (Object)datastreamResolverServletURL);
                }
                String currentKey = dissBindInfo.DSBindKey;
                String nextKey = "";
                if (i != numElements - 1) {
                    nextKey = dissBindInfoArray[i + 1].DSBindKey;
                }
                logger.debug("currentKey: '" + currentKey + "', nextKey: '" + nextKey + "'");
                if (nextKey.equalsIgnoreCase(currentKey) & i != numElements) {
                    if (this.m_doDatastreamMediation && !dissBindInfo.dsControlGroupType.equalsIgnoreCase("R")) {
                        replaceString = datastreamResolverServletURL + this.registerDatastreamLocation(dissBindInfo.dsLocation, dissBindInfo.dsControlGroupType, callbackRole, methodName) + "+(" + dissBindInfo.DSBindKey + ")";
                    } else {
                        replaceString = dissBindInfo.dsControlGroupType.equalsIgnoreCase("M") || dissBindInfo.dsControlGroupType.equalsIgnoreCase("X") ? this.resolveInternalDSLocation(context, dissBindInfo.dsLocation, dissBindInfo.dsCreateDT, dsMediatedCallbackHost) + "+(" + dissBindInfo.DSBindKey + ")" : dissBindInfo.dsLocation + "+(" + dissBindInfo.DSBindKey + ")";
                        if (dissBindInfo.dsControlGroupType.equalsIgnoreCase("R") && dissBindInfo.AddressLocation.equals(LOCAL_ADDRESS_LOCATION)) {
                            isRedirect = true;
                        }
                    }
                } else if (this.m_doDatastreamMediation && !dissBindInfo.dsControlGroupType.equalsIgnoreCase("R")) {
                    replaceString = datastreamResolverServletURL + this.registerDatastreamLocation(dissBindInfo.dsLocation, dissBindInfo.dsControlGroupType, callbackRole, methodName);
                } else {
                    replaceString = dissBindInfo.dsControlGroupType.equalsIgnoreCase("M") || dissBindInfo.dsControlGroupType.equalsIgnoreCase("X") ? this.resolveInternalDSLocation(context, dissBindInfo.dsLocation, dissBindInfo.dsCreateDT, dsMediatedCallbackHost) : dissBindInfo.dsLocation;
                    if (dissBindInfo.dsControlGroupType.equalsIgnoreCase("R") && dissBindInfo.AddressLocation.equals(LOCAL_ADDRESS_LOCATION)) {
                        isRedirect = true;
                    }
                }
                try {
                    boolean useUrlEncoding;
                    boolean bl = this.m_useNewUrlEncodingTest ? dissURL.indexOf("(" + bindingKeyPattern + ")") > 0 : (useUrlEncoding = dissURL.indexOf("=(") != -1);
                    dissURL = useUrlEncoding ? this.substituteString(dissURL, bindingKeyPattern, URLEncoder.encode(replaceString, "UTF-8")) : this.substituteString(dissURL, bindingKeyPattern, replaceString);
                }
                catch (UnsupportedEncodingException uee) {
                    String message = "[DisseminationService] An error occured. The error was \"" + uee.getClass().getName() + "\"  . The Reason was \"" + uee.getMessage() + "\"  . String value: " + replaceString + "  . ";
                    logger.error(message);
                    throw new GeneralException(message);
                }
                logger.debug("Replaced dissURL: " + dissURL.toString() + " DissBindingInfo index: " + i);
            }
            DeploymentDSBindSpec dsBindSpec = bmReader.getServiceDSInputSpec(null);
            for (DeploymentDSBindRule element : rules = dsBindSpec.dsBindRules) {
                String rulePattern = "(" + element.bindingKeyName + ")";
                if (dissURL.indexOf(rulePattern) == -1) continue;
                throw new DisseminationException(null, "Data Object " + PID2 + " missing required datastream: " + element.bindingKeyName, null, null, null);
            }
            Enumeration<String> e = h_userParms.keys();
            while (e.hasMoreElements()) {
                String name = null;
                String value = null;
                try {
                    name = URLEncoder.encode(e.nextElement(), "UTF-8");
                    value = URLEncoder.encode(h_userParms.get(name), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    String message = "[DisseminationService] An error occured. The error was \"" + uee.getClass().getName() + "\"  . The Reason was \"" + uee.getMessage() + "\"  . Parameter name: " + name + "  . " + "Parameter value: " + value + "  .";
                    logger.error(message);
                    throw new GeneralException(message);
                }
                String pattern = "\\(" + name + "\\)";
                dissURL = this.substituteString(dissURL, pattern, value);
                logger.debug("User parm substituted in URL: " + dissURL);
            }
            if (dissURL.indexOf("(") != -1) {
                dissURL = this.stripParms(dissURL);
                logger.debug("Non-supplied optional userInputParm values removed from URL: " + dissURL);
            }
            if (dissURL.indexOf("(") != -1) {
                String datastreamName = dissURL.substring(dissURL.indexOf("(") + 1, dissURL.indexOf(")"));
                throw new DisseminationException(null, "Data Object " + PID2 + " missing required datastream: " + datastreamName, null, null, null);
            }
            logger.debug("ProtocolType: " + protocolType);
            if (protocolType.equalsIgnoreCase("http")) {
                if (isRedirect) {
                    ByteArrayInputStream is = null;
                    try {
                        is = new ByteArrayInputStream(dissURL.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        String message = "[DisseminationService] An error has occurred. The error was a \"" + uee.getClass().getName() + "\"  . The " + "Reason was \"" + uee.getMessage() + "\"  . String value: " + dissURL + "  . ";
                        logger.error(message);
                        throw new GeneralException(message);
                    }
                    logger.debug("Finished assembling dissemination");
                    return new MIMETypedStream("application/fedora-redirect", is, null);
                }
                logger.debug("Finished assembling dissemination, URL={}", (Object)dissURL);
                String beServiceRole = null;
                beServiceRole = ServerUtility.isURLFedoraServer(dissURL) ? "fedoraInternalCall-1" : deploymentPID;
                Hashtable<String, String> beHash = this.m_beSS.getSecuritySpec(beServiceRole, methodName);
                boolean beServiceCallSSL = new Boolean(beHash.get("callSSL"));
                String beServiceCallUsername = "";
                String beServiceCallPassword = "";
                boolean beServiceCallBasicAuth = new Boolean(beHash.get("callBasicAuth"));
                if (beServiceCallBasicAuth) {
                    beServiceCallUsername = beHash.get("callUsername");
                    beServiceCallPassword = beHash.get("callPassword");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("******************getDisseminationContent beServiceRole: {}", (Object)beServiceRole);
                    logger.debug("******************getDisseminationContent beServiceCallBasicAuth: {}", (Object)beServiceCallBasicAuth);
                    logger.debug("******************getDisseminationContent beServiceCallSSL: {}", (Object)beServiceCallSSL);
                    logger.debug("******************getDisseminationContent beServiceCallUsername: {}", (Object)beServiceCallUsername);
                    logger.debug("******************getDisseminationContent beServiceCallPassword: {}", (Object)beServiceCallPassword);
                    logger.debug("******************getDisseminationContent dissURL: {}", (Object)dissURL);
                }
                ContentManagerParams params = new ContentManagerParams(dissURL, null, beServiceCallUsername, beServiceCallPassword);
                params.setBypassBackend(true);
                params.setContext(context);
                return this.m_ecm.getExternalContent(params);
            }
            if (protocolType.equalsIgnoreCase("soap")) {
                String message = "[DisseminationService] Protocol type: " + protocolType + "NOT yet implemented";
                logger.error(message);
                throw new DisseminationException(message);
            }
            if (protocolType.equalsIgnoreCase("file")) {
                ContentManagerParams params = new ContentManagerParams(dissURL);
                params.setContext(context);
                return this.m_ecm.getExternalContent(params);
            }
            String message = "[DisseminationService] Protocol type: " + protocolType + "NOT supported.";
            logger.error(message);
            throw new DisseminationException(message);
        }
        String message = "[DisseminationService] Dissemination Binding Info contained no data";
        logger.error(message);
        throw new DisseminationBindingInfoNotFoundException(message);
    }

    public String registerDatastreamLocation(String dsLocation, String dsControlGroupType, String beServiceCallbackRole, String methodName) throws ServerException {
        String tempID = null;
        Timestamp timeStamp = null;
        if (counter > 999999) {
            counter = 0;
        }
        long currentTime = new Timestamp(new Date().getTime()).getTime();
        long expireLimit = currentTime - (long)datastreamExpirationLimit * 1000L;
        try {
            Enumeration<String> e = dsRegistry.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                timeStamp = Timestamp.valueOf(this.extractTimestamp(key));
                if (expireLimit <= timeStamp.getTime()) continue;
                dsRegistry.remove(key);
                logger.debug("DatastreamMediationKey removed from Hash: " + key);
            }
            if (tempID == null) {
                timeStamp = new Timestamp(new Date().getTime());
                tempID = timeStamp.toString() + ":" + counter++;
                DatastreamMediation dm = new DatastreamMediation();
                dm.mediatedDatastreamID = tempID;
                dm.dsLocation = dsLocation;
                dm.dsControlGroupType = dsControlGroupType;
                dm.methodName = methodName;
                String beServiceRole = null;
                beServiceRole = ServerUtility.isURLFedoraServer(dsLocation) || dsControlGroupType.equals("M") || dsControlGroupType.equals("X") ? "fedoraInternalCall-1" : beServiceCallbackRole;
                Hashtable<String, String> beHash = this.m_beSS.getSecuritySpec(beServiceRole, methodName);
                boolean beServiceCallbackBasicAuth = new Boolean(beHash.get("callbackBasicAuth"));
                boolean beServiceCallBasicAuth = new Boolean(beHash.get("callBasicAuth"));
                boolean beServiceCallbackSSL = new Boolean(beHash.get("callbackSSL"));
                boolean beServiceCallSSL = new Boolean(beHash.get("callSSL"));
                String beServiceCallUsername = beHash.get("callUsername");
                String beServiceCallPassword = beHash.get("callPassword");
                if (logger.isDebugEnabled()) {
                    logger.debug("******************Registering datastream dsLocation: {}", (Object)dsLocation);
                    logger.debug("******************Registering datastream dsControlGroupType: {}", (Object)dsControlGroupType);
                    logger.debug("******************Registering datastream beServiceRole: {}", (Object)beServiceRole);
                    logger.debug("******************Registering datastream beServiceCallbackBasicAuth: {}", (Object)beServiceCallbackBasicAuth);
                    logger.debug("******************Registering datastream beServiceCallBasicAuth: {}", (Object)beServiceCallBasicAuth);
                    logger.debug("******************Registering datastream beServiceCallbackSSL: {}", (Object)beServiceCallbackSSL);
                    logger.debug("******************Registering datastream beServiceCallSSL: {}", (Object)beServiceCallSSL);
                    logger.debug("******************Registering datastream beServiceCallUsername: {}", (Object)beServiceCallUsername);
                    logger.debug("******************Registering datastream beServiceCallPassword: {}", (Object)beServiceCallPassword);
                }
                dm.callbackRole = beServiceRole;
                dm.callUsername = beServiceCallUsername;
                dm.callPassword = beServiceCallPassword;
                dm.callbackBasicAuth = beServiceCallbackBasicAuth;
                dm.callBasicAuth = beServiceCallBasicAuth;
                dm.callbackSSL = beServiceCallbackSSL;
                dm.callSSL = beServiceCallSSL;
                dsRegistry.put(tempID, dm);
                logger.debug("DatastreammediationKey added to Hash: " + tempID);
            }
        }
        catch (Throwable th) {
            throw new DisseminationException("[DisseminationService] registerDatastreamLocation: returned an error. The underlying error was a " + th.getClass().getName() + " The message " + "was \"" + th.getMessage() + "\" .");
        }
        return tempID.replaceAll(" ", "T");
    }

    public String extractTimestamp(String tempID) {
        StringBuffer sb = new StringBuffer();
        sb.append(tempID);
        sb.replace(tempID.lastIndexOf(":"), tempID.length(), "");
        return sb.toString();
    }

    private String substituteString(String inputString, String patternString, String replaceString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher m = pattern.matcher(inputString);
        return m.replaceAll(replaceString);
    }

    private String stripParms(String dissURL) {
        if (dissURL.indexOf("?") == -1) {
            return dissURL;
        }
        String requestURI = dissURL.substring(0, dissURL.indexOf("?") + 1);
        String parmString = dissURL.substring(dissURL.indexOf("?") + 1, dissURL.length());
        String[] parms = parmString.split("&");
        StringBuffer sb = new StringBuffer();
        for (String element : parms) {
            int len = element.length() - 1;
            if (element.lastIndexOf(")") == len) continue;
            sb.append(element + "&");
        }
        int index = sb.lastIndexOf("&");
        if (index != -1 && index + 1 == sb.length()) {
            sb.replace(index, sb.length(), "");
        }
        return requestURI + sb.toString();
    }

    private String resolveInternalDSLocation(Context context, String internalDSLocation, Date dsCreateDT, String callbackHost) throws ServerException {
        if (callbackHost == null || callbackHost.equals("")) {
            throw new DisseminationException("[DisseminationService] was unable to resolve the base URL of the Fedora Server. The URL specified was: \"" + callbackHost + "\". This information is required by the Dissemination Service.");
        }
        String[] s = internalDSLocation.split("\\+");
        String dsLocation = null;
        if (s.length != 3) {
            String message = "[DisseminationService] An error has occurred. The internal dsLocation: \"" + internalDSLocation + "\" is " + "not in the required format of: " + "\"doPID+DSID+DSVERSIONID\" .";
            logger.error(message);
            throw new GeneralException(message);
        }
        dsLocation = callbackHost + "/" + this.m_fedoraAppServerContext + "/get/" + s[0] + "/" + s[1] + "/" + DateUtility.convertDateToString((Date)dsCreateDT);
        logger.debug("********** Resolving Internal Datastream dsLocation: " + dsLocation);
        return dsLocation;
    }

    public static void printBindingInfo(DisseminationBindingInfo[] info) {
        for (int i = 0; i < info.length; ++i) {
            logger.debug("DisseminationBindingInfo[" + i + "]:");
            logger.debug("  DSBindKey          : " + info[i].DSBindKey);
            logger.debug("  dsLocation         : " + info[i].dsLocation);
            logger.debug("  dsControlGroupType : " + info[i].dsControlGroupType);
            logger.debug("  dsID               : " + info[i].dsID);
            logger.debug("  dsVersionID        : " + info[i].dsVersionID);
            logger.debug("  AddressLocation    : " + info[i].AddressLocation);
            logger.debug("  OperationLocation  : " + info[i].OperationLocation);
            logger.debug("  ProtocolType       : " + info[i].ProtocolType);
            logger.debug("  dsState            : " + info[i].dsState);
            logger.debug("  dsCreateDT         : " + info[i].dsCreateDT);
            for (int j = 0; j < info[i].methodParms.length; ++j) {
                MethodParmDef def = info[i].methodParms[j];
                logger.debug("  MethodParamDef[" + j + "]:");
                logger.debug("    parmName         : " + def.parmName);
                logger.debug("    parmDefaultValue : " + def.parmDefaultValue);
                logger.debug("    parmRequired     : " + def.parmRequired);
                logger.debug("    parmLabel        : " + def.parmLabel);
                logger.debug("    parmPassBy       : " + def.parmPassBy);
                for (String element : def.parmDomainValues) {
                    logger.debug("    parmDomainValue  : " + element);
                }
            }
        }
    }
}

