/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerConfigurationParser
extends DefaultHandler {
    private SAXParser m_parser;
    private final InputStream m_xmlStream;
    private String m_serverClassName;
    private List<Parameter> m_serverParameters;
    private List<ModuleConfiguration> m_moduleConfigurations;
    private List<DatastoreConfiguration> m_datastoreConfigurations;
    private Parameter m_lastParam;
    private String m_moduleOrDatastoreComment;
    private String m_role;
    private String m_class;
    private String m_id;
    private String m_paramName;
    private String m_paramValue;
    private String m_paramComment;
    private boolean m_paramIsFilePath;
    private Map<String, String> m_profileValues;
    private List<Parameter> m_moduleOrDatastoreParameters;
    private StringBuffer m_commentBuffer;
    private boolean m_inParam;
    private boolean m_inModuleOrDatastore;

    public ServerConfigurationParser(InputStream xmlStream) throws IOException {
        this.m_xmlStream = xmlStream;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            this.m_parser = spf.newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error getting XML parser: " + e.getMessage());
        }
    }

    public ServerConfiguration parse() throws IOException {
        this.m_serverParameters = new ArrayList<Parameter>();
        this.m_moduleConfigurations = new ArrayList<ModuleConfiguration>();
        this.m_datastoreConfigurations = new ArrayList<DatastoreConfiguration>();
        try {
            this.m_parser.parse(this.m_xmlStream, (DefaultHandler)this);
            return new ServerConfiguration(this.m_serverClassName, this.m_serverParameters, this.m_moduleConfigurations, this.m_datastoreConfigurations);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error parsing XML: " + e.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        if (localName.equals("server")) {
            this.m_serverClassName = a.getValue("class");
        } else if (localName.equals("module")) {
            this.m_inModuleOrDatastore = true;
            this.m_moduleOrDatastoreParameters = new ArrayList<Parameter>();
            this.m_role = a.getValue("role");
            this.m_class = a.getValue("class");
        } else if (localName.equals("datastore")) {
            this.m_inModuleOrDatastore = true;
            this.m_moduleOrDatastoreParameters = new ArrayList<Parameter>();
            this.m_id = a.getValue("id");
        } else if (localName.equals("comment")) {
            this.m_commentBuffer = new StringBuffer();
        } else if (localName.equals("param")) {
            this.m_inParam = true;
            this.m_paramName = a.getValue("name");
            this.m_paramValue = a.getValue("value");
            String isFilePath = a.getValue("isFilePath");
            this.m_paramIsFilePath = isFilePath != null && isFilePath.equalsIgnoreCase("true");
            this.m_paramComment = null;
            this.m_profileValues = new HashMap<String, String>();
            for (int i = 0; i < a.getLength(); ++i) {
                String name = a.getLocalName(i);
                if (name.length() <= 5 || !name.endsWith("value")) continue;
                String value = a.getValue(i);
                this.m_profileValues.put(name.substring(0, name.length() - 5), value);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("module")) {
            this.m_inModuleOrDatastore = false;
            this.m_moduleConfigurations.add(new ModuleConfiguration(this.m_moduleOrDatastoreParameters, this.m_role, this.m_class, this.m_moduleOrDatastoreComment));
        } else if (localName.equals("datastore")) {
            this.m_inModuleOrDatastore = false;
            this.m_datastoreConfigurations.add(new DatastoreConfiguration(this.m_moduleOrDatastoreParameters, this.m_id, this.m_moduleOrDatastoreComment));
        } else if (localName.equals("comment")) {
            if (this.m_inParam) {
                this.m_paramComment = this.m_commentBuffer.toString();
            } else if (this.m_inModuleOrDatastore) {
                this.m_moduleOrDatastoreComment = this.m_commentBuffer.toString();
            } else if (this.m_lastParam != null) {
                this.m_lastParam.setComment(this.m_commentBuffer.toString());
            }
        } else if (localName.equals("param")) {
            this.m_inParam = false;
            this.m_lastParam = new Parameter(this.m_paramName, this.m_paramValue, this.m_paramIsFilePath, this.m_paramComment, this.m_profileValues);
            if (this.m_inModuleOrDatastore) {
                this.m_moduleOrDatastoreParameters.add(this.m_lastParam);
            } else {
                this.m_serverParameters.add(this.m_lastParam);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_commentBuffer != null) {
            this.m_commentBuffer.append(ch, start, length);
        }
    }
}

