/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.config.webxml;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;
import org.fcrepo.common.Constants;
import org.fcrepo.server.config.webxml.ContextParam;
import org.fcrepo.server.config.webxml.ErrorPage;
import org.fcrepo.server.config.webxml.Filter;
import org.fcrepo.server.config.webxml.FilterMapping;
import org.fcrepo.server.config.webxml.Listener;
import org.fcrepo.server.config.webxml.LoginConfig;
import org.fcrepo.server.config.webxml.SecurityConstraint;
import org.fcrepo.server.config.webxml.SecurityRole;
import org.fcrepo.server.config.webxml.Servlet;
import org.fcrepo.server.config.webxml.ServletMapping;
import org.fcrepo.server.config.webxml.WelcomeFileList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebXML
implements Constants,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BETWIXT_MAPPING = "/org/fcrepo/server/config/webxml/webxml-mapping.xml";
    private String id;
    private String version;
    private String xmlns;
    private String xmlns_xsi;
    private String xsi_schemaLocation;
    private String displayName;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<ContextParam> contextParams = new ArrayList<ContextParam>();
    private final List<Servlet> servlets = new ArrayList<Servlet>();
    private final List<ServletMapping> servletMappings = new ArrayList<ServletMapping>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private final List<FilterMapping> filterMappings = new ArrayList<FilterMapping>();
    private final List<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
    private WelcomeFileList welcomeFileList;
    private final List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
    private LoginConfig loginConfig;
    private final List<SecurityRole> securityRoles = new ArrayList<SecurityRole>();

    public static WebXML getInstance() {
        return new WebXML();
    }

    public static WebXML getInstance(String webxml) {
        WebXML wx = null;
        BeanReader reader = new BeanReader();
        reader.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        reader.getBindingConfiguration().setMapIDs(false);
        try {
            reader.registerMultiMapping(WebXML.getBetwixtMapping());
            wx = (WebXML)reader.parse(new File(webxml).toURI().toString());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return wx;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public String getXmlns_xsi() {
        return this.xmlns_xsi;
    }

    public void setXmlns_xsi(String xmlns_xsi) {
        this.xmlns_xsi = xmlns_xsi;
    }

    public String getXsi_schemaLocation() {
        return this.xsi_schemaLocation;
    }

    public void setXsi_schemaLocation(String xsi_schemaLocation) {
        this.xsi_schemaLocation = xsi_schemaLocation;
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public List<ContextParam> getContextParams() {
        return this.contextParams;
    }

    public void addContextParam(ContextParam contextParam) {
        this.contextParams.add(contextParam);
    }

    public List<Servlet> getServlets() {
        return this.servlets;
    }

    public void addServlet(Servlet servlet) {
        this.servlets.add(servlet);
    }

    public void removeServlet(Servlet servlet) {
        this.servlets.remove(servlet);
    }

    public List<ServletMapping> getServletMappings() {
        return this.servletMappings;
    }

    public void addServletMapping(ServletMapping servletMapping) {
        this.servletMappings.add(servletMapping);
    }

    public void removeServletMapping(ServletMapping servletMapping) {
        this.servletMappings.remove(servletMapping);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public List<FilterMapping> getFilterMappings() {
        return this.filterMappings;
    }

    public void addFilterMapping(FilterMapping filterMapping) {
        this.filterMappings.add(filterMapping);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public void removeFilterMapping(FilterMapping filterMapping) {
        this.filterMappings.remove(filterMapping);
    }

    public List<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.add(securityConstraint);
    }

    public void removeSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.remove(securityConstraint);
    }

    public WelcomeFileList getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public void setWelcomeFileList(WelcomeFileList welcomeFileList) {
        this.welcomeFileList = welcomeFileList;
    }

    public List<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.errorPages.add(errorPage);
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public List<SecurityRole> getSecurityRoles() {
        return this.securityRoles;
    }

    public void addSecurityRole(SecurityRole securityRole) {
        this.securityRoles.add(securityRole);
    }

    public void write(Writer outputWriter) throws IOException {
        NamespacePrefixMapper nspm = new NamespacePrefixMapper();
        nspm.setPrefix(WebXML.XSI.uri, "xsi");
        nspm.setPrefix("http://java.sun.com/xml/ns/j2ee", "xmlns");
        outputWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        BeanWriter beanWriter = new BeanWriter(outputWriter);
        beanWriter.getBindingConfiguration().setMapIDs(false);
        beanWriter.setWriteEmptyElements(false);
        beanWriter.enablePrettyPrint();
        try {
            beanWriter.getXMLIntrospector().register(WebXML.getBetwixtMapping());
            beanWriter.getXMLIntrospector().getConfiguration().setPrefixMapper(nspm);
            beanWriter.write("web-app", (Object)this);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        beanWriter.flush();
        beanWriter.close();
    }

    private static InputSource getBetwixtMapping() {
        return new InputSource(WebXML.class.getResourceAsStream(BETWIXT_MAPPING));
    }
}

