/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.errors.servletExceptionExtensions;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.server.errors.authorization.AuthzDeniedException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.errors.authorization.AuthzPermittedException;
import org.fcrepo.server.errors.servletExceptionExtensions.Continue100Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.Forbidden403Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;

public abstract class RootException
extends ServletException {
    private final HttpServletRequest request;
    private final String action;
    private final String detail;
    private final String[] details;

    public final String getAction() {
        return this.action;
    }

    public final String getDetail() {
        return this.detail;
    }

    public final String[] getDetails() {
        return this.details;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public RootException(HttpServletRequest request, String action, String detail, String[] details) {
        this.action = action;
        this.detail = detail;
        this.details = details;
        this.request = request;
    }

    public RootException(String message, HttpServletRequest request, String action, String detail, String[] details) {
        super(message);
        this.request = request;
        this.action = action;
        this.detail = detail;
        this.details = details;
    }

    public RootException(String message, Throwable cause, HttpServletRequest request, String action, String detail, String[] details) {
        super(message, cause);
        this.request = request;
        this.action = action;
        this.detail = detail;
        this.details = details;
    }

    public static final ServletException getServletException(AuthzException ae, HttpServletRequest request, String action, String[] details) {
        if (ae instanceof AuthzOperationalException) {
            return new InternalError500Exception(request, action, "Internal Error during authorization", details);
        }
        if (ae instanceof AuthzDeniedException) {
            return new Forbidden403Exception(request, action, "Authorization Denied", details);
        }
        if (ae instanceof AuthzPermittedException) {
            return new Continue100Exception(request, action, "Authorization Permitted", details);
        }
        return new InternalError500Exception(request, action, "bug revealed in throwServletException(ae,...)", new String[0]);
    }
}

