/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.InvalidStateException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConsumerThread;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalReader;
import org.fcrepo.server.journal.JournalWorker;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.messaging.PName;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;

public class JournalConsumer
implements JournalWorker {
    private final String role;
    private final JournalConsumerThread consumerThread;
    private final JournalReader reader;
    private final JournalRecoveryLog recoveryLog;
    private ManagementDelegate delegate;

    public JournalConsumer(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        this.role = role;
        this.recoveryLog = JournalRecoveryLog.getInstance(parameters, role, server);
        this.reader = JournalReader.getInstance(parameters, role, this.recoveryLog, server);
        this.consumerThread = new JournalConsumerThread(parameters, role, server, this.reader, this.recoveryLog);
    }

    @Override
    public void setManagementDelegate(ManagementDelegate delegate) {
        this.delegate = delegate;
        this.consumerThread.setManagementDelegate(delegate);
    }

    @Override
    public void shutdown() throws ModuleShutdownException {
        try {
            this.consumerThread.shutdown();
            this.reader.shutdown();
            this.recoveryLog.shutdown("Server is shutting down.");
        }
        catch (JournalException e) {
            throw new ModuleShutdownException("Error closing journal reader.", this.role, e);
        }
    }

    @Override
    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date modifyObject(Context context, String pid, String state, String label, String ownerId, String logMessage, Date lastModifiedDate) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String location, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date modifyDatastreamByReference(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date modifyDatastreamByValue(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date[] purgeDatastream(Context context, String pid, String datastreamID, Date startDT, Date endDT, String logMessage) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public String putTempStream(Context context, InputStream in) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date setDatastreamState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Date setDatastreamVersionable(Context context, String pid, String dsID, boolean versionable, String logMessage) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    public Date setDisseminatorState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public boolean addRelationship(Context context, String pid, String relationship, String objURI, boolean isLiteral, String datatype) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public boolean purgeRelationship(Context context, String pid, String relationship, String objURI, boolean isLiteral, String datatype) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public Validation validate(@PName(value="context") Context context, @PName(value="pid") String pid, @PName(value="asOfDateTime") Date asOfDateTime) throws ServerException {
        throw this.rejectCallsFromOutsideWhileInRecoveryMode();
    }

    @Override
    public String compareDatastreamChecksum(Context context, String pid, String dsID, Date versionDate) throws ServerException {
        return this.delegate.compareDatastreamChecksum(context, pid, dsID, versionDate);
    }

    @Override
    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        return this.delegate.export(context, pid, format, exportContext, encoding);
    }

    @Override
    public InputStream getObjectXML(Context context, String pid, String encoding) throws ServerException {
        return this.delegate.getObjectXML(context, pid, encoding);
    }

    @Override
    public Datastream getDatastream(Context context, String pid, String datastreamID, Date asOfDateTime) throws ServerException {
        return this.delegate.getDatastream(context, pid, datastreamID, asOfDateTime);
    }

    @Override
    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String dsState) throws ServerException {
        return this.delegate.getDatastreams(context, pid, asOfDateTime, dsState);
    }

    @Override
    public Datastream[] getDatastreamHistory(Context context, String pid, String datastreamID) throws ServerException {
        return this.delegate.getDatastreamHistory(context, pid, datastreamID);
    }

    @Override
    public RelationshipTuple[] getRelationships(Context context, String pid, String relationship) throws ServerException {
        return this.delegate.getRelationships(context, pid, relationship);
    }

    @Override
    public InputStream getTempStream(String id) throws ServerException {
        return this.delegate.getTempStream(id);
    }

    private ServerException rejectCallsFromOutsideWhileInRecoveryMode() {
        return new InvalidStateException("Server is in Journal Recovery mode.");
    }
}

