/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.util.Map;
import org.fcrepo.server.journal.JournalReader;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.ConsumerJournalEntry;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;
import org.fcrepo.server.management.ManagementDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalConsumerThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(JournalConsumerThread.class);
    private final ServerInterface server;
    private final JournalReader reader;
    private final JournalRecoveryLog recoveryLog;
    private ManagementDelegate delegate;
    private boolean shutdown = false;

    public JournalConsumerThread(Map<String, String> parameters, String role, ServerInterface server, JournalReader reader, JournalRecoveryLog recoveryLog) {
        this.server = server;
        this.reader = reader;
        this.recoveryLog = recoveryLog;
    }

    public void setManagementDelegate(ManagementDelegate delegate) {
        this.delegate = delegate;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ConsumerJournalEntry cje;
            this.waitUntilServerIsInitialized();
            this.recoveryLog.log("Start recovery.");
            while (!this.shutdown && (cje = this.reader.readJournalEntry()) != null) {
                cje.invokeMethod(this.delegate, this.recoveryLog);
                cje.close();
            }
            this.reader.shutdown();
            this.recoveryLog.log("Recovery complete.");
        }
        catch (Throwable e) {
            logger.error("Error during Journal recovery", e);
            String stackTrace = JournalHelper.captureStackTrace(e);
            this.recoveryLog.log("PROBLEM: " + stackTrace);
            this.recoveryLog.log("Recovery terminated prematurely.");
        }
        finally {
            this.recoveryLog.shutdown();
        }
    }

    private void waitUntilServerIsInitialized() {
        int i;
        for (i = 0; i < 60; ++i) {
            if (this.server.hasInitialized() || this.shutdown) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.warn("Thread was interrupted");
            }
        }
        logger.error("Can't recover from the Journal - the server hasn't initialized after " + i + " seconds.");
        this.shutdown = true;
    }

    public void shutdown() {
        this.recoveryLog.log("Shutdown requested by server");
        this.shutdown = true;
    }
}

