/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalWorker;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.messaging.PName;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalCreator
implements JournalWorker,
JournalConstants {
    private static final Logger logger = LoggerFactory.getLogger(JournalCreator.class);
    private final JournalWriter writer;
    private final String role;
    private ManagementDelegate delegate;

    public JournalCreator(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        this.role = role;
        try {
            this.writer = JournalWriter.getInstance(parameters, role, server);
        }
        catch (JournalException e) {
            String msg = "Problem creating the JournalWriter";
            logger.error(msg, (Throwable)e);
            throw new ModuleInitializationException(msg, role, e);
        }
    }

    @Override
    public void setManagementDelegate(ManagementDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void shutdown() throws ModuleShutdownException {
        try {
            this.writer.shutdown();
        }
        catch (JournalException e) {
            throw new ModuleShutdownException("JournalWriter generated an error on shutdown()", this.role, e);
        }
    }

    @Override
    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("ingest", context);
            cje.addArgument("serialization", serialization);
            cje.addArgument("message", logMessage);
            cje.addArgument("format", format);
            cje.addArgument("encoding", encoding);
            cje.addArgument("pid", pid);
            return (String)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date modifyObject(Context context, String pid, String state, String label, String ownerId, String logMessage, Date lastModifiedDate) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("modifyObject", context);
            cje.addArgument("pid", pid);
            cje.addArgument("state", state);
            cje.addArgument("label", label);
            cje.addArgument("ownerId", ownerId);
            cje.addArgument("message", logMessage);
            cje.addArgument("lastModifiedDate", lastModifiedDate);
            return (Date)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("purgeObject", context);
            cje.addArgument("pid", pid);
            cje.addArgument("message", logMessage);
            return (Date)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String location, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("addDatastream", context);
            cje.addArgument("pid", pid);
            cje.addArgument("dsId", dsID);
            cje.addArgument("altIds", altIDs);
            cje.addArgument("dsLabel", dsLabel);
            cje.addArgument("versionable", versionable);
            cje.addArgument("mimeType", MIMEType);
            cje.addArgument("formatUri", formatURI);
            cje.addArgument("location", location);
            cje.addArgument("controlGroup", controlGroup);
            cje.addArgument("dsState", dsState);
            cje.addArgument("checksumType", checksumType);
            cje.addArgument("checksum", checksum);
            cje.addArgument("message", logMessage);
            return (String)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date modifyDatastreamByValue(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("modifyDatastreamByValue", context);
            cje.addArgument("pid", pid);
            cje.addArgument("dsId", datastreamID);
            cje.addArgument("altIds", altIDs);
            cje.addArgument("dsLabel", dsLabel);
            cje.addArgument("mimeType", mimeType);
            cje.addArgument("formatUri", formatURI);
            cje.addArgument("dsContent", dsContent);
            cje.addArgument("checksumType", checksumType);
            cje.addArgument("checksum", checksum);
            cje.addArgument("message", logMessage);
            cje.addArgument("lastModifiedDate", lastModifiedDate);
            return (Date)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date modifyDatastreamByReference(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("modifyDatastreamByReference", context);
            cje.addArgument("pid", pid);
            cje.addArgument("dsId", datastreamID);
            cje.addArgument("altIds", altIDs);
            cje.addArgument("dsLabel", dsLabel);
            cje.addArgument("mimeType", mimeType);
            cje.addArgument("formatUri", formatURI);
            cje.addArgument("dsLocation", dsLocation);
            cje.addArgument("checksumType", checksumType);
            cje.addArgument("checksum", checksum);
            cje.addArgument("message", logMessage);
            cje.addArgument("lastModifiedDate", lastModifiedDate);
            return (Date)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date setDatastreamState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("setDatastreamState", context);
            cje.addArgument("pid", pid);
            cje.addArgument("dsId", dsID);
            cje.addArgument("dsState", dsState);
            cje.addArgument("message", logMessage);
            return (Date)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date setDatastreamVersionable(Context context, String pid, String dsID, boolean versionable, String logMessage) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("setDatastreamVersionable", context);
            cje.addArgument("pid", pid);
            cje.addArgument("dsId", dsID);
            cje.addArgument("versionable", versionable);
            cje.addArgument("message", logMessage);
            return (Date)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public Date[] purgeDatastream(Context context, String pid, String datastreamID, Date startDT, Date endDT, String logMessage) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("purgeDatastream", context);
            cje.addArgument("pid", pid);
            cje.addArgument("dsId", datastreamID);
            cje.addArgument("startDT", startDT);
            cje.addArgument("endDT", endDT);
            cje.addArgument("message", logMessage);
            return (Date[])cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public String putTempStream(Context context, InputStream in) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("putTempStream", context);
            cje.addArgument("in", in);
            return (String)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("getNextPID", context);
            cje.addArgument("numPids", numPIDs);
            cje.addArgument("namespace", namespace);
            return (String[])cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public boolean addRelationship(Context context, String pid, String relationship, String objURI, boolean isLiteral, String datatype) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("addRelationship", context);
            cje.addArgument("pid", pid);
            cje.addArgument("relationship", relationship);
            cje.addArgument("object", objURI);
            cje.addArgument("isLiteral", isLiteral);
            cje.addArgument("datatype", datatype);
            return (Boolean)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public boolean purgeRelationship(Context context, String pid, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        try {
            CreatorJournalEntry cje = new CreatorJournalEntry("purgeRelationship", context);
            cje.addArgument("pid", pid);
            cje.addArgument("relationship", relationship);
            cje.addArgument("object", object);
            cje.addArgument("isLiteral", isLiteral);
            cje.addArgument("datatype", datatype);
            return (Boolean)cje.invokeAndClose(this.delegate, this.writer);
        }
        catch (JournalException e) {
            throw new GeneralException("Problem creating the Journal", e);
        }
    }

    @Override
    public String compareDatastreamChecksum(Context context, String pid, String dsID, Date versionDate) throws ServerException {
        return this.delegate.compareDatastreamChecksum(context, pid, dsID, versionDate);
    }

    @Override
    public RelationshipTuple[] getRelationships(Context context, String pid, String relationship) throws ServerException {
        return this.delegate.getRelationships(context, pid, relationship);
    }

    @Override
    public InputStream getObjectXML(Context context, String pid, String encoding) throws ServerException {
        return this.delegate.getObjectXML(context, pid, encoding);
    }

    @Override
    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        return this.delegate.export(context, pid, format, exportContext, encoding);
    }

    @Override
    public Datastream getDatastream(Context context, String pid, String datastreamID, Date asOfDateTime) throws ServerException {
        return this.delegate.getDatastream(context, pid, datastreamID, asOfDateTime);
    }

    @Override
    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String dsState) throws ServerException {
        return this.delegate.getDatastreams(context, pid, asOfDateTime, dsState);
    }

    @Override
    public Datastream[] getDatastreamHistory(Context context, String pid, String datastreamID) throws ServerException {
        return this.delegate.getDatastreamHistory(context, pid, datastreamID);
    }

    @Override
    public InputStream getTempStream(String id) throws ServerException {
        return this.delegate.getTempStream(id);
    }

    @Override
    public Validation validate(@PName(value="context") Context context, @PName(value="pid") String pid, @PName(value="asOfDateTime") Date asOfDateTime) throws ServerException {
        return this.delegate.validate(context, pid, asOfDateTime);
    }
}

