/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import org.fcrepo.server.errors.InvalidStateException;
import org.fcrepo.server.errors.ServerException;

public enum JournalOperatingMode {
    NORMAL,
    READ_ONLY;

    private static JournalOperatingMode currentMode;

    public static void setMode(JournalOperatingMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Journal operating mode may not be null");
        }
        currentMode = mode;
    }

    public static Object getMode() {
        return currentMode;
    }

    public static void enforceCurrentMode() throws ServerException {
        switch (currentMode) {
            case READ_ONLY: {
                throw new InvalidStateException("Server is in Read-Only mode, pursuant to a Journaling error.");
            }
        }
    }

    static {
        currentMode = NORMAL;
    }
}

