/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.ConsumerJournalEntry;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.journal.helpers.DecodingBase64OutputStream;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;
import org.fcrepo.server.journal.xmlhelpers.AbstractXmlReader;
import org.fcrepo.server.journal.xmlhelpers.ContextXmlReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JournalReader
extends AbstractXmlReader
implements JournalConstants {
    private static final Logger logger = LoggerFactory.getLogger(JournalReader.class);
    protected final Map<String, String> parameters;
    protected final String role;
    protected final JournalRecoveryLog recoveryLog;
    protected final ServerInterface server;
    private boolean ignoreHashErrors;

    public static JournalReader getInstance(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws ModuleInitializationException {
        try {
            Object journalReader = JournalHelper.createInstanceAccordingToParameter("journalReaderClassname", new Class[]{Map.class, String.class, JournalRecoveryLog.class, ServerInterface.class}, new Object[]{parameters, role, recoveryLog, server}, parameters);
            logger.info("JournalReader is " + journalReader.toString());
            return (JournalReader)journalReader;
        }
        catch (JournalException e) {
            String msg = "Can't create JournalReader";
            logger.error(msg, (Throwable)e);
            throw new ModuleInitializationException(msg, role, e);
        }
    }

    protected JournalReader(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws JournalException {
        this.parameters = parameters;
        this.role = role;
        this.recoveryLog = recoveryLog;
        this.server = server;
        this.parseParameters();
    }

    private void parseParameters() throws JournalException {
        String ignore = this.parameters.get("continueOnHashError");
        if (ignore == null) {
            this.ignoreHashErrors = false;
        } else if (ignore.equals("false")) {
            this.ignoreHashErrors = false;
        } else if (ignore.equals("true")) {
            this.ignoreHashErrors = true;
        } else {
            throw new JournalException("'continueOnHashError' parameter must be 'false'(default) or 'true'");
        }
    }

    public abstract void shutdown() throws JournalException;

    public abstract ConsumerJournalEntry readJournalEntry() throws JournalException, XMLStreamException;

    protected void checkRepositoryHash(String hash) throws JournalException {
        if (!this.server.hasInitialized()) {
            throw new IllegalStateException("The repository has is not available until the server is fully initialized.");
        }
        JournalException hashException = null;
        if (hash == null) {
            hashException = new JournalException("'" + QNAME_TAG_JOURNAL + "' tag must have a '" + QNAME_ATTR_REPOSITORY_HASH + "' attribute.");
        } else {
            try {
                String currentHash = this.server.getRepositoryHash();
                if (hash.equals(currentHash)) {
                    this.recoveryLog.log("Validated repository hash: '" + hash + "'.");
                } else {
                    hashException = new JournalException("'" + QNAME_ATTR_REPOSITORY_HASH + "' attribute in '" + QNAME_TAG_JOURNAL + "' tag does not match current repository hash: '" + hash + "' vs. '" + currentHash + "'.");
                }
            }
            catch (ServerException e) {
                hashException = new JournalException(e);
            }
        }
        if (hashException != null) {
            if (this.ignoreHashErrors) {
                this.recoveryLog.log("WARNING: " + hashException.getMessage());
            } else {
                throw hashException;
            }
        }
    }

    protected ConsumerJournalEntry readJournalEntry(XMLEventReader reader) throws JournalException, XMLStreamException {
        StartElement startTag = this.getJournalEntryStartTag(reader);
        String methodName = this.getRequiredAttributeValue(startTag, QNAME_ATTR_METHOD);
        JournalEntryContext context = new ContextXmlReader().readContext(reader);
        ConsumerJournalEntry cje = new ConsumerJournalEntry(methodName, context);
        this.readArguments(reader, cje);
        return cje;
    }

    private StartElement getJournalEntryStartTag(XMLEventReader reader) throws XMLStreamException, JournalException {
        XMLEvent event = reader.nextTag();
        if (!this.isStartTagEvent(event, QNAME_TAG_JOURNAL_ENTRY)) {
            throw this.getNotStartTagException(QNAME_TAG_JOURNAL_ENTRY, event);
        }
        return event.asStartElement();
    }

    private void readArguments(XMLEventReader reader, ConsumerJournalEntry cje) throws XMLStreamException, JournalException {
        XMLEvent nextTag;
        while (this.isStartTagEvent(nextTag = reader.nextTag(), QNAME_TAG_ARGUMENT)) {
            this.readArgument(nextTag, reader, cje);
        }
        if (this.isEndTagEvent(nextTag, QNAME_TAG_JOURNAL_ENTRY)) {
            return;
        }
        throw this.getNotNextMemberOrEndOfGroupException(QNAME_TAG_JOURNAL_ENTRY, QNAME_TAG_ARGUMENT, nextTag);
    }

    private void readArgument(XMLEvent nextTag, XMLEventReader reader, ConsumerJournalEntry journalEntry) throws JournalException, XMLStreamException {
        StartElement element = nextTag.asStartElement();
        String argName = this.getRequiredAttributeValue(element, QNAME_ATTR_NAME);
        String argType = this.getRequiredAttributeValue(element, QNAME_ATTR_TYPE);
        if ("null".equals(argType)) {
            this.readNullArgument(reader, journalEntry, argName);
        } else if ("string".equals(argType)) {
            this.readStringArgument(reader, journalEntry, argName);
        } else if ("stringarray".equals(argType)) {
            this.readStringArrayArgument(reader, journalEntry, argName);
        } else if ("integer".equals(argType)) {
            this.readIntegerArgument(reader, journalEntry, argName);
        } else if ("boolean".equals(argType)) {
            this.readBooleanArgument(reader, journalEntry, argName);
        } else if ("date".equals(argType)) {
            this.readDateArgument(reader, journalEntry, argName);
        } else if ("stream".equals(argType)) {
            this.readStreamArgument(reader, journalEntry, argName);
        } else {
            throw new JournalException("Unknown argument type: name='" + argName + "', type='" + argType + "'");
        }
    }

    private void readStringArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        String value = this.readCharactersUntilEndOfArgument(reader, QNAME_TAG_ARGUMENT, journalEntry.getMethodName(), name, "string");
        journalEntry.addArgument(name, value);
    }

    private void readStringArrayArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        XMLEvent event;
        ArrayList<String> values = new ArrayList<String>();
        while (this.isStartTagEvent(event = reader.nextTag(), QNAME_TAG_ARRAYELEMENT)) {
            values.add(this.readCharactersUntilEndOfArgument(reader, QNAME_TAG_ARRAYELEMENT, journalEntry.getMethodName(), name, "stringarray"));
        }
        if (!this.isEndTagEvent(event, QNAME_TAG_ARGUMENT)) {
            throw this.getUnexpectedEventInArgumentException(name, "stringarray", journalEntry.getMethodName(), event);
        }
        String[] valuesArray = values.toArray(new String[values.size()]);
        journalEntry.addArgument(name, valuesArray);
    }

    private void readIntegerArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        XMLEvent chars = reader.nextEvent();
        if (!chars.isCharacters()) {
            throw this.getUnexpectedEventInArgumentException(name, "integer", journalEntry.getMethodName(), chars);
        }
        Integer integerValue = Integer.valueOf(chars.asCharacters().getData());
        XMLEvent endTag = reader.nextEvent();
        if (!this.isEndTagEvent(endTag, QNAME_TAG_ARGUMENT)) {
            throw this.getUnexpectedEventInArgumentException(name, "integer", journalEntry.getMethodName(), endTag);
        }
        journalEntry.addArgument(name, integerValue);
    }

    private void readBooleanArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        XMLEvent chars = reader.nextEvent();
        if (!chars.isCharacters()) {
            throw this.getUnexpectedEventInArgumentException(name, "boolean", journalEntry.getMethodName(), chars);
        }
        Boolean booleanValue = Boolean.valueOf(chars.asCharacters().getData());
        XMLEvent endTag = reader.nextEvent();
        if (!this.isEndTagEvent(endTag, QNAME_TAG_ARGUMENT)) {
            throw this.getUnexpectedEventInArgumentException(name, "boolean", journalEntry.getMethodName(), endTag);
        }
        journalEntry.addArgument(name, booleanValue);
    }

    private void readDateArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        XMLEvent chars = reader.nextEvent();
        if (!chars.isCharacters()) {
            throw this.getUnexpectedEventInArgumentException(name, "boolean", journalEntry.getMethodName(), chars);
        }
        Date dateValue = JournalHelper.parseDate(chars.asCharacters().getData());
        XMLEvent endTag = reader.nextEvent();
        if (!this.isEndTagEvent(endTag, QNAME_TAG_ARGUMENT)) {
            throw this.getUnexpectedEventInArgumentException(name, "date", journalEntry.getMethodName(), endTag);
        }
        journalEntry.addArgument(name, dateValue);
    }

    private void readStreamArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        try {
            XMLEvent event;
            File tempFile = JournalHelper.createTempFile();
            DecodingBase64OutputStream decoder = new DecodingBase64OutputStream(new FileOutputStream(tempFile));
            while ((event = reader.nextEvent()).isCharacters()) {
                decoder.write(event.asCharacters().getData());
            }
            if (!this.isEndTagEvent(event, QNAME_TAG_ARGUMENT)) {
                throw this.getUnexpectedEventInArgumentException(name, "stream", journalEntry.getMethodName(), event);
            }
            decoder.close();
            journalEntry.addArgument(name, tempFile);
        }
        catch (IOException e) {
            throw new JournalException("failed to write stream argument to temp file", e);
        }
    }

    private void readNullArgument(XMLEventReader reader, ConsumerJournalEntry journalEntry, String name) throws XMLStreamException, JournalException {
        XMLEvent endTag = reader.nextTag();
        if (!this.isEndTagEvent(endTag, QNAME_TAG_ARGUMENT)) {
            throw this.getUnexpectedEventInArgumentException(name, "null", journalEntry.getMethodName(), endTag);
        }
    }

    private String readCharactersUntilEndOfArgument(XMLEventReader reader, QName tagName, String methodName, String argumentName, String argumentType) throws XMLStreamException, JournalException {
        XMLEvent event;
        StringBuffer stringValue = new StringBuffer();
        while ((event = reader.nextEvent()).isCharacters()) {
            stringValue.append(event.asCharacters().getData());
        }
        if (!this.isEndTagEvent(event, tagName)) {
            throw this.getUnexpectedEventInArgumentException(argumentName, argumentType, methodName, event);
        }
        return stringValue.toString();
    }

    private JournalException getUnexpectedEventInArgumentException(String name, String argumentType, String methodName, XMLEvent event) {
        return new JournalException("Unexpected event while processing '" + name + "' argument (type = '" + argumentType + "') for '" + methodName + "' method call: event is '" + event + "'");
    }
}

