/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.journal.helpers.EncodingBase64InputStream;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.xmlhelpers.AbstractXmlWriter;
import org.fcrepo.server.journal.xmlhelpers.ContextXmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JournalWriter
extends AbstractXmlWriter {
    private static final Logger logger = LoggerFactory.getLogger(JournalWriter.class);
    public static final Object SYNCHRONIZER = new Object();
    protected final String role;
    protected final Map<String, String> parameters;
    protected final ServerInterface server;

    public static JournalWriter getInstance(Map<String, String> parameters, String role, ServerInterface server) throws JournalException {
        Object journalWriter = JournalHelper.createInstanceAccordingToParameter("journalWriterClassname", new Class[]{Map.class, String.class, ServerInterface.class}, new Object[]{parameters, role, server}, parameters);
        logger.info("JournalWriter is " + journalWriter.toString());
        return (JournalWriter)journalWriter;
    }

    protected JournalWriter(Map<String, String> parameters, String role, ServerInterface server) {
        this.parameters = parameters;
        this.role = role;
        this.server = server;
    }

    public abstract void shutdown() throws JournalException;

    public abstract void prepareToWriteJournalEntry() throws JournalException;

    public abstract void writeJournalEntry(CreatorJournalEntry var1) throws JournalException;

    protected void writeDocumentHeader(XMLEventWriter writer) throws JournalException {
        this.writeDocumentHeader(writer, this.getRepositoryHash(), new Date());
    }

    protected void writeDocumentHeader(XMLEventWriter writer, String repositoryHash, Date currentDate) throws JournalException {
        try {
            this.putStartDocument(writer);
            this.putStartTag(writer, QNAME_TAG_JOURNAL);
            this.putAttribute(writer, QNAME_ATTR_REPOSITORY_HASH, repositoryHash);
            this.putAttribute(writer, QNAME_ATTR_TIMESTAMP, JournalHelper.formatDate(currentDate));
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    protected void writeDocumentTrailer(XMLEventWriter writer) throws JournalException {
        try {
            this.putEndDocument(writer);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    protected void writeJournalEntry(CreatorJournalEntry journalEntry, XMLEventWriter writer) throws JournalException {
        try {
            this.writeJournaEntryStartTag(journalEntry, writer);
            new ContextXmlWriter().writeContext(journalEntry.getContext(), writer);
            this.writeArguments(journalEntry.getArgumentsMap(), writer);
            this.putEndTag(writer, QNAME_TAG_JOURNAL_ENTRY);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    private void writeJournaEntryStartTag(CreatorJournalEntry journalEntry, XMLEventWriter writer) throws XMLStreamException {
        String[] loginIdArray;
        this.putStartTag(writer, QNAME_TAG_JOURNAL_ENTRY);
        this.putAttribute(writer, QNAME_ATTR_METHOD, journalEntry.getMethodName());
        this.putAttribute(writer, QNAME_ATTR_TIMESTAMP, JournalHelper.formatDate(journalEntry.getContext().now()));
        String[] clientIpArray = journalEntry.getContext().getEnvironmentValues(Constants.HTTP_REQUEST.CLIENT_IP_ADDRESS.uri);
        if (clientIpArray != null && clientIpArray.length > 0) {
            this.putAttribute(writer, QNAME_ATTR_CLIENT_IP, clientIpArray[0]);
        }
        if ((loginIdArray = journalEntry.getContext().getSubjectValues(Constants.SUBJECT.LOGIN_ID.uri)) != null && loginIdArray.length > 0) {
            this.putAttribute(writer, QNAME_ATTR_LOGIN_ID, loginIdArray[0]);
        }
    }

    private void writeArguments(Map<String, Object> arguments, XMLEventWriter writer) throws XMLStreamException, JournalException {
        for (String key : arguments.keySet()) {
            Object value = arguments.get(key);
            if (value == null) {
                this.writeNullArgument(key, writer);
                continue;
            }
            if (value instanceof String) {
                this.writeStringArgument(key, (String)value, writer);
                continue;
            }
            if (value instanceof String[]) {
                this.writeStringArrayArgument(key, (String[])value, writer);
                continue;
            }
            if (value instanceof Date) {
                this.writeDateArgument(key, (Date)value, writer);
                continue;
            }
            if (value instanceof Integer) {
                this.writeIntegerArgument(key, (Integer)value, writer);
                continue;
            }
            if (value instanceof Boolean) {
                this.writeBooleanArgument(key, (Boolean)value, writer);
                continue;
            }
            if (value instanceof File) {
                this.writeFileArgument(key, (File)value, writer);
                continue;
            }
            throw new JournalException("Unknown argument type: name='" + key + "', type='" + value.getClass().getName() + "'");
        }
    }

    private void writeNullArgument(String key, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_ARGUMENT);
        this.putAttribute(writer, QNAME_ATTR_NAME, key);
        this.putAttribute(writer, QNAME_ATTR_TYPE, "null");
        this.putEndTag(writer, QNAME_TAG_ARGUMENT);
    }

    private void writeStringArgument(String key, String value, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_ARGUMENT);
        this.putAttribute(writer, QNAME_ATTR_NAME, key);
        this.putAttribute(writer, QNAME_ATTR_TYPE, "string");
        this.putCharacters(writer, value);
        this.putEndTag(writer, QNAME_TAG_ARGUMENT);
    }

    private void writeDateArgument(String key, Date date, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_ARGUMENT);
        this.putAttribute(writer, QNAME_ATTR_NAME, key);
        this.putAttribute(writer, QNAME_ATTR_TYPE, "date");
        this.putCharacters(writer, JournalHelper.formatDate(date));
        this.putEndTag(writer, QNAME_TAG_ARGUMENT);
    }

    private void writeIntegerArgument(String key, Integer value, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_ARGUMENT);
        this.putAttribute(writer, QNAME_ATTR_NAME, key);
        this.putAttribute(writer, QNAME_ATTR_TYPE, "integer");
        this.putCharacters(writer, value.toString());
        this.putEndTag(writer, QNAME_TAG_ARGUMENT);
    }

    private void writeBooleanArgument(String key, Boolean value, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_ARGUMENT);
        this.putAttribute(writer, QNAME_ATTR_NAME, key);
        this.putAttribute(writer, QNAME_ATTR_TYPE, "boolean");
        this.putCharacters(writer, value.toString());
        this.putEndTag(writer, QNAME_TAG_ARGUMENT);
    }

    private void writeStringArrayArgument(String key, String[] value, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_ARGUMENT);
        this.putAttribute(writer, QNAME_ATTR_NAME, key);
        this.putAttribute(writer, QNAME_ATTR_TYPE, "stringarray");
        for (String element : value) {
            this.putStartTag(writer, QNAME_TAG_ARRAYELEMENT);
            this.putCharacters(writer, element);
            this.putEndTag(writer, QNAME_TAG_ARRAYELEMENT);
        }
        this.putEndTag(writer, QNAME_TAG_ARGUMENT);
    }

    private void writeFileArgument(String key, File file, XMLEventWriter writer) throws XMLStreamException, JournalException {
        try {
            String encodedChunk;
            this.putStartTag(writer, QNAME_TAG_ARGUMENT);
            this.putAttribute(writer, QNAME_ATTR_NAME, key);
            this.putAttribute(writer, QNAME_ATTR_TYPE, "stream");
            EncodingBase64InputStream encoder = new EncodingBase64InputStream(new BufferedInputStream(new FileInputStream(file)));
            while (null != (encodedChunk = encoder.read(1000))) {
                this.putCharacters(writer, encodedChunk);
            }
            encoder.close();
            this.putEndTag(writer, QNAME_TAG_ARGUMENT);
        }
        catch (IOException e) {
            throw new JournalException("IO Exception on temp file", e);
        }
    }

    private String getRepositoryHash() throws JournalException {
        if (!this.server.hasInitialized()) {
            throw new IllegalStateException("The repository hash is not available until the server is fully initialized.");
        }
        try {
            return this.server.getRepositoryHash();
        }
        catch (ServerException e) {
            throw new JournalException(e);
        }
    }
}

