/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalConsumer;
import org.fcrepo.server.journal.JournalCreator;
import org.fcrepo.server.journal.JournalWorker;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.ServerWrapper;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.messaging.PName;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Journaler
extends Module
implements Management,
JournalConstants {
    private static final Logger logger = LoggerFactory.getLogger(Journaler.class);
    private JournalWorker worker;
    private boolean inRecoveryMode;
    private ServerInterface serverInterface;

    public Journaler(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        Map<String, String> parameters = this.getParameters();
        this.copyPropertiesOverParameters(parameters);
        this.serverInterface = new ServerWrapper(this.getServer());
        logger.info("Journaling parameters: " + parameters);
        this.parseParameters(parameters);
        this.worker = this.inRecoveryMode ? new JournalConsumer(parameters, this.getRole(), this.serverInterface) : new JournalCreator(parameters, this.getRole(), this.serverInterface);
        logger.info("Journal worker module is: " + this.worker.toString());
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        ManagementDelegate delegate = this.serverInterface.getManagementDelegate();
        if (delegate == null) {
            throw new ModuleInitializationException("Can't get a ManagementDelegate from Server.getModule()", this.getRole());
        }
        this.worker.setManagementDelegate(delegate);
    }

    @Override
    public void shutdownModule() throws ModuleShutdownException {
        this.worker.shutdown();
    }

    private void copyPropertiesOverParameters(Map<String, String> parameters) {
        Properties properties = System.getProperties();
        for (Object object : properties.keySet()) {
            String key = (String)object;
            if (!key.startsWith("fedora.journal.")) continue;
            parameters.put(key.substring("fedora.journal.".length()), properties.getProperty(key));
        }
    }

    private void parseParameters(Map<String, String> parameters) throws ModuleInitializationException {
        logger.info("Parameters: " + parameters);
        String mode = parameters.get("journalMode");
        if (mode == null) {
            this.inRecoveryMode = false;
        } else if (mode.equals("normal")) {
            this.inRecoveryMode = false;
        } else if (mode.equals("recover")) {
            this.inRecoveryMode = true;
        } else {
            throw new ModuleInitializationException("'journalMode' parameter must be 'normal'(default) or 'recover'", this.getRole());
        }
    }

    @Override
    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
        return this.worker.ingest(context, serialization, logMessage, format, encoding, pid);
    }

    @Override
    public Date modifyObject(Context context, String pid, String state, String label, String ownerId, String logMessage, Date lastModifiedDate) throws ServerException {
        return this.worker.modifyObject(context, pid, state, label, ownerId, logMessage, lastModifiedDate);
    }

    @Override
    public InputStream getObjectXML(Context context, String pid, String encoding) throws ServerException {
        return this.worker.getObjectXML(context, pid, encoding);
    }

    @Override
    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        return this.worker.export(context, pid, format, exportContext, encoding);
    }

    @Override
    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        return this.worker.purgeObject(context, pid, logMessage);
    }

    @Override
    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String location, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        return this.worker.addDatastream(context, pid, dsID, altIDs, dsLabel, versionable, MIMEType, formatURI, location, controlGroup, dsState, checksumType, checksum, logMessage);
    }

    @Override
    public Date modifyDatastreamByReference(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        return this.worker.modifyDatastreamByReference(context, pid, datastreamID, altIDs, dsLabel, mimeType, formatURI, dsLocation, checksumType, checksum, logMessage, lastModifiedDate);
    }

    @Override
    public Date modifyDatastreamByValue(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        return this.worker.modifyDatastreamByValue(context, pid, datastreamID, altIDs, dsLabel, mimeType, formatURI, dsContent, checksumType, checksum, logMessage, null);
    }

    @Override
    public Date[] purgeDatastream(Context context, String pid, String datastreamID, Date startDT, Date endDT, String logMessage) throws ServerException {
        return this.worker.purgeDatastream(context, pid, datastreamID, startDT, endDT, logMessage);
    }

    @Override
    public Datastream getDatastream(Context context, String pid, String datastreamID, Date asOfDateTime) throws ServerException {
        return this.worker.getDatastream(context, pid, datastreamID, asOfDateTime);
    }

    @Override
    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String dsState) throws ServerException {
        return this.worker.getDatastreams(context, pid, asOfDateTime, dsState);
    }

    @Override
    public Datastream[] getDatastreamHistory(Context context, String pid, String datastreamID) throws ServerException {
        return this.worker.getDatastreamHistory(context, pid, datastreamID);
    }

    @Override
    public String putTempStream(Context context, InputStream in) throws ServerException {
        return this.worker.putTempStream(context, in);
    }

    @Override
    public InputStream getTempStream(String id) throws ServerException {
        return this.worker.getTempStream(id);
    }

    @Override
    public Date setDatastreamState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        return this.worker.setDatastreamState(context, pid, dsID, dsState, logMessage);
    }

    @Override
    public Date setDatastreamVersionable(Context context, String pid, String dsID, boolean versionable, String logMessage) throws ServerException {
        return this.worker.setDatastreamVersionable(context, pid, dsID, versionable, logMessage);
    }

    @Override
    public String compareDatastreamChecksum(Context context, String pid, String dsID, Date versionDate) throws ServerException {
        return this.worker.compareDatastreamChecksum(context, pid, dsID, versionDate);
    }

    @Override
    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        return this.worker.getNextPID(context, numPIDs, namespace);
    }

    @Override
    public RelationshipTuple[] getRelationships(Context context, String pid, String relationship) throws ServerException {
        return this.worker.getRelationships(context, pid, relationship);
    }

    @Override
    public boolean addRelationship(Context context, String pid, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        return this.worker.addRelationship(context, pid, relationship, object, isLiteral, datatype);
    }

    @Override
    public boolean purgeRelationship(Context context, String pid, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        return this.worker.purgeRelationship(context, pid, relationship, object, isLiteral, datatype);
    }

    @Override
    public Validation validate(@PName(value="context") Context context, @PName(value="pid") String pid, @PName(value="asOfDateTime") Date asOfDateTime) throws ServerException {
        return this.worker.validate(context, pid, asOfDateTime);
    }
}

