/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.entry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.managementmethods.ManagementMethod;

public abstract class JournalEntry {
    private boolean open = true;
    private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();
    private final String methodName;
    private final ManagementMethod method;
    private final JournalEntryContext context;

    protected JournalEntry(String methodName, JournalEntryContext context) {
        this.methodName = methodName;
        this.context = context;
        this.method = ManagementMethod.getInstance(methodName, this);
    }

    public JournalEntryContext getContext() {
        this.checkOpen();
        return this.context;
    }

    public ManagementMethod getMethod() {
        this.checkOpen();
        return this.method;
    }

    public String getMethodName() {
        this.checkOpen();
        return this.methodName;
    }

    public Map<String, Object> getArgumentsMap() {
        this.checkOpen();
        return new LinkedHashMap<String, Object>(this.arguments);
    }

    public void addArgument(String key, boolean value) {
        this.checkOpen();
        this.addArgument(key, (Object)value);
    }

    public void addArgument(String key, int value) {
        this.checkOpen();
        this.addArgument(key, new Integer(value));
    }

    public void addArgument(String key, Object value) {
        this.checkOpen();
        this.arguments.put(key, value);
    }

    public void addArgument(String key, InputStream stream) throws JournalException {
        this.checkOpen();
        if (stream == null) {
            this.arguments.put(key, null);
        } else {
            try {
                File tempFile = JournalHelper.copyToTempFile(stream);
                this.arguments.put(key, tempFile);
            }
            catch (IOException e) {
                throw new JournalException(e);
            }
        }
    }

    public void setRecoveryValue(String attribute, String value) {
        this.checkOpen();
        this.context.setRecoveryValue(attribute, value);
    }

    public void setRecoveryValues(String attribute, String[] values) {
        this.checkOpen();
        this.context.setRecoveryValues(attribute, values);
    }

    public int getIntegerArgument(String name) {
        this.checkOpen();
        return (Integer)this.arguments.get(name);
    }

    public boolean getBooleanArgument(String name) {
        this.checkOpen();
        return (Boolean)this.arguments.get(name);
    }

    public String getStringArgument(String name) {
        this.checkOpen();
        return (String)this.arguments.get(name);
    }

    public Date getDateArgument(String name) {
        this.checkOpen();
        return (Date)this.arguments.get(name);
    }

    public String[] getStringArrayArgument(String name) {
        this.checkOpen();
        return (String[])this.arguments.get(name);
    }

    public InputStream getStreamArgument(String name) throws JournalException {
        this.checkOpen();
        File file = (File)this.arguments.get(name);
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new JournalException(e);
        }
    }

    public void close() {
        this.checkOpen();
        this.open = false;
        for (Object arg : this.arguments.values()) {
            File file;
            if (!(arg instanceof File) || !JournalHelper.isTempFile(file = (File)arg) || !file.exists()) continue;
            file.delete();
        }
    }

    private void checkOpen() throws IllegalStateException {
        if (!this.open) {
            throw new IllegalStateException("JournalEntry must not be accessed after close() has been called");
        }
    }
}

