/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.entry;

import java.util.Date;
import java.util.Iterator;
import org.fcrepo.server.Context;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.RecoveryContext;

public class JournalEntryContext
implements RecoveryContext {
    private MultiValueMap environmentAttributes = new MultiValueMap();
    private MultiValueMap subjectAttributes = new MultiValueMap();
    private MultiValueMap actionAttributes = new MultiValueMap();
    private MultiValueMap resourceAttributes = new MultiValueMap();
    private MultiValueMap recoveryAttributes = new MultiValueMap();
    private String password = "";
    private boolean noOp = false;
    private Date now = new Date();

    public JournalEntryContext() {
    }

    public JournalEntryContext(Context source) {
        String key;
        this.password = source.getPassword();
        this.noOp = source.getNoOp();
        this.now = source.now();
        Iterator<String> keys = source.environmentAttributes();
        while (keys.hasNext()) {
            key = keys.next();
            this.storeInMap(this.environmentAttributes, key, source.getEnvironmentValues(key));
        }
        keys = source.subjectAttributes();
        while (keys.hasNext()) {
            key = keys.next();
            this.storeInMap(this.subjectAttributes, key, source.getSubjectValues(key));
        }
        keys = source.actionAttributes();
        while (keys.hasNext()) {
            key = keys.next();
            this.storeInMap(this.actionAttributes, key, source.getActionValues(key));
        }
        keys = source.resourceAttributes();
        while (keys.hasNext()) {
            key = keys.next();
            this.storeInMap(this.resourceAttributes, key, source.getResourceValues(key));
        }
    }

    private void storeInMap(MultiValueMap map, String key, String[] values) {
        try {
            map.set(key, values);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public MultiValueMap getEnvironmentAttributes() {
        return this.environmentAttributes;
    }

    public Iterator environmentAttributes() {
        return this.environmentAttributes.names();
    }

    @Override
    public int nEnvironmentValues(String name) {
        return this.environmentAttributes.length(name);
    }

    @Override
    public String getEnvironmentValue(String name) {
        return this.environmentAttributes.getString(name);
    }

    @Override
    public String[] getEnvironmentValues(String name) {
        return this.environmentAttributes.getStringArray(name);
    }

    public Iterator subjectAttributes() {
        return this.subjectAttributes.names();
    }

    @Override
    public int nSubjectValues(String name) {
        return this.subjectAttributes.length(name);
    }

    @Override
    public String getSubjectValue(String name) {
        return this.subjectAttributes.getString(name);
    }

    @Override
    public String[] getSubjectValues(String name) {
        return this.subjectAttributes.getStringArray(name);
    }

    public Iterator actionAttributes() {
        return this.actionAttributes.names();
    }

    @Override
    public int nActionValues(String name) {
        return this.actionAttributes.length(name);
    }

    @Override
    public String getActionValue(String name) {
        return this.actionAttributes.getString(name);
    }

    @Override
    public String[] getActionValues(String name) {
        return this.actionAttributes.getStringArray(name);
    }

    public Iterator resourceAttributes() {
        return this.resourceAttributes.names();
    }

    @Override
    public int nResourceValues(String name) {
        return this.resourceAttributes.length(name);
    }

    @Override
    public String getResourceValue(String name) {
        return this.resourceAttributes.getString(name);
    }

    @Override
    public String[] getResourceValues(String name) {
        return this.resourceAttributes.getStringArray(name);
    }

    @Override
    public void setActionAttributes(MultiValueMap actionAttributes) {
        if (actionAttributes == null) {
            actionAttributes = new MultiValueMap();
        }
        this.actionAttributes = actionAttributes;
    }

    @Override
    public void setResourceAttributes(MultiValueMap resourceAttributes) {
        if (resourceAttributes == null) {
            resourceAttributes = new MultiValueMap();
        }
        this.resourceAttributes = resourceAttributes;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Date now() {
        return this.now;
    }

    @Override
    public boolean getNoOp() {
        return this.noOp;
    }

    @Override
    public Iterator getRecoveryNames() {
        return this.recoveryAttributes.names();
    }

    @Override
    public String getRecoveryValue(String attribute) {
        return this.recoveryAttributes.getString(attribute);
    }

    @Override
    public String[] getRecoveryValues(String attribute) {
        return this.recoveryAttributes.getStringArray(attribute);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[environmentAttributes=" + this.environmentAttributes + ", subjectAttributes=" + this.subjectAttributes + ", actionAttributes=" + this.actionAttributes + ", resourceAttributes=" + this.resourceAttributes + ", recoveryAttributes=" + this.recoveryAttributes + ", password=" + this.password + ", noOp=" + this.noOp + ", date=" + this.now + "]\n";
    }

    public MultiValueMap getActionAttributes() {
        return this.actionAttributes;
    }

    public void setEnvironmentAttributes(MultiValueMap environmentAttributes) {
        this.environmentAttributes = environmentAttributes;
    }

    public void setSubjectAttributes(MultiValueMap subjectAttributes) {
        this.subjectAttributes = subjectAttributes;
    }

    public MultiValueMap getSubjectAttributes() {
        return this.subjectAttributes;
    }

    public MultiValueMap getResourceAttributes() {
        return this.resourceAttributes;
    }

    public void setRecoveryAttributes(MultiValueMap recoveryAttributes) {
        this.recoveryAttributes = recoveryAttributes;
    }

    public MultiValueMap getRecoveryAttributes() {
        return this.recoveryAttributes;
    }

    public void setRecoveryValue(String attribute, String value) {
        this.setRecoveryValues(attribute, new String[]{value});
    }

    public void setRecoveryValues(String attribute, String[] values) {
        this.storeInMap(this.recoveryAttributes, attribute, values);
    }

    public void setNoOp(boolean noOp) {
        this.noOp = noOp;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNow(Date now) {
        this.now = now;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(JournalEntryContext.class)) {
            return false;
        }
        JournalEntryContext that = (JournalEntryContext)obj;
        return this.environmentAttributes.equals(that.environmentAttributes) && this.subjectAttributes.equals(that.subjectAttributes) && this.actionAttributes.equals(that.actionAttributes) && this.resourceAttributes.equals(that.resourceAttributes) && this.recoveryAttributes.equals(that.recoveryAttributes) && this.password.equals(that.password) && this.noOp == that.noOp && this.now.equals(that.now);
    }

    public int hashCode() {
        return this.environmentAttributes.hashCode() ^ this.subjectAttributes.hashCode() ^ this.actionAttributes.hashCode() ^ this.resourceAttributes.hashCode() ^ this.environmentAttributes.hashCode() ^ this.password.hashCode() ^ this.now.hashCode() + (this.noOp ? 0 : 1);
    }
}

