/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;

public class ParameterHelper
implements JournalConstants {
    private ParameterHelper() {
    }

    private static void validateParameters(Map<String, String> parameters) {
        if (parameters == null) {
            throw new NullPointerException("'parameters' may not be null.");
        }
    }

    private static void validateParameterName(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("'parameterName' may not be null.");
        }
    }

    public static String getOptionalStringParameter(Map<String, String> parameters, String parameterName, String defaultValue) {
        ParameterHelper.validateParameters(parameters);
        ParameterHelper.validateParameterName(parameterName);
        String value = parameters.get(parameterName);
        return value == null ? defaultValue : value;
    }

    public static boolean getOptionalBooleanParameter(Map<String, String> parameters, String parameterName, boolean defaultValue) throws JournalException {
        ParameterHelper.validateParameters(parameters);
        ParameterHelper.validateParameterName(parameterName);
        String string = parameters.get(parameterName);
        if (string == null) {
            return defaultValue;
        }
        if (string.equals("false")) {
            return false;
        }
        if (string.equals("true")) {
            return true;
        }
        throw new JournalException("'" + parameterName + "' parameter must be '" + "false" + "'(default) or '" + "true" + "'");
    }

    public static File parseParametersForWritableDirectory(Map<String, String> parameters, String parameterName) throws JournalException {
        String directoryString = parameters.get(parameterName);
        if (directoryString == null) {
            throw new JournalException("'" + parameterName + "' is required.");
        }
        File directory = new File(directoryString);
        if (!directory.exists()) {
            throw new JournalException("Directory '" + directory + "' does not exist.");
        }
        if (!directory.isDirectory()) {
            throw new JournalException("Directory '" + directory + "' is not a directory.");
        }
        if (!directory.canWrite()) {
            throw new JournalException("Directory '" + directory + "' is not writable.");
        }
        return directory;
    }

    public static String parseParametersForFilenamePrefix(Map<String, String> parameters) {
        return ParameterHelper.getOptionalStringParameter(parameters, "journalFilenamePrefix", "fedoraJournal");
    }

    public static long parseParametersForSizeLimit(Map<String, String> parameters) throws JournalException {
        String sizeString = ParameterHelper.getOptionalStringParameter(parameters, "journalFileSizeLimit", "5M");
        Pattern p = Pattern.compile("([0-9]+)([KMG]?)");
        Matcher m = p.matcher(sizeString);
        if (!m.matches()) {
            throw new JournalException("Parameter 'journalFileSizeLimit' must be an integer number of bytes, optionally followed by 'K', 'M', or 'G', or a 0 to indicate no size limit");
        }
        long size = Long.parseLong(m.group(1));
        String factor = m.group(2);
        if ("K".equals(factor)) {
            size *= 1024L;
        } else if ("M".equals(factor)) {
            size *= 0x100000L;
        } else if ("G".equals(factor)) {
            size *= 0x40000000L;
        }
        return size;
    }

    public static long parseParametersForAgeLimit(Map<String, String> parameters) throws JournalException {
        String ageString = ParameterHelper.getOptionalStringParameter(parameters, "journalFileAgeLimit", "1D");
        Pattern p = Pattern.compile("([0-9]+)([DHM]?)");
        Matcher m = p.matcher(ageString);
        if (!m.matches()) {
            throw new JournalException("Parameter 'journalFileAgeLimit' must be an integer number of seconds, optionally followed by 'D'(days), 'H'(hours), or 'M'(minutes), or a 0 to indicate no age limit");
        }
        long age = Long.parseLong(m.group(1)) * 1000L;
        String factor = m.group(2);
        if ("D".equals(factor)) {
            age *= 86400L;
        } else if ("H".equals(factor)) {
            age *= 3600L;
        } else if ("M".equals(factor)) {
            age *= 60L;
        }
        return age;
    }
}

