/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.managementmethods;

import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.entry.JournalEntry;
import org.fcrepo.server.journal.managementmethods.AddDatastreamMethod;
import org.fcrepo.server.journal.managementmethods.AddRelationshipMethod;
import org.fcrepo.server.journal.managementmethods.GetNextPidMethod;
import org.fcrepo.server.journal.managementmethods.IngestMethod;
import org.fcrepo.server.journal.managementmethods.ModifyDatastreamByReferenceMethod;
import org.fcrepo.server.journal.managementmethods.ModifyDatastreamByValueMethod;
import org.fcrepo.server.journal.managementmethods.ModifyObjectMethod;
import org.fcrepo.server.journal.managementmethods.PurgeDatastreamMethod;
import org.fcrepo.server.journal.managementmethods.PurgeObjectMethod;
import org.fcrepo.server.journal.managementmethods.PurgeRelationshipMethod;
import org.fcrepo.server.journal.managementmethods.PutTempStreamMethod;
import org.fcrepo.server.journal.managementmethods.SetDatastreamStateMethod;
import org.fcrepo.server.journal.managementmethods.SetDatastreamVersionableMethod;
import org.fcrepo.server.management.ManagementDelegate;

public abstract class ManagementMethod
implements JournalConstants {
    protected final JournalEntry parent;

    public static ManagementMethod getInstance(String methodName, JournalEntry parent) {
        if ("ingest".equals(methodName)) {
            return new IngestMethod(parent);
        }
        if ("modifyObject".equals(methodName)) {
            return new ModifyObjectMethod(parent);
        }
        if ("purgeObject".equals(methodName)) {
            return new PurgeObjectMethod(parent);
        }
        if ("addDatastream".equals(methodName)) {
            return new AddDatastreamMethod(parent);
        }
        if ("modifyDatastreamByReference".equals(methodName)) {
            return new ModifyDatastreamByReferenceMethod(parent);
        }
        if ("modifyDatastreamByValue".equals(methodName)) {
            return new ModifyDatastreamByValueMethod(parent);
        }
        if ("setDatastreamState".equals(methodName)) {
            return new SetDatastreamStateMethod(parent);
        }
        if ("setDatastreamVersionable".equals(methodName)) {
            return new SetDatastreamVersionableMethod(parent);
        }
        if ("purgeDatastream".equals(methodName)) {
            return new PurgeDatastreamMethod(parent);
        }
        if ("purgeRelationship".equals(methodName)) {
            return new PurgeRelationshipMethod(parent);
        }
        if ("putTempStream".equals(methodName)) {
            return new PutTempStreamMethod(parent);
        }
        if ("getNextPID".equals(methodName)) {
            return new GetNextPidMethod(parent);
        }
        if ("addRelationship".equals(methodName)) {
            return new AddRelationshipMethod(parent);
        }
        throw new IllegalArgumentException("Unrecognized method name: '" + methodName + "'");
    }

    protected ManagementMethod(JournalEntry parent) {
        this.parent = parent;
    }

    public abstract Object invoke(ManagementDelegate var1) throws ServerException, JournalException;
}

