/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportOutputFile {
    private static final Logger logger = LoggerFactory.getLogger(TransportOutputFile.class);
    private final File file;
    private final File tempFile;
    private State state = State.READY;
    private FileWriter fileWriter;

    public TransportOutputFile(File directory, String name) throws IOException {
        logger.debug("creating TransportOutputFile: '" + directory + "', '" + name + "'");
        this.file = new File(directory, name);
        if (this.file.exists()) {
            throw new IOException("File " + this.file + " already exists.");
        }
        this.tempFile = new File(directory, "_" + name);
        if (this.tempFile.exists()) {
            throw new IOException("File " + this.tempFile + " already exists.");
        }
    }

    public Writer open() throws IOException {
        switch (this.state) {
            case OPEN: {
                throw new IllegalStateException("File " + this.tempFile + " is already open.");
            }
            case CLOSED: {
                throw new IllegalStateException("File " + this.tempFile + " has been closed already.");
            }
        }
        this.state = State.OPEN;
        this.tempFile.createNewFile();
        this.fileWriter = new FileWriter(this.tempFile);
        return this.fileWriter;
    }

    public void close() throws IOException {
        switch (this.state) {
            case READY: {
                throw new IllegalStateException("File " + this.tempFile + " hasn't been opened yet.");
            }
            case CLOSED: {
                throw new IllegalStateException("File " + this.tempFile + " has been closed already.");
            }
        }
        this.fileWriter.close();
        this.tempFile.renameTo(this.file);
        this.state = State.CLOSED;
    }

    public String getName() {
        return this.file.getName();
    }

    private static enum State {
        READY,
        OPEN,
        CLOSED;

    }
}

