/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.helpers.FileMovingUtil;

class JournalInputFile {
    private final File file;
    private final FileReader fileReader;
    private final XMLEventReader xmlReader;

    public JournalInputFile(File file) throws JournalException {
        if (!file.isFile()) {
            throw new JournalException("Journal file '" + file.getPath() + "' is not a file.");
        }
        if (!file.canRead()) {
            throw new JournalException("Journal file '" + file.getPath() + "' is not readable.");
        }
        try {
            this.file = file;
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.fileReader = new FileReader(file);
            this.xmlReader = factory.createXMLEventReader(this.fileReader);
        }
        catch (FileNotFoundException e) {
            throw new JournalException(e);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
    }

    public String getFilename() {
        return this.file.getPath();
    }

    public void closeAndRename(File archiveDirectory) throws JournalException {
        try {
            this.xmlReader.close();
            this.fileReader.close();
            File archiveFile = new File(archiveDirectory, this.file.getName());
            try {
                FileMovingUtil.move(this.file, archiveFile);
            }
            catch (IOException e) {
                throw new JournalException("Failed to rename file from '" + this.file.getPath() + "' to '" + archiveFile.getPath() + "'", e);
            }
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
    }

    public XMLEventReader getReader() {
        return this.xmlReader;
    }
}

