/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.util.Map;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.readerwriter.multifile.JournalInputFile;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalHelper;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalReader;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;

public class MultiFileFollowingJournalReader
extends MultiFileJournalReader {
    private final long pollingIntervalMillis;

    public MultiFileFollowingJournalReader(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws JournalException {
        super(parameters, role, recoveryLog, server);
        this.pollingIntervalMillis = MultiFileJournalHelper.parseParametersForPollingInterval(parameters);
    }

    @Override
    protected synchronized JournalInputFile openNextFile() throws JournalException {
        while (this.open) {
            JournalInputFile nextFile = super.openNextFile();
            if (nextFile != null) {
                return nextFile;
            }
            try {
                this.wait(this.pollingIntervalMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    @Override
    public synchronized void shutdown() throws JournalException {
        super.shutdown();
        this.notifyAll();
    }
}

