/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.recoverylog;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenamingJournalRecoveryLog
extends JournalRecoveryLog {
    private static final Logger logger = LoggerFactory.getLogger(RenamingJournalRecoveryLog.class);
    String fileName;
    String tempFileName;
    private final File logFile;
    private final FileWriter writer;
    private boolean open = true;

    public RenamingJournalRecoveryLog(Map<String, String> parameters, String role, ServerInterface server) throws ModuleInitializationException {
        super(parameters, role, server);
        try {
            if (!parameters.containsKey("recoveryLogFilename")) {
                throw new ModuleInitializationException("Parameter 'recoveryLogFilename' is not set.", role);
            }
            String fileNameTemplate = parameters.get("recoveryLogFilename");
            this.fileName = JournalHelper.createTimestampedFilename(fileNameTemplate, new Date());
            this.tempFileName = this.insertHyphenBeforeFilename(this.fileName);
            this.logFile = new File(this.tempFileName);
            this.writer = new FileWriter(this.logFile);
            super.logHeaderInfo(parameters);
        }
        catch (IOException e) {
            throw new ModuleInitializationException("Problem writing to the recovery log", role, e);
        }
    }

    private String insertHyphenBeforeFilename(String name) {
        int lastSlash = name.lastIndexOf(File.separatorChar);
        if (lastSlash == -1) {
            return '_' + name;
        }
        return name.substring(0, lastSlash + 1) + '_' + name.substring(lastSlash + 1);
    }

    @Override
    public synchronized void log(String message) {
        try {
            if (this.open) {
                super.log(message, this.writer);
                this.writer.flush();
            }
        }
        catch (IOException e) {
            logger.error("Unable to write journal log message", (Throwable)e);
        }
    }

    @Override
    public synchronized void shutdown() {
        try {
            if (this.open) {
                this.open = false;
                this.writer.close();
                this.logFile.renameTo(new File(this.fileName));
            }
        }
        catch (IOException e) {
            logger.error("Error shutting down", (Throwable)e);
        }
    }

    public String toString() {
        return super.toString() + ", logFile='" + this.logFile.getPath() + "'";
    }
}

