/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.xmlhelpers;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalException;

public abstract class AbstractXmlReader
implements JournalConstants {
    protected void advancePastWhitespace(XMLEventReader reader) throws XMLStreamException {
        XMLEvent next = reader.peek();
        while (next.isCharacters() && next.asCharacters().isWhiteSpace()) {
            reader.nextEvent();
            next = reader.peek();
        }
    }

    protected XMLEvent readStartTag(XMLEventReader reader, QName tagName) throws XMLStreamException, JournalException {
        XMLEvent event = reader.nextTag();
        if (!this.isStartTagEvent(event, tagName)) {
            throw this.getNotStartTagException(tagName, event);
        }
        return event;
    }

    protected boolean isStartTagEvent(XMLEvent event, QName tagName) {
        return event.isStartElement() && event.asStartElement().getName().equals(tagName);
    }

    protected boolean isEndTagEvent(XMLEvent event, QName tagName) {
        return event.isEndElement() && event.asEndElement().getName().equals(tagName);
    }

    protected String getRequiredAttributeValue(StartElement start, QName attributeName) throws JournalException {
        Attribute mapNameAttribute = start.getAttributeByName(attributeName);
        if (mapNameAttribute == null) {
            throw new JournalException("Start tag '" + start + "' must contain a '" + attributeName + "' attribute.");
        }
        return mapNameAttribute.getValue();
    }

    protected String getOptionalAttributeValue(StartElement start, QName attributeName) {
        Attribute mapNameAttribute = start.getAttributeByName(attributeName);
        if (mapNameAttribute == null) {
            return null;
        }
        return mapNameAttribute.getValue();
    }

    protected String readCharactersUntilEndTag(XMLEventReader reader, QName tagName) throws XMLStreamException, JournalException {
        XMLEvent event;
        StringBuffer stringValue = new StringBuffer();
        while ((event = reader.nextEvent()).isCharacters()) {
            stringValue.append(event.asCharacters().getData());
        }
        if (!this.isEndTagEvent(event, tagName)) {
            throw this.getNotCharactersException(tagName, event);
        }
        return stringValue.toString();
    }

    protected JournalException getNotStartTagException(QName tagName, XMLEvent event) {
        return new JournalException("Expecting '" + tagName + "' start tag, but event was '" + event + "'");
    }

    protected JournalException getNotEndTagException(QName tagName, XMLEvent event) {
        return new JournalException("Expecting '" + tagName + "' end tag, but event was '" + event + "'");
    }

    protected JournalException getNotCharactersException(QName tagName, XMLEvent event) {
        return new JournalException("Expecting characters or '" + tagName + "' end tag, but event was '" + event + "'");
    }

    protected JournalException getNotNextMemberOrEndOfGroupException(QName groupTagName, QName memberTagName, XMLEvent event) {
        return new JournalException("Expecting either '" + memberTagName + "' start tag, or '" + groupTagName + "' end tag, but event was '" + event + "'");
    }
}

