/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.xmlhelpers;

import java.util.Iterator;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.Context;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.helpers.PasswordCipher;
import org.fcrepo.server.journal.xmlhelpers.AbstractXmlWriter;

public class ContextXmlWriter
extends AbstractXmlWriter {
    public void writeContext(JournalEntryContext context, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_CONTEXT);
        this.writeContextPassword(context, writer);
        this.writeContextNoOp(context, writer);
        this.writeContextNow(context, writer);
        this.writeMultiMap(writer, "environment", context.getEnvironmentAttributes());
        this.writeMultiMap(writer, "subject", context.getSubjectAttributes());
        this.writeMultiMap(writer, "action", context.getActionAttributes());
        this.writeMultiMap(writer, "resource", context.getResourceAttributes());
        this.writeMultiMap(writer, "recovery", context.getRecoveryAttributes());
        this.putEndTag(writer, QNAME_TAG_CONTEXT);
    }

    private void writeContextPassword(Context context, XMLEventWriter writer) throws XMLStreamException {
        String password = context.getPassword();
        if (password == null) {
            password = "";
        }
        this.putStartTag(writer, QNAME_TAG_PASSWORD);
        this.putAttribute(writer, QNAME_ATTR_PASSWORD_TYPE, "1");
        this.putCharacters(writer, this.encipherPassword(context, password));
        this.putEndTag(writer, QNAME_TAG_PASSWORD);
    }

    private String encipherPassword(Context context, String password) {
        String key = JournalHelper.formatDate(context.now());
        return PasswordCipher.encipher(key, password);
    }

    private void writeContextNoOp(Context context, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_NOOP);
        this.putCharacters(writer, String.valueOf(context.getNoOp()));
        this.putEndTag(writer, QNAME_TAG_NOOP);
    }

    private void writeContextNow(Context context, XMLEventWriter writer) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_NOW);
        this.putCharacters(writer, JournalHelper.formatDate(context.now()));
        this.putEndTag(writer, QNAME_TAG_NOW);
    }

    private void writeMultiMap(XMLEventWriter writer, String mapName, MultiValueMap map) throws XMLStreamException {
        this.putStartTag(writer, QNAME_TAG_MULTI_VALUE_MAP);
        this.putAttribute(writer, QNAME_ATTR_NAME, mapName);
        Iterator<String> attributes = map.names();
        while (attributes.hasNext()) {
            String[] values;
            String attribute = attributes.next();
            this.putStartTag(writer, QNAME_TAG_MULTI_VALUE_MAP_KEY);
            this.putAttribute(writer, QNAME_ATTR_NAME, attribute);
            for (String element : values = map.getStringArray(attribute)) {
                this.putStartTag(writer, QNAME_TAG_MULTI_VALUE_MAP_VALUE);
                this.putCharacters(writer, element);
                this.putEndTag(writer, QNAME_TAG_MULTI_VALUE_MAP_VALUE);
            }
            this.putEndTag(writer, QNAME_TAG_MULTI_VALUE_MAP_KEY);
        }
        this.putEndTag(writer, QNAME_TAG_MULTI_VALUE_MAP);
    }
}

