/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.fcrepo.common.PID;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.management.DBPIDGenerator;
import org.fcrepo.server.management.PIDGenerator;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPIDGenerator
extends Module
implements PIDGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BasicPIDGenerator.class);
    private DBPIDGenerator m_pidGenerator;
    private File m_oldPidGenDir;

    public BasicPIDGenerator(Map moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() {
        String dir = this.getParameter("pidgen_log_dir");
        if (dir != null && !dir.equals("")) {
            this.m_oldPidGenDir = dir.startsWith("/") || dir.startsWith("\\") || dir.substring(1).startsWith(":\\") ? new File(dir) : new File(this.getServer().getHomeDir(), dir);
        }
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        ConnectionPoolManager mgr = (ConnectionPoolManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ConnectionPoolManager"));
        if (mgr == null) {
            throw new ModuleInitializationException("ConnectionPoolManager module not loaded.", this.getRole());
        }
        try {
            this.m_pidGenerator = new DBPIDGenerator(mgr.getPool(), this.m_oldPidGenDir);
        }
        catch (Exception e) {
            String msg = "Can't get default connection pool";
            logger.error(msg, (Throwable)e);
            throw new ModuleInitializationException(msg, this.getRole());
        }
    }

    @Override
    public PID generatePID(String namespaceID) throws IOException {
        return this.m_pidGenerator.generatePID(namespaceID);
    }

    @Override
    public PID getLastPID() throws IOException {
        return this.m_pidGenerator.getLastPID();
    }

    @Override
    public void neverGeneratePID(String pid) throws IOException {
        this.m_pidGenerator.neverGeneratePID(pid);
    }
}

