/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.PIDGenerator;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.utilities.SQLUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPIDGenerator
implements PIDGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DBPIDGenerator.class);
    private final HashMap m_highestID;
    private PID m_lastPID;
    private final ConnectionPool m_connectionPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DBPIDGenerator(ConnectionPool cPool, File oldPidGenDir) throws IOException {
        this.m_connectionPool = cPool;
        this.m_highestID = new HashMap();
        Statement s = null;
        ResultSet results = null;
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getReadOnlyConnection();
            String query = "SELECT namespace, highestID FROM pidGen";
            s = conn.createStatement();
            results = s.executeQuery(query);
            while (results.next()) {
                this.m_highestID.put(results.getString("namespace"), new Integer(results.getInt("highestID")));
            }
        }
        catch (SQLException sqle) {
            logger.warn("Unable to read pidGen table; assuming it will be created shortly");
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                    if (conn != null) {
                        this.m_connectionPool.free(conn);
                    }
                    results = null;
                    s = null;
                }
                catch (SQLException sqle2) {
                    logger.warn("Error trying to free db resources in DBPIDGenerator", (Throwable)sqle2);
                    results = null;
                    s = null;
                }
            }
            catch (Throwable throwable) {
                results = null;
                s = null;
                throw throwable;
            }
        }
        this.upgradeIfNeeded(oldPidGenDir);
    }

    private void upgradeIfNeeded(File oldPidGenDir) throws IOException {
        if (oldPidGenDir != null && oldPidGenDir.isDirectory()) {
            Object[] names = oldPidGenDir.list();
            Arrays.sort(names);
            if (names.length > 0) {
                String[] parts;
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(new File(oldPidGenDir, (String)names[names.length - 1]))));
                String lastLine = null;
                while ((line = in.readLine()) != null) {
                    lastLine = line;
                }
                in.close();
                if (lastLine != null && (parts = lastLine.split("|")).length == 2) {
                    this.neverGeneratePID(parts[0]);
                }
            }
        }
    }

    @Override
    public synchronized PID generatePID(String namespace) throws IOException {
        int i = this.getHighestID(namespace);
        ++i;
        try {
            this.m_lastPID = new PID(namespace + ":" + i);
        }
        catch (MalformedPIDException e) {
            throw new IOException(e.getMessage());
        }
        this.setHighestID(namespace, i);
        return this.m_lastPID;
    }

    @Override
    public synchronized PID getLastPID() {
        return this.m_lastPID;
    }

    @Override
    public synchronized void neverGeneratePID(String pid) throws IOException {
        logger.debug("Never generating PID: " + pid);
        try {
            PID p = new PID(pid);
            String ns = p.getNamespaceId();
            int id = Integer.parseInt(p.getObjectId());
            if (id > this.getHighestID(ns)) {
                this.setHighestID(ns, id);
            }
        }
        catch (MalformedPIDException mpe) {
            throw new IOException(mpe.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private int getHighestID(String namespace) {
        Integer i = (Integer)this.m_highestID.get(namespace);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private void setHighestID(String namespace, int id) throws IOException {
        logger.debug("Setting highest ID for " + namespace + " to " + id);
        this.m_highestID.put(namespace, new Integer(id));
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getReadWriteConnection();
            SQLUtility.replaceInto(conn, "pidGen", new String[]{"namespace", "highestID"}, new String[]{namespace, "" + id}, "namespace", new boolean[]{false, true});
        }
        catch (SQLException sqle) {
            throw new IOException("Error setting highest id for namespace in db: " + sqle.getMessage());
        }
        finally {
            if (conn != null) {
                this.m_connectionPool.free(conn);
            }
        }
    }
}

