/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.Context;
import org.fcrepo.server.RecoveryContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.DatastreamLockedException;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.InvalidStateException;
import org.fcrepo.server.errors.InvalidXMLNameException;
import org.fcrepo.server.errors.ObjectLockedException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamReadException;
import org.fcrepo.server.errors.StreamWriteException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.DOWriter;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.storage.types.XMLDatastreamProcessor;
import org.fcrepo.server.utilities.DCFields;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.validation.ValidationConstants;
import org.fcrepo.server.validation.ValidationUtility;
import org.fcrepo.server.validation.ecm.EcmValidator;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DefaultManagement
implements Constants,
Management,
ManagementDelegate {
    private static final Logger logger = LoggerFactory.getLogger(DefaultManagement.class);
    private final Authorization m_authz;
    private final DOManager m_manager;
    private final ExternalContentManager m_contentManager;
    private final int m_uploadStorageMinutes;
    private int m_lastId;
    private final File m_tempDir;
    private final Hashtable<String, Long> m_uploadStartTime;
    private long m_lastPurgeInMillis = System.currentTimeMillis();
    private final long m_purgeDelayInMillis;
    private final EcmValidator ecmValidator;
    private static final String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public DefaultManagement(Authorization authz, DOManager doMgr, ExternalContentManager ecMgr, int uploadMinutes, int lastId, File tempDir, Hashtable<String, Long> uploadStartTime, long purgeDelayInMillis) {
        this.m_authz = authz;
        this.m_manager = doMgr;
        this.m_contentManager = ecMgr;
        this.m_uploadStorageMinutes = uploadMinutes;
        this.m_lastId = lastId;
        this.m_tempDir = tempDir;
        this.m_uploadStartTime = uploadStartTime;
        this.m_purgeDelayInMillis = purgeDelayInMillis;
        this.ecmValidator = new EcmValidator(doMgr, this.m_contentManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
        String string;
        DOWriter w = null;
        String objPid = null;
        try {
            logger.debug("Entered ingest");
            w = this.m_manager.getIngestWriter(false, context, serialization, format, encoding, pid);
            objPid = w.GetObjectPID();
            this.m_authz.enforceIngest(context, objPid, format, encoding);
            if (logMessage != null && !logMessage.equals("")) {
                Date nowUTC = Server.getCurrentDate(context);
                this.addAuditRecord(context, w, "ingest", "", logMessage, nowUTC);
            }
            w.commit(logMessage);
            string = objPid;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed ingest(");
                logMsg.append("objectXML");
                logMsg.append(", format: ").append(format);
                logMsg.append(", encoding: ").append(encoding);
                logMsg.append(", pid\t: ").append(objPid);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "ingest");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed ingest(");
            logMsg.append("objectXML");
            logMsg.append(", format: ").append(format);
            logMsg.append(", encoding: ").append(encoding);
            logMsg.append(", pid\t: ").append(objPid);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "ingest");
        return string;
    }

    private void finishModification(DOWriter w, String method) throws ServerException {
        if (w != null) {
            this.m_manager.releaseWriter(w);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting " + method);
            Runtime r = Runtime.getRuntime();
            logger.debug("Memory: " + r.freeMemory() + " bytes free of " + r.totalMemory() + " available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date modifyObject(Context context, String pid, String state, String label, String ownerId, String logMessage, Date lastModifiedDate) throws ServerException {
        Date date;
        DOWriter w = null;
        try {
            logger.debug("Entered modifyObject");
            this.m_authz.enforceModifyObject(context, pid, state, ownerId);
            this.checkObjectLabel(label);
            w = this.m_manager.getWriter(false, context, pid);
            if (lastModifiedDate != null && lastModifiedDate.before(w.getLastModDate())) {
                String objDate = DateUtility.convertDateToXSDString((Date)w.getLastModDate());
                String reqDate = DateUtility.convertDateToXSDString((Date)lastModifiedDate);
                String msg = String.format("%s lastModifiedDate (%s) is more recent than the request (%s)", pid, objDate, reqDate);
                throw new ObjectLockedException(msg);
            }
            if (state != null && !state.equals("")) {
                if (!(state.equals("A") || state.equals("D") || state.equals("I"))) {
                    throw new InvalidStateException("The object state of \"" + state + "\" is invalid. The allowed values for state are: " + " A (active), D (deleted), and I (inactive).");
                }
                w.setState(state);
            }
            if (label != null) {
                w.setLabel(label);
            }
            if (ownerId != null) {
                w.setOwnerId(ownerId);
            }
            Date nowUTC = Server.getCurrentDate(context);
            this.addAuditRecord(context, w, "modifyObject", "", logMessage, nowUTC);
            w.commit(logMessage);
            date = w.getLastModDate();
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed modifyObject(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", state: ").append(state);
                logMsg.append(", label: ").append(label);
                logMsg.append(", ownderId: ").append(ownerId);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "modifyObject");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed modifyObject(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", state: ").append(state);
            logMsg.append(", label: ").append(label);
            logMsg.append(", ownderId: ").append(ownerId);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "modifyObject");
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getObjectXML(Context context, String pid, String encoding) throws ServerException {
        try {
            InputStream instream;
            logger.debug("Entered getObjectXML");
            this.m_authz.enforceGetObjectXML(context, pid, encoding);
            DOReader reader = this.m_manager.getReader(false, context, pid);
            InputStream inputStream = instream = reader.GetObjectXML();
            return inputStream;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed getObjectXML(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", encoding: ").append(encoding);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting getObjectXML");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        try {
            InputStream instream;
            logger.debug("Entered export");
            this.m_authz.enforceExport(context, pid, format, exportContext, encoding);
            DOReader reader = this.m_manager.getReader(false, context, pid);
            InputStream inputStream = instream = reader.Export(format, exportContext);
            return inputStream;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed export(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", format: ").append(format);
                logMsg.append(", exportContext: ").append(exportContext);
                logMsg.append(", encoding: ").append(encoding);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting export");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        Date date;
        DOWriter w = null;
        try {
            Date serverDate;
            logger.debug("Entered purgeObject");
            this.m_authz.enforcePurgeObject(context, pid);
            w = this.m_manager.getWriter(false, context, pid);
            w.remove();
            w.commit(logMessage);
            date = serverDate = Server.getCurrentDate(context);
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed purgeObject(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "purgeObject");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed purgeObject(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "purgeObject");
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String dsLocation, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        DefaultManagement.logger.debug("Entered addDatastream");
        if (MIMEType == null) {
            MIMEType = "";
        }
        if (altIDs == null) {
            altIDs = new String[]{};
        }
        if (dsID == null && context instanceof RecoveryContext && (dsID = (rContext = (RecoveryContext)context).getRecoveryValue(Constants.RECOVERY.DATASTREAM_ID.uri)) != null) {
            DefaultManagement.logger.debug("Using new dsID from recovery context");
        }
        if (dsID != null && !XMLUtils.isWellFormedXMLName((String)dsID)) {
            throw new InvalidXMLNameException("Invalid syntax for datastream ID. The datastream ID of \"" + dsID + "\" is" + "not a valid XML Name");
        }
        if (dsID != null && (dsID.equals("AUDIT") || dsID.equals("FEDORA-AUDITTRAIL"))) {
            throw new GeneralException("Creation of a datastream with an identifier of 'AUDIT' or 'FEDORA-AUDITTRAIL' is not permitted.");
        }
        w = null;
        try {
            this.m_authz.enforceAddDatastream(context, pid, dsID, altIDs, MIMEType, formatURI, dsLocation, controlGroup, dsState, checksumType, checksum);
            this.checkDatastreamID(dsID);
            this.checkDatastreamLabel(dsLabel);
            w = this.m_manager.getWriter(false, context, pid);
            if (controlGroup.equals("X")) {
                ds = new DatastreamXMLMetadata();
                ds.DSInfoType = "";
                try {
                    mimeTypedStream = null;
                    if (dsLocation.startsWith("uploaded://")) {
                        in = this.getTempStream(dsLocation);
                    } else {
                        params = new ContentManagerParams(dsLocation);
                        params.setContext(context);
                        mimeTypedStream = this.m_contentManager.getExternalContent(params);
                        in = mimeTypedStream.getStream();
                    }
                    dsm = ds;
                    dsm.xmlContent = this.getEmbeddableXML(in);
                    ValidationUtility.validateReservedDatastream(PID.getInstance((String)pid), dsID, dsm);
                    if (mimeTypedStream == null) ** GOTO lbl50
                    mimeTypedStream.close();
                }
                catch (Exception e) {
                    extraInfo = e.getMessage() == null ? "" : " : " + e.getMessage();
                    throw new GeneralException("Error with " + dsLocation + extraInfo);
                }
            } else if (controlGroup.equals("M")) {
                ds = new DatastreamManagedContent();
                ds.DSInfoType = "DATA";
                ds.DSLocationType = "URL";
            } else if (controlGroup.equals("R") || controlGroup.equals("E")) {
                ds = new DatastreamReferencedContent();
                ds.DSInfoType = "DATA";
                ds.DSLocationType = "URL";
            } else {
                throw new GeneralException("Invalid control group: " + controlGroup);
            }
lbl50:
            // 4 sources

            ds.isNew = true;
            ds.DSControlGrp = controlGroup;
            ds.DSVersionable = versionable;
            if (!(dsState.equals("A") || dsState.equals("D") || dsState.equals("I"))) {
                throw new InvalidStateException("The datastream state of \"" + dsState + "\" is invalid. The allowed values for state are: " + " A (active), D (deleted), and I (inactive).");
            }
            ds.DSState = dsState;
            if (dsID == null || dsID.length() == 0) {
                ds.DatastreamID = w.newDatastreamID();
            } else {
                if (dsID.indexOf(" ") != -1) {
                    throw new GeneralException("Datastream ids cannot contain spaces.");
                }
                if (dsID.indexOf("+") != -1) {
                    throw new GeneralException("Datastream ids cannot contain plusses.");
                }
                if (dsID.indexOf(":") != -1) {
                    throw new GeneralException("Datastream ids cannot contain colons.");
                }
                if (w.GetDatastream(dsID, null) != null) {
                    throw new GeneralException("A datastream already exists with ID: " + dsID);
                }
                ds.DatastreamID = dsID;
            }
            ds.DSVersionID = ds.DatastreamID + ".0";
            ds.DSLabel = dsLabel;
            ds.DSLocation = dsLocation;
            if (dsLocation != null) {
                ValidationUtility.validateURL(dsLocation, ds.DSControlGrp);
            }
            ds.DSFormatURI = formatURI;
            ds.DatastreamAltIDs = altIDs;
            ds.DSMIME = MIMEType;
            ds.DSChecksumType = Datastream.validateChecksumType(checksumType);
            if (controlGroup.equals("M")) {
                ValidationUtility.validateReservedDatastream(PID.getInstance((String)pid), dsID, ds);
            }
            if (checksum != null && checksumType != null && !checksum.equals(check = ds.getChecksum())) {
                throw new ValidationException("Checksum Mismatch: " + check);
            }
            nowUTC = Server.getCurrentDate(context);
            this.addAuditRecord(context, w, "addDatastream", ds.DatastreamID, logMessage, nowUTC);
            ds.DSCreateDT = nowUTC;
            w.addDatastream(ds, true);
            w.commit("Added a new datastream");
            var18_17 = ds.DatastreamID;
        }
        catch (Throwable var20_22) {
            if (DefaultManagement.logger.isInfoEnabled()) {
                logMsg = new StringBuilder("Completed addDatastream(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", dsID: ").append(dsID);
                DefaultManagement.appendAltIDs(logMsg, altIDs);
                logMsg.append(", dsLabel: ").append(dsLabel);
                logMsg.append(", versionable: ").append(versionable);
                logMsg.append(", MIMEType: ").append(MIMEType);
                logMsg.append(", formatURI: ").append(formatURI);
                logMsg.append(", dsLocation: ").append(dsLocation);
                logMsg.append(", controlGroup: ").append(controlGroup);
                logMsg.append(", dsState: ").append(dsState);
                logMsg.append(", checksumType: ").append(checksumType);
                logMsg.append(", checksum: ").append(checksum);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                DefaultManagement.logger.info(logMsg.toString());
            }
            this.finishModification(w, "addDatastream");
            throw var20_22;
        }
        if (DefaultManagement.logger.isInfoEnabled()) {
            logMsg = new StringBuilder("Completed addDatastream(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", dsID: ").append(dsID);
            DefaultManagement.appendAltIDs(logMsg, altIDs);
            logMsg.append(", dsLabel: ").append(dsLabel);
            logMsg.append(", versionable: ").append(versionable);
            logMsg.append(", MIMEType: ").append(MIMEType);
            logMsg.append(", formatURI: ").append(formatURI);
            logMsg.append(", dsLocation: ").append(dsLocation);
            logMsg.append(", controlGroup: ").append(controlGroup);
            logMsg.append(", dsState: ").append(dsState);
            logMsg.append(", checksumType: ").append(checksumType);
            logMsg.append(", checksum: ").append(checksum);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            DefaultManagement.logger.info(logMsg.toString());
        }
        this.finishModification(w, "addDatastream");
        return var18_17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date modifyDatastreamByReference(Context context, String pid, String datastreamId, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        Date date;
        if (datastreamId != null && !XMLUtils.isWellFormedXMLName((String)datastreamId)) {
            throw new InvalidXMLNameException("Invalid syntax for datastream ID. The datastream ID of \"" + datastreamId + "\" is not a valid XML Name");
        }
        if (datastreamId.equals("AUDIT") || datastreamId.equals("FEDORA-AUDITTRAIL")) {
            throw new GeneralException("Modification of the system-controlled AUDIT datastream is not permitted.");
        }
        DOWriter w = null;
        try {
            Date nowUTC;
            logger.debug("Entered modifyDatastreamByReference");
            this.m_authz.enforceModifyDatastreamByReference(context, pid, datastreamId, altIDs, mimeType, formatURI, dsLocation, checksumType, checksum);
            this.checkDatastreamLabel(dsLabel);
            w = this.m_manager.getWriter(false, context, pid);
            Datastream orig = w.GetDatastream(datastreamId, null);
            if (orig == null) {
                throw new DatastreamNotFoundException("Object " + pid + " has no datastream " + datastreamId + " to modify");
            }
            if (lastModifiedDate != null && lastModifiedDate.before(orig.DSCreateDT)) {
                String dsDate = DateUtility.convertDateToXSDString((Date)w.getLastModDate());
                String reqDate = DateUtility.convertDateToXSDString((Date)lastModifiedDate);
                String msg = String.format("%s/%s lastModifiedDate (%s) is more recent than the request (%s)", pid, datastreamId, dsDate, reqDate);
                throw new DatastreamLockedException(msg);
            }
            if (orig.DSControlGrp.equals("X")) {
                throw new GeneralException("Inline XML datastreams must be modified by value, not by reference.");
            }
            if (orig.DSState.equals("D")) {
                throw new GeneralException("Changing attributes on deleted datastreams is forbidden.");
            }
            if (dsLabel == null) {
                dsLabel = orig.DSLabel;
            }
            if (mimeType == null) {
                mimeType = orig.DSMIME;
            }
            if (formatURI == null) {
                formatURI = orig.DSFormatURI;
            }
            if (altIDs == null) {
                altIDs = orig.DatastreamAltIDs;
            }
            checksumType = checksumType == null ? orig.DSChecksumType : Datastream.validateChecksumType(checksumType);
            if (dsLocation == null || dsLocation.equals("")) {
                dsLocation = orig.DSControlGrp.equals("M") ? "copy://" + orig.DSLocation : orig.DSLocation;
            } else {
                ValidationUtility.validateURL(dsLocation, orig.DSControlGrp);
            }
            Datastream newds = orig.DSControlGrp.equals("M") ? new DatastreamManagedContent() : new DatastreamReferencedContent();
            newds.DatastreamID = orig.DatastreamID;
            newds.DSControlGrp = orig.DSControlGrp;
            newds.DSInfoType = orig.DSInfoType;
            newds.DSState = orig.DSState;
            newds.DSVersionable = orig.DSVersionable;
            newds.DSVersionID = w.newDatastreamID(datastreamId);
            newds.DSLabel = dsLabel;
            newds.DSMIME = mimeType;
            newds.DSFormatURI = formatURI;
            newds.DatastreamAltIDs = altIDs;
            newds.DSCreateDT = nowUTC = Server.getCurrentDate(context);
            newds.DSLocation = dsLocation;
            newds.DSLocationType = "URL";
            newds.DSChecksumType = checksumType;
            if (!newds.DSLocation.startsWith("copy://") && !newds.DSLocation.equals(orig.DSLocation)) {
                ValidationUtility.validateReservedDatastream(PID.getInstance((String)pid), datastreamId, newds);
            }
            w.addDatastream(newds, orig.DSVersionable);
            if (checksum != null) {
                String check;
                if (checksumType == null) {
                    newds.DSChecksumType = orig.DSChecksumType;
                }
                if (!checksum.equals(check = newds.getChecksum())) {
                    throw new ValidationException("Checksum Mismatch: " + check);
                }
            }
            this.addAuditRecord(context, w, "modifyDatastreamByReference", newds.DatastreamID, logMessage, nowUTC);
            w.commit(logMessage);
            date = nowUTC;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed modifyDatastreamByReference(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamId: ").append(datastreamId);
                DefaultManagement.appendAltIDs(logMsg, altIDs);
                logMsg.append(", dsLabel: ").append(dsLabel);
                logMsg.append(", mimeType: ").append(mimeType);
                logMsg.append(", formatURI: ").append(formatURI);
                logMsg.append(", dsLocation: ").append(dsLocation);
                logMsg.append(", checksumType: ").append(checksumType);
                logMsg.append(", checksum: ").append(checksum);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "modifyDatastreamByReference");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed modifyDatastreamByReference(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", datastreamId: ").append(datastreamId);
            DefaultManagement.appendAltIDs(logMsg, altIDs);
            logMsg.append(", dsLabel: ").append(dsLabel);
            logMsg.append(", mimeType: ").append(mimeType);
            logMsg.append(", formatURI: ").append(formatURI);
            logMsg.append(", dsLocation: ").append(dsLocation);
            logMsg.append(", checksumType: ").append(checksumType);
            logMsg.append(", checksum: ").append(checksum);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "modifyDatastreamByReference");
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date modifyDatastreamByValue(Context context, String pid, String datastreamId, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        Date date;
        if (datastreamId != null && !XMLUtils.isWellFormedXMLName((String)datastreamId)) {
            throw new InvalidXMLNameException("Invalid syntax for datastream ID. The datastream ID of \"" + datastreamId + "\" is not a valid XML Name");
        }
        if (datastreamId.equals("AUDIT") || datastreamId.equals("FEDORA-AUDITTRAIL")) {
            throw new GeneralException("Modification of the system-controlled AUDIT datastream is not permitted.");
        }
        DOWriter w = null;
        try {
            String check;
            Date nowUTC;
            logger.debug("Entered modifyDatastreamByValue");
            this.m_authz.enforceModifyDatastreamByValue(context, pid, datastreamId, altIDs, mimeType, formatURI, checksumType, checksum);
            this.checkDatastreamLabel(dsLabel);
            w = this.m_manager.getWriter(false, context, pid);
            Datastream orig = w.GetDatastream(datastreamId, null);
            if (orig == null) {
                throw new DatastreamNotFoundException("Object " + pid + " has no datastream " + datastreamId + " to modify");
            }
            XMLDatastreamProcessor origxml = new XMLDatastreamProcessor(orig);
            if (lastModifiedDate != null && lastModifiedDate.before(orig.DSCreateDT)) {
                String dsDate = DateUtility.convertDateToXSDString((Date)w.getLastModDate());
                String reqDate = DateUtility.convertDateToXSDString((Date)lastModifiedDate);
                String msg = String.format("%s/%s lastModifiedDate (%s) is more recent than the request (%s)", pid, datastreamId, dsDate, reqDate);
                throw new DatastreamLockedException(msg);
            }
            if (orig.DSState.equals("D")) {
                throw new GeneralException("Changing attributes on deleted datastreams is forbidden.");
            }
            if (!orig.DSControlGrp.equals("X") && !orig.DSControlGrp.equals("M")) {
                throw new GeneralException("Only content of inline XML and managed content datastreams may be modified by value.\nUse modifyDatastreamByReference instead.");
            }
            if (dsLabel == null) {
                dsLabel = orig.DSLabel;
            }
            if (mimeType == null) {
                mimeType = orig.DSMIME;
            }
            if (formatURI == null) {
                formatURI = orig.DSFormatURI;
            }
            if (altIDs == null) {
                altIDs = orig.DatastreamAltIDs;
            }
            checksumType = checksumType == null ? orig.DSChecksumType : Datastream.validateChecksumType(checksumType);
            if (dsContent != null && "DC".equals(datastreamId)) {
                DCFields audited = new DCFields(dsContent);
                try {
                    dsContent = new ByteArrayInputStream(audited.getAsXML(pid).getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
            }
            XMLDatastreamProcessor newdsxml = origxml.newVersion();
            Datastream newds = newdsxml.getDatastream();
            newdsxml.setDSMDClass(origxml.getDSMDClass());
            if (dsContent == null) {
                newdsxml.setXMLContent(origxml.getXMLContent());
            } else {
                newdsxml.setXMLContent(this.getEmbeddableXML(dsContent));
                ValidationUtility.validateReservedDatastream(PID.getInstance((String)pid), orig.DatastreamID, newds);
            }
            newds.DatastreamID = orig.DatastreamID;
            newds.DSControlGrp = orig.DSControlGrp;
            newds.DSInfoType = orig.DSInfoType;
            newds.DSState = orig.DSState;
            newds.DSVersionable = orig.DSVersionable;
            newds.DSVersionID = w.newDatastreamID(datastreamId);
            newds.DSLabel = dsLabel;
            newds.DatastreamAltIDs = altIDs;
            newds.DSMIME = mimeType;
            newds.DSFormatURI = formatURI;
            newds.DSCreateDT = nowUTC = Server.getCurrentDate(context);
            newds.DSChecksumType = checksumType;
            w.addDatastream(newds, orig.DSVersionable);
            if (checksum != null && !checksum.equals(check = newds.getChecksum())) {
                throw new ValidationException("Checksum Mismatch: " + check);
            }
            this.addAuditRecord(context, w, "modifyDatastreamByValue", newds.DatastreamID, logMessage, nowUTC);
            w.commit(logMessage);
            date = nowUTC;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed modifyDatastreamByValue(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamId: ").append(datastreamId);
                DefaultManagement.appendAltIDs(logMsg, altIDs);
                logMsg.append(", dsLabel: ").append(dsLabel);
                logMsg.append(", mimeType: ").append(mimeType);
                logMsg.append(", formatURI: ").append(formatURI);
                logMsg.append(", dsContent ");
                logMsg.append(", checksumType: ").append(checksumType);
                logMsg.append(", checksum: ").append(checksum);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "modifyDatastreamByValue");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed modifyDatastreamByValue(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", datastreamId: ").append(datastreamId);
            DefaultManagement.appendAltIDs(logMsg, altIDs);
            logMsg.append(", dsLabel: ").append(dsLabel);
            logMsg.append(", mimeType: ").append(mimeType);
            logMsg.append(", formatURI: ").append(formatURI);
            logMsg.append(", dsContent ");
            logMsg.append(", checksumType: ").append(checksumType);
            logMsg.append(", checksum: ").append(checksum);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "modifyDatastreamByValue");
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date[] purgeDatastream(Context context, String pid, String datastreamID, Date startDT, Date endDT, String logMessage) throws ServerException {
        Date[] dateArray;
        DOWriter w = null;
        try {
            logger.debug("Entered purgeDatastream");
            this.m_authz.enforcePurgeDatastream(context, pid, datastreamID, endDT);
            w = this.m_manager.getWriter(false, context, pid);
            Date[] deletedDates = w.removeDatastream(datastreamID, startDT, endDT);
            if (w.GetDatastream(datastreamID, null) == null) {
                ArrayList<String> usedList = new ArrayList<String>();
                if (datastreamID.equals("DC")) {
                    usedList.add("The default disseminator");
                }
                if (usedList.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Cannot purge entire datastream because it\n");
                    msg.append("is used by the following disseminators:");
                    for (int i = 0; i < usedList.size(); ++i) {
                        msg.append("\n - " + (String)usedList.get(i));
                    }
                    throw new GeneralException(msg.toString());
                }
            }
            logMessage = logMessage == null ? "" : logMessage + " . . . ";
            logMessage = logMessage + this.getPurgeLogMessage("datastream", datastreamID, startDT, endDT, deletedDates);
            Date nowUTC = Server.getCurrentDate(context);
            this.addAuditRecord(context, w, "purgeDatastream", datastreamID, logMessage, nowUTC);
            w.commit(logMessage);
            dateArray = deletedDates;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed purgeDatastream(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamID: ").append(datastreamID);
                logMsg.append(", startDT: ").append(startDT);
                logMsg.append(", endDT: ").append(endDT);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "purgeDatastream");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed purgeDatastream(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", datastreamID: ").append(datastreamID);
            logMsg.append(", startDT: ").append(startDT);
            logMsg.append(", endDT: ").append(endDT);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "purgeDatastream");
        return dateArray;
    }

    private String getPurgeLogMessage(String kindaThing, String id, Date start, Date end, Date[] deletedDates) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        StringBuffer buf = new StringBuffer();
        buf.append("Purged ");
        buf.append(kindaThing);
        buf.append(" (ID=");
        buf.append(id);
        buf.append("), versions ranging from ");
        if (start == null) {
            buf.append("the beginning of time");
        } else {
            buf.append(formatter.format(start));
        }
        buf.append(" to ");
        if (end == null) {
            buf.append("the end of time");
        } else {
            buf.append(formatter.format(end));
        }
        buf.append(".  This resulted in the permanent removal of ");
        buf.append(deletedDates.length + " ");
        buf.append(kindaThing);
        buf.append(" version(s) (");
        for (int i = 0; i < deletedDates.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(formatter.format(deletedDates[i]));
        }
        buf.append(") and all associated audit records.");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datastream getDatastream(Context context, String pid, String datastreamID, Date asOfDateTime) throws ServerException {
        try {
            logger.debug("Entered getDatastream");
            this.m_authz.enforceGetDatastream(context, pid, datastreamID, asOfDateTime);
            DOReader r = this.m_manager.getReader(false, context, pid);
            Datastream datastream = r.GetDatastream(datastreamID, asOfDateTime);
            return datastream;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed getDatastream(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamID: ").append(datastreamID);
                logMsg.append(", asOfDateTime: ").append(asOfDateTime);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting getDatastream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String state) throws ServerException {
        try {
            logger.debug("Entered getDatastreams");
            this.m_authz.enforceGetDatastreams(context, pid, asOfDateTime, state);
            DOReader r = this.m_manager.getReader(false, context, pid);
            Datastream[] datastreamArray = r.GetDatastreams(asOfDateTime, state);
            return datastreamArray;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed getDatastreams(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", asOfDateTime: ").append(asOfDateTime);
                logMsg.append(", state: ").append(state);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting getDatastreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datastream[] getDatastreamHistory(Context context, String pid, String datastreamID) throws ServerException {
        try {
            logger.debug("Entered getDatastreamHistory");
            this.m_authz.enforceGetDatastreamHistory(context, pid, datastreamID);
            DOReader r = this.m_manager.getReader(false, context, pid);
            Date[] versionDates = r.getDatastreamVersions(datastreamID);
            Datastream[] versions = new Datastream[versionDates.length];
            for (int i = 0; i < versionDates.length; ++i) {
                versions[i] = r.GetDatastream(datastreamID, versionDates[i]);
            }
            Arrays.sort(versions, new DatastreamDateComparator());
            Datastream[] out = new Datastream[versions.length];
            for (int i = 0; i < versions.length; ++i) {
                out[i] = versions[versions.length - 1 - i];
            }
            Datastream[] datastreamArray = out;
            return datastreamArray;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed getDatastreamHistory(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamID: ").append(datastreamID);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting getDatastreamHistory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        try {
            RecoveryContext rContext;
            logger.debug("Entered getNextPID");
            this.m_authz.enforceGetNextPid(context, namespace, numPIDs);
            String[] pidList = null;
            if (context instanceof RecoveryContext && (pidList = (rContext = (RecoveryContext)context).getRecoveryValues(Constants.RECOVERY.PID_LIST.uri)) != null && pidList.length > 0) {
                logger.debug("Reserving and returning PID_LIST from recovery context");
                this.m_manager.reservePIDs(pidList);
            }
            if (pidList == null || pidList.length == 0) {
                pidList = this.m_manager.getNextPID(numPIDs, namespace);
            }
            String[] stringArray = pidList;
            return stringArray;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed getNextPID(");
                logMsg.append("numPIDs: ").append(numPIDs);
                logMsg.append(", namespace: ").append(namespace);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting getNextPID");
        }
    }

    @Override
    public String putTempStream(Context context, InputStream in) throws StreamWriteException, AuthzException {
        this.m_authz.enforceUpload(context);
        this.purgeUploadedFiles();
        String id = Integer.toString(this.getNextTempId(context));
        File outFile = new File(this.m_tempDir, "" + id);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            StreamUtility.pipeStream(in, out, 32768);
        }
        catch (Exception e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                outFile.delete();
            }
            throw new StreamWriteException("Error writing temp stream", e);
        }
        long now = System.currentTimeMillis();
        this.m_uploadStartTime.put(id, new Long(now));
        return "uploaded://" + id;
    }

    private synchronized int getNextTempId(Context context) {
        RecoveryContext rContext;
        String uploadURL;
        int recoveryId = -1;
        if (context instanceof RecoveryContext && (uploadURL = (rContext = (RecoveryContext)context).getRecoveryValue(Constants.RECOVERY.UPLOAD_ID.uri)) != null) {
            try {
                String n = uploadURL.substring(11);
                recoveryId = Integer.parseInt(n);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse UPLOAD_ID from recovery context: '" + uploadURL + "'");
            }
        }
        this.m_lastId = recoveryId == -1 ? ++this.m_lastId : recoveryId;
        return this.m_lastId;
    }

    @Override
    public InputStream getTempStream(String id) throws StreamReadException {
        if (id.startsWith("uploaded://") || id.length() < 12) {
            String internalId = id.substring(11);
            if (this.m_uploadStartTime.get(internalId) != null) {
                try {
                    return new FileInputStream(new File(this.m_tempDir, internalId));
                }
                catch (Exception e) {
                    throw new StreamReadException(e.getMessage());
                }
            }
            throw new StreamReadException("Id specified, '" + id + "', does not match an existing file.");
        }
        throw new StreamReadException("Invalid id syntax '" + id + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date setDatastreamState(Context context, String pid, String datastreamID, String dsState, String logMessage) throws ServerException {
        Date date;
        DOWriter w = null;
        try {
            logger.debug("Entered setDatastreamState");
            this.m_authz.enforceSetDatastreamState(context, pid, datastreamID, dsState);
            w = this.m_manager.getWriter(false, context, pid);
            if (!(dsState.equals("A") || dsState.equals("D") || dsState.equals("I"))) {
                throw new InvalidStateException("The datastream state of \"" + dsState + "\" is invalid. The allowed values for state are: " + " A (active), D (deleted), and I (inactive).");
            }
            w.setDatastreamState(datastreamID, dsState);
            Date nowUTC = Server.getCurrentDate(context);
            this.addAuditRecord(context, w, "setDatastreamState", datastreamID, logMessage, nowUTC);
            w.commit(logMessage);
            date = nowUTC;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed setDatastreamState(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamID: ").append(datastreamID);
                logMsg.append(", dsState: ").append(dsState);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "setDatastreamState");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed setDatastreamState(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", datastreamID: ").append(datastreamID);
            logMsg.append(", dsState: ").append(dsState);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "setDatastreamState");
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date setDatastreamVersionable(Context context, String pid, String datastreamID, boolean versionable, String logMessage) throws ServerException {
        Date date;
        DOWriter w = null;
        try {
            logger.debug("Entered setDatastreamVersionable");
            this.m_authz.enforceSetDatastreamVersionable(context, pid, datastreamID, versionable);
            w = this.m_manager.getWriter(false, context, pid);
            w.setDatastreamVersionable(datastreamID, versionable);
            Date nowUTC = Server.getCurrentDate(context);
            this.addAuditRecord(context, w, "setDatastreamVersionable", datastreamID, logMessage, nowUTC);
            w.commit(logMessage);
            date = nowUTC;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed setDatastreamVersionable(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamID: ").append(datastreamID);
                logMsg.append(", versionable: ").append(versionable);
                logMsg.append(", logMessage: ").append(logMessage);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "setDatastreamVersionable");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed setDatastreamVersionable(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", datastreamID: ").append(datastreamID);
            logMsg.append(", versionable: ").append(versionable);
            logMsg.append(", logMessage: ").append(logMessage);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "setDatastreamVersionable");
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compareDatastreamChecksum(Context context, String pid, String datastreamID, Date versionDate) throws ServerException {
        DOReader r = null;
        try {
            logger.debug("Entered compareDatastreamChecksum");
            this.m_authz.enforceCompareDatastreamChecksum(context, pid, datastreamID, versionDate);
            logger.debug("Getting Reader");
            r = this.m_manager.getReader(false, context, pid);
            logger.debug("Getting datastream:" + datastreamID + "date: " + versionDate);
            Datastream ds = r.GetDatastream(datastreamID, versionDate);
            logger.debug("Got Datastream, comparing checksum");
            boolean check = ds.compareChecksum();
            logger.debug("compared checksum = " + check);
            String string = check ? ds.getChecksum() : "Checksum validation error";
            return string;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed compareDatastreamChecksum(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastreamID: ").append(datastreamID);
                logMsg.append(", versionDate: ").append(versionDate);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting compareDatastreamChecksum");
        }
    }

    private byte[] getEmbeddableXML(InputStream in) throws GeneralException {
        return this.getXML(in, false);
    }

    private byte[] getXML(InputStream in, boolean includeXMLDeclaration) throws GeneralException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
            fmt.setIndent(2);
            fmt.setLineWidth(120);
            fmt.setPreserveSpace(false);
            fmt.setOmitXMLDeclaration(!includeXMLDeclaration);
            fmt.setOmitDocumentType(true);
            XMLSerializer ser = new XMLSerializer(out, fmt);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            ser.serialize(doc);
            return out.toByteArray();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            throw new GeneralException("XML was not well-formed. " + message, e);
        }
    }

    private void checkDatastreamID(String id) throws ValidationException {
        this.checkString(id, "Datastream id", 64, ValidationConstants.DATASTREAM_ID_BADCHARS);
    }

    private void checkDatastreamLabel(String label) throws ValidationException {
        this.checkString(label, "Datastream label", 255, null);
    }

    private void checkObjectLabel(String label) throws ValidationException {
        this.checkString(label, "Object label", 255, null);
    }

    private void checkString(String string, String kind, int maxLen, char[] badChars) throws ValidationException {
        if (string != null) {
            if (string.length() > maxLen) {
                throw new ValidationException(kind + " is too long. Maximum " + "length is " + maxLen + " characters.");
            }
            if (badChars != null) {
                for (char c : badChars) {
                    if (string.indexOf(c) == -1) continue;
                    throw new ValidationException(kind + " contains a " + "'" + c + "', but that character is not " + "allowed.");
                }
            }
        }
    }

    @Override
    public RelationshipTuple[] getRelationships(Context context, String subject, String relationship) throws ServerException {
        DOReader r = null;
        String pid = null;
        try {
            logger.debug("Entered getRelationships");
            pid = SubjectProcessor.getSubjectPID(subject);
            this.m_authz.enforceGetRelationships(context, pid, relationship);
            r = this.m_manager.getReader(false, context, pid);
            logger.debug("Getting Relationships:  pid = " + pid + " predicate = " + relationship);
            try {
                SimpleURIReference pred = null;
                if (relationship != null) {
                    pred = new SimpleURIReference(new URI(relationship));
                }
                SimpleURIReference subj = null;
                if (subject != null) {
                    subj = new SimpleURIReference(new URI(SubjectProcessor.getSubjectAsUri(subject)));
                }
                Set<RelationshipTuple> tuples = r.getRelationships((SubjectNode)subj, (PredicateNode)pred, null);
                RelationshipTuple[] relationshipTupleArray = tuples.toArray(new RelationshipTuple[tuples.size()]);
                return relationshipTupleArray;
            }
            catch (URISyntaxException e) {
                throw new GeneralException("Relationship must be a URI", e);
            }
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed getRelationships(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", relationship: ").append(relationship);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting getRelationships");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRelationship(Context context, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        boolean bl;
        DOWriter w = null;
        String pid = null;
        try {
            logger.debug("Entered addRelationship");
            pid = SubjectProcessor.getSubjectPID(subject);
            this.m_authz.enforceAddRelationship(context, pid, relationship, object, isLiteral, datatype);
            w = this.m_manager.getWriter(false, context, pid);
            boolean added = w.addRelationship(SubjectProcessor.getSubjectAsUri(subject), relationship, object, isLiteral, datatype);
            if (added) {
                w.commit(null);
            }
            bl = added;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed addRelationship(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", relationship: ").append(relationship);
                logMsg.append(", object: ").append(object);
                logMsg.append(", isLiteral: ").append(isLiteral);
                logMsg.append(", datatype: ").append(datatype);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "addRelationship");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed addRelationship(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", relationship: ").append(relationship);
            logMsg.append(", object: ").append(object);
            logMsg.append(", isLiteral: ").append(isLiteral);
            logMsg.append(", datatype: ").append(datatype);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "addRelationship");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean purgeRelationship(Context context, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        boolean bl;
        DOWriter w = null;
        String pid = null;
        try {
            logger.debug("Entered purgeRelationship");
            pid = SubjectProcessor.getSubjectPID(subject);
            this.m_authz.enforcePurgeRelationship(context, pid, relationship, object, isLiteral, datatype);
            w = this.m_manager.getWriter(false, context, pid);
            boolean purged = w.purgeRelationship(SubjectProcessor.getSubjectAsUri(subject), relationship, object, isLiteral, datatype);
            if (purged) {
                w.commit(null);
            }
            bl = purged;
        }
        catch (Throwable throwable) {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed purgeRelationship(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", relationship: ").append(relationship);
                logMsg.append(", object: ").append(object);
                logMsg.append(", isLiteral: ").append(isLiteral);
                logMsg.append(", datatype: ").append(datatype);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "purgeRelationship");
            throw throwable;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder logMsg = new StringBuilder("Completed purgeRelationship(");
            logMsg.append("pid: ").append(pid);
            logMsg.append(", relationship: ").append(relationship);
            logMsg.append(", object: ").append(object);
            logMsg.append(", isLiteral: ").append(isLiteral);
            logMsg.append(", datatype: ").append(datatype);
            logMsg.append(")");
            logger.info(logMsg.toString());
        }
        this.finishModification(w, "purgeRelationship");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Validation validate(Context context, String pid, Date asOfDateTime) throws ServerException {
        try {
            logger.debug("Entered validate");
            this.m_authz.enforceValidate(context, pid, asOfDateTime);
            Validation validation = this.ecmValidator.validate(context, pid, asOfDateTime);
            return validation;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed validate(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", asOfDateTime: ").append(asOfDateTime);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            logger.debug("Exiting validate");
        }
    }

    private void addAuditRecord(Context context, DOWriter w, String action, String componentID, String justification, Date nowUTC) throws ServerException {
        AuditRecord audit = new AuditRecord();
        audit.id = w.newAuditRecordID();
        audit.processType = "Fedora API-M";
        audit.action = action;
        audit.componentID = componentID;
        audit.responsibility = context.getSubjectValue(Constants.SUBJECT.LOGIN_ID.uri);
        audit.date = nowUTC;
        audit.justification = justification;
        w.getAuditRecords().add(audit);
    }

    private static void appendAltIDs(StringBuilder logMsg, String[] altIDs) {
        logMsg.append(", altIDs: ");
        if (altIDs == null) {
            logMsg.append("null");
        } else {
            for (String altID : altIDs) {
                logMsg.append("'").append(altID).append("'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeUploadedFiles() {
        long nextPurgeInMillis = this.m_lastPurgeInMillis + this.m_purgeDelayInMillis;
        long currentTimeMillis = System.currentTimeMillis();
        if (nextPurgeInMillis < currentTimeMillis) {
            this.m_lastPurgeInMillis = currentTimeMillis;
            long minStartTime = currentTimeMillis - (long)(this.m_uploadStorageMinutes * 60000);
            ArrayList<String> removeList = new ArrayList<String>();
            Hashtable<String, Long> hashtable = this.m_uploadStartTime;
            synchronized (hashtable) {
                for (Map.Entry<String, Long> entry : this.m_uploadStartTime.entrySet()) {
                    String filename = entry.getKey();
                    long startTime = entry.getValue();
                    if (startTime >= minStartTime) continue;
                    removeList.add(filename);
                }
                for (String filename : removeList) {
                    this.m_uploadStartTime.remove(filename);
                }
            }
            for (int i = 0; i < removeList.size(); ++i) {
                String id = (String)removeList.get(i);
                File file = new File(this.m_tempDir, id);
                if (!file.exists()) continue;
                if (file.delete()) {
                    logger.info("Removed uploaded file '" + id + "' because it expired.");
                    continue;
                }
                logger.warn("Could not remove expired uploaded file '" + id + "'. Check permissions in " + this.m_tempDir.getPath() + " directory.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Date[] modifyDatastreamControlGroup(Context context, String pid, String dsID, String controlGroup, boolean addXMLHeader, boolean reformat, boolean setMIMETypeCharset) throws ServerException {
        Datastream currentDS;
        block26: {
            DOWriter w;
            block25: {
                Object[] objectArray;
                w = null;
                try {
                    logger.debug("Entered modifyDatastreamControlGroup");
                    this.m_authz.enforceReloadPolicies(context);
                    if (!controlGroup.equals("M")) {
                        throw new GeneralException("Invalid target controlGroup " + controlGroup + ".  Only \"M\" is currently supported");
                    }
                    try {
                        w = this.m_manager.getWriter(false, context, pid);
                    }
                    catch (ObjectNotInLowlevelStorageException e) {
                        throw new ObjectNotFoundException("Object " + pid + " does not exist.");
                    }
                    currentDS = w.GetDatastream(dsID, null);
                    if (currentDS == null) {
                        throw new DatastreamNotFoundException("Datastream " + dsID + " not found");
                    }
                    if (!currentDS.DSControlGrp.equals("X")) break block25;
                    Object[] versions = w.getDatastreamVersions(dsID);
                    HashMap<Date, Datastream> copyDS = new HashMap<Date, Datastream>();
                    for (Date date : versions) {
                        Datastream d = w.GetDatastream(dsID, date);
                        copyDS.put(date, d.copy());
                    }
                    w.removeDatastream(dsID, null, null);
                    Arrays.sort(versions);
                    for (int i = versions.length - 1; i >= 0; --i) {
                        void var15_29;
                        DatastreamXMLMetadata existing = (DatastreamXMLMetadata)copyDS.get(versions[i]);
                        DatastreamManagedContent newDS = new DatastreamManagedContent();
                        existing.copy(newDS);
                        newDS.DSControlGrp = controlGroup;
                        newDS.DSLocation = null;
                        newDS.DSLocationType = null;
                        if (setMIMETypeCharset) {
                            newDS.DSMIME = newDS.DSMIME != null && !newDS.DSMIME.equals("") & !newDS.DSMIME.contains("charset=") ? newDS.DSMIME + "; charset=UTF-8" : "text/xml; charset=UTF-8";
                        }
                        if (reformat) {
                            byte[] byArray = this.getXML(existing.getContentStream(), addXMLHeader);
                        } else if (addXMLHeader) {
                            byte[] existingContent;
                            byte[] header;
                            try {
                                header = xmlHeader.getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException(e);
                            }
                            try {
                                existingContent = IOUtils.toByteArray((InputStream)existing.getContentStream());
                            }
                            catch (IOException e) {
                                throw new GeneralException("Error reading existing content from X datastream", e);
                            }
                            byte[] byArray = Arrays.copyOf(header, header.length + existingContent.length);
                            System.arraycopy(existing.xmlContent, 0, byArray, header.length, existingContent.length);
                        } else {
                            try {
                                byte[] byArray = IOUtils.toByteArray((InputStream)existing.getContentStream());
                            }
                            catch (IOException e) {
                                throw new GeneralException("Error reading existing content from X datastream", e);
                            }
                        }
                        MIMETypedStream content = new MIMETypedStream(null, new ByteArrayInputStream((byte[])var15_29), null, ((void)var15_29).length);
                        newDS.putContentStream(content);
                        if (addXMLHeader) {
                            logger.debug("Recalculating checksum.  Type=" + newDS.DSChecksumType + " Existing checksum: " + newDS.DSChecksum != null ? newDS.DSChecksum : "none");
                            newDS.DSChecksum = "none";
                            newDS.DSChecksum = newDS.getChecksum();
                            logger.debug("New checksum: " + newDS.DSChecksum);
                            logger.debug("Testing new checksum, response is {}", (Object)newDS.compareChecksum());
                        }
                        w.addDatastream(newDS, true);
                    }
                    Date nowUTC = Server.getCurrentDate(context);
                    String logMessage = "Modified datastream control group for " + pid + " " + dsID + " from " + currentDS.DSControlGrp + " to " + controlGroup;
                    this.addAuditRecord(context, w, "modifyDatastreamControlGroup", dsID, logMessage, nowUTC);
                    w.commit(logMessage);
                    objectArray = versions;
                }
                catch (Throwable throwable) {
                    if (logger.isInfoEnabled()) {
                        StringBuilder logMsg = new StringBuilder("Completed modifyDatastreamControlGroup(");
                        logMsg.append("pid: ").append(pid);
                        logMsg.append(", datastream: ").append(dsID);
                        logMsg.append(", new control group: ").append(controlGroup);
                        logMsg.append(", add XML header: ").append(addXMLHeader);
                        logMsg.append(", set MIMEType charset: ").append(setMIMETypeCharset);
                        logMsg.append(")");
                        logger.info(logMsg.toString());
                    }
                    this.finishModification(w, "modifyDatastreamControlGroup");
                    throw throwable;
                }
                if (logger.isInfoEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder("Completed modifyDatastreamControlGroup(");
                    stringBuilder.append("pid: ").append(pid);
                    stringBuilder.append(", datastream: ").append(dsID);
                    stringBuilder.append(", new control group: ").append(controlGroup);
                    stringBuilder.append(", add XML header: ").append(addXMLHeader);
                    stringBuilder.append(", set MIMEType charset: ").append(setMIMETypeCharset);
                    stringBuilder.append(")");
                    logger.info(stringBuilder.toString());
                }
                this.finishModification(w, "modifyDatastreamControlGroup");
                return objectArray;
            }
            if (!currentDS.DSControlGrp.equals("M")) break block26;
            Date[] dateArray = new Date[]{};
            if (logger.isInfoEnabled()) {
                StringBuilder logMsg = new StringBuilder("Completed modifyDatastreamControlGroup(");
                logMsg.append("pid: ").append(pid);
                logMsg.append(", datastream: ").append(dsID);
                logMsg.append(", new control group: ").append(controlGroup);
                logMsg.append(", add XML header: ").append(addXMLHeader);
                logMsg.append(", set MIMEType charset: ").append(setMIMETypeCharset);
                logMsg.append(")");
                logger.info(logMsg.toString());
            }
            this.finishModification(w, "modifyDatastreamControlGroup");
            return dateArray;
        }
        throw new GeneralException("Original control group must be X, it is " + currentDS.DSControlGrp);
    }

    private static class SubjectProcessor {
        private static Pattern pidRegex = Pattern.compile("^([A-Za-z0-9]|-|\\.)+:(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+$");

        private SubjectProcessor() {
        }

        static String getSubjectAsUri(String subject) {
            if (!SubjectProcessor.isPid(subject)) {
                return subject;
            }
            logger.warn("Relationships API methods:  the 'pid' (" + subject + ") form of a relationship's subject is deprecated.  Please specify the subject using the " + Constants.FEDORA.uri + " uri scheme.");
            return PID.toURI((String)subject);
        }

        static String getSubjectPID(String subject) throws ServerException {
            if (SubjectProcessor.isPid(subject)) {
                return subject;
            }
            if (subject.startsWith(Constants.FEDORA.uri)) {
                return subject.split("/", 3)[1];
            }
            throw new GeneralException("Subject URI must be in the " + Constants.FEDORA.uri + " scheme.");
        }

        private static boolean isPid(String subject) {
            return pidRegex.matcher(subject).matches();
        }
    }

    public class DatastreamDateComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            long ms2;
            long ms1 = ((Datastream)o1).DSCreateDT.getTime();
            if (ms1 < (ms2 = ((Datastream)o1).DSCreateDT.getTime())) {
                return -1;
            }
            if (ms1 > ms2) {
                return 1;
            }
            return 0;
        }
    }
}

