/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.DefaultManagement;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.proxy.AbstractInvocationHandler;
import org.fcrepo.server.proxy.ModuleConfiguredInvocationHandler;
import org.fcrepo.server.proxy.ProxyFactory;
import org.fcrepo.server.security.Authorization;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementModule
extends Module
implements Management,
ManagementDelegate {
    private static final Logger logger = LoggerFactory.getLogger(ManagementModule.class);
    private Authorization m_fedoraXACMLModule;
    private DOManager m_manager;
    private ExternalContentManager m_contentManager;
    private int m_uploadStorageMinutes;
    private int m_lastId;
    private File m_tempDir;
    private Hashtable<String, Long> m_uploadStartTime;
    private Management mgmt;
    DefaultManagement defaultManagement = null;
    private AbstractInvocationHandler[] invocationHandlers;
    private long m_purgeDelayInMillis;

    public ManagementModule(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void initModule() throws ModuleInitializationException {
        String min = this.getParameter("uploadStorageMinutes");
        if (min == null) {
            min = "5";
        }
        try {
            this.m_uploadStorageMinutes = Integer.parseInt(min);
            if (this.m_uploadStorageMinutes < 1) {
                throw new ModuleInitializationException("uploadStorageMinutes must be 1 or more, if specified.", this.getRole());
            }
        }
        catch (NumberFormatException nfe) {
            throw new ModuleInitializationException("uploadStorageMinutes must be an integer, if specified.", this.getRole());
        }
        try {
            this.m_tempDir = this.getServer().getUploadDir();
            if (!this.m_tempDir.isDirectory()) {
                this.m_tempDir.mkdirs();
                if (!this.m_tempDir.isDirectory()) {
                    throw new ModuleInitializationException("Failed to create temp dir at " + this.m_tempDir.toString(), this.getRole());
                }
            }
            this.m_uploadStartTime = new Hashtable();
            String[] fNames = this.m_tempDir.list();
            Long leftoverStartTime = new Long(System.currentTimeMillis());
            this.m_lastId = 0;
            for (String element : fNames) {
                try {
                    int id = Integer.parseInt(element);
                    if (id > this.m_lastId) {
                        this.m_lastId = id;
                    }
                    this.m_uploadStartTime.put(element, leftoverStartTime);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new ModuleInitializationException("Error while initializing temporary storage area: " + e.getClass().getName() + ": " + e.getMessage(), this.getRole(), e);
        }
        String auto = this.getParameter("autoChecksum");
        logger.debug("Got Parameter: autoChecksum = " + auto);
        if (auto != null && auto.equalsIgnoreCase("true")) {
            Datastream.autoChecksum = true;
            Datastream.defaultChecksumType = this.getParameter("checksumAlgorithm");
        }
        logger.debug("autoChecksum is " + auto);
        logger.debug("defaultChecksumType is " + Datastream.defaultChecksumType);
        String purgeDelayInMillis = this.getParameter("purgeDelayInMillis");
        if (purgeDelayInMillis == null) {
            purgeDelayInMillis = "60000";
        }
        try {
            this.m_purgeDelayInMillis = Integer.parseInt(purgeDelayInMillis);
        }
        catch (NumberFormatException nfe) {
            throw new ModuleInitializationException("purgeDelayInMillis must be an integer, if specified.", this.getRole());
        }
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        this.m_manager = this.getServer().getBean("org.fcrepo.server.storage.DOManager", DOManager.class);
        if (this.m_manager == null) {
            throw new ModuleInitializationException("Can't get a DOManager from Server.getModule", this.getRole());
        }
        this.m_contentManager = this.getServer().getBean("org.fcrepo.server.storage.ExternalContentManager", ExternalContentManager.class);
        if (this.m_contentManager == null) {
            throw new ModuleInitializationException("Can't get an ExternalContentManager from Server.getModule", this.getRole());
        }
        this.m_fedoraXACMLModule = this.getServer().getBean("org.fcrepo.server.security.Authorization", Authorization.class);
        if (this.m_fedoraXACMLModule == null) {
            throw new ModuleInitializationException("Can't get Authorization module (in default management) from Server.getModule", this.getRole());
        }
        DefaultManagement m = new DefaultManagement(this.m_fedoraXACMLModule, this.m_manager, this.m_contentManager, this.m_uploadStorageMinutes, this.m_lastId, this.m_tempDir, this.m_uploadStartTime, this.m_purgeDelayInMillis);
        this.mgmt = this.getProxyChain(m);
        this.defaultManagement = m;
    }

    @Override
    public void shutdownModule() throws ModuleShutdownException {
        if (this.invocationHandlers != null) {
            for (AbstractInvocationHandler h : this.invocationHandlers) {
                h.close();
            }
        }
    }

    @Override
    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String location, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        return this.mgmt.addDatastream(context, pid, dsID, altIDs, dsLabel, versionable, MIMEType, formatURI, location, controlGroup, dsState, checksumType, checksum, logMessage);
    }

    @Override
    public boolean addRelationship(Context context, String pid, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        return this.mgmt.addRelationship(context, pid, relationship, object, isLiteral, datatype);
    }

    @Override
    public String compareDatastreamChecksum(Context context, String pid, String dsID, Date asOfDateTime) throws ServerException {
        return this.mgmt.compareDatastreamChecksum(context, pid, dsID, asOfDateTime);
    }

    @Override
    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        return this.mgmt.export(context, pid, format, exportContext, encoding);
    }

    @Override
    public Datastream getDatastream(Context context, String pid, String datastreamID, Date asOfDateTime) throws ServerException {
        return this.mgmt.getDatastream(context, pid, datastreamID, asOfDateTime);
    }

    @Override
    public Datastream[] getDatastreamHistory(Context context, String pid, String datastreamID) throws ServerException {
        return this.mgmt.getDatastreamHistory(context, pid, datastreamID);
    }

    @Override
    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String dsState) throws ServerException {
        return this.mgmt.getDatastreams(context, pid, asOfDateTime, dsState);
    }

    @Override
    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        return this.mgmt.getNextPID(context, numPIDs, namespace);
    }

    @Override
    public InputStream getObjectXML(Context context, String pid, String encoding) throws ServerException {
        return this.mgmt.getObjectXML(context, pid, encoding);
    }

    @Override
    public RelationshipTuple[] getRelationships(Context context, String pid, String relationship) throws ServerException {
        return this.mgmt.getRelationships(context, pid, relationship);
    }

    @Override
    public InputStream getTempStream(String id) throws ServerException {
        return this.mgmt.getTempStream(id);
    }

    @Override
    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
        return this.mgmt.ingest(context, serialization, logMessage, format, encoding, pid);
    }

    @Override
    public Date modifyDatastreamByReference(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        return this.mgmt.modifyDatastreamByReference(context, pid, datastreamID, altIDs, dsLabel, mimeType, formatURI, dsLocation, checksumType, checksum, logMessage, lastModifiedDate);
    }

    @Override
    public Date modifyDatastreamByValue(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        return this.mgmt.modifyDatastreamByValue(context, pid, datastreamID, altIDs, dsLabel, mimeType, formatURI, dsContent, checksumType, checksum, logMessage, lastModifiedDate);
    }

    @Override
    public Date modifyObject(Context context, String pid, String state, String label, String ownerId, String logMessage, Date lastModifiedDate) throws ServerException {
        return this.mgmt.modifyObject(context, pid, state, label, ownerId, logMessage, lastModifiedDate);
    }

    @Override
    public Date[] purgeDatastream(Context context, String pid, String datastreamID, Date startDT, Date endDT, String logMessage) throws ServerException {
        return this.mgmt.purgeDatastream(context, pid, datastreamID, startDT, endDT, logMessage);
    }

    @Override
    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        return this.mgmt.purgeObject(context, pid, logMessage);
    }

    @Override
    public boolean purgeRelationship(Context context, String pid, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        return this.mgmt.purgeRelationship(context, pid, relationship, object, isLiteral, datatype);
    }

    @Override
    public Validation validate(Context context, String pid, Date asOfDateTime) throws ServerException {
        return this.mgmt.validate(context, pid, asOfDateTime);
    }

    @Override
    public String putTempStream(Context context, InputStream in) throws ServerException {
        return this.mgmt.putTempStream(context, in);
    }

    @Override
    public Date setDatastreamState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        return this.mgmt.setDatastreamState(context, pid, dsID, dsState, logMessage);
    }

    @Override
    public Date setDatastreamVersionable(Context context, String pid, String dsID, boolean versionable, String logMessage) throws ServerException {
        return this.mgmt.setDatastreamVersionable(context, pid, dsID, versionable, logMessage);
    }

    private Management getProxyChain(Management m) throws ModuleInitializationException {
        try {
            this.invocationHandlers = this.getInvocationHandlers();
            return (Management)ProxyFactory.getProxy(m, this.invocationHandlers);
        }
        catch (Exception e) {
            throw new ModuleInitializationException(e.getMessage(), this.getRole());
        }
    }

    private AbstractInvocationHandler[] getInvocationHandlers() throws Exception {
        ArrayList<String> pNames = new ArrayList<String>();
        Iterator<String> it = this.parameterNames();
        while (it.hasNext()) {
            String param = it.next();
            if (!param.startsWith("decorator")) continue;
            pNames.add(param);
        }
        Collections.sort(pNames);
        AbstractInvocationHandler[] invocationHandlers = new AbstractInvocationHandler[pNames.size()];
        for (int i = 0; i < pNames.size(); ++i) {
            invocationHandlers[i] = ManagementModule.getInvocationHandler(this.getParameter((String)pNames.get(i)));
            if (!(invocationHandlers[i] instanceof ModuleConfiguredInvocationHandler)) continue;
            ((ModuleConfiguredInvocationHandler)((Object)invocationHandlers[i])).init(this.getServer());
        }
        return invocationHandlers;
    }

    private static AbstractInvocationHandler getInvocationHandler(String invocationHandler) throws Exception {
        if (invocationHandler == null) {
            return null;
        }
        Class<?> c = Class.forName(invocationHandler);
        return (AbstractInvocationHandler)c.newInstance();
    }

    public Date[] modifyDatastreamControlGroup(Context context, String pid, String dsID, String controlGroup, boolean addXMLHeader, boolean reformat, boolean setMIMETypeCharset) throws ServerException {
        return this.defaultManagement.modifyDatastreamControlGroup(context, pid, dsID, controlGroup, addXMLHeader, reformat, setMIMETypeCharset);
    }
}

