/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.writer.Writer;
import org.apache.abdera.writer.WriterFactory;
import org.dom4j.DocumentException;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.MessagingException;
import org.fcrepo.server.messaging.APIMMessage;
import org.fcrepo.server.messaging.FedoraMethod;
import org.fcrepo.server.messaging.FedoraTypes;
import org.fcrepo.server.messaging.PName;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.TupleArrayTripleIterator;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.RDFFormat;
import org.trippi.TrippiException;

public class AtomAPIMMessage
implements APIMMessage {
    private static final Logger logger = LoggerFactory.getLogger(AtomAPIMMessage.class);
    private static final Abdera abdera = new Abdera();
    private static final Factory abderaFactory = abdera.getFactory();
    private static final Parser abderaParser = abdera.getParser();
    private static final WriterFactory abderaWriterFactory = abdera.getWriterFactory();
    private static final Writer abderaWriter = abderaWriterFactory.getWriter("prettyxml");
    private static final String TYPES_NS = Constants.TYPES.uri;
    private static final String TYPES_PREFIX = "fedora-types";
    private static final String versionPredicate = Constants.VIEW.VERSION.uri;
    private static final String formatPredicate = "http://www.fedora.info/definitions/1/0/types/formatURI";
    private static FedoraTypes fedoraTypes;
    private final String fedoraBaseUrl;
    private final String serverVersion;
    private final String format;
    private final String methodName;
    private final String pid;
    private final Date date;
    private String author;
    private Method method;
    private Object[] args;
    private final Object returnVal;
    private final Entry entry;
    private String stringValue = null;

    public AtomAPIMMessage(FedoraMethod method, String fedoraBaseUrl, String serverVersion, String format) throws MessagingException {
        if (fedoraTypes == null) {
            try {
                fedoraTypes = new FedoraTypes();
            }
            catch (FileNotFoundException e) {
                throw new MessagingException(e.getMessage(), e);
            }
            catch (DocumentException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
        this.method = method.getMethod();
        this.args = method.getParameters();
        this.returnVal = method.getReturnValue();
        this.fedoraBaseUrl = fedoraBaseUrl;
        this.serverVersion = serverVersion;
        this.format = format;
        this.methodName = method.getName();
        this.pid = method.getPID() == null ? "" : method.getPID().toString();
        this.date = method.getDate() == null ? new Date() : method.getDate();
        this.author = method.getContext() != null ? method.getContext().getSubjectValue(Constants.SUBJECT.LOGIN_ID.uri) : "unknown";
        this.entry = abderaFactory.newEntry();
        this.entry.declareNS(Constants.XML_XSD.uri, "xsd");
        this.entry.declareNS(TYPES_NS, TYPES_PREFIX);
        this.setEntryId();
        this.setUpdated();
        this.setAuthor();
        this.setTitle();
        this.addMethodParameters();
        if (this.pid != null || !this.pid.equals("")) {
            this.entry.setSummary(this.pid);
        }
        this.setReturnValue();
        if (serverVersion != null && !serverVersion.equals("")) {
            this.entry.addCategory(versionPredicate, serverVersion, null);
        }
        if (format != null && !format.equals("")) {
            this.entry.addCategory(formatPredicate, format, null);
        }
    }

    public AtomAPIMMessage(String messageText) {
        Document entryDoc = abderaParser.parse((Reader)new StringReader(messageText));
        this.entry = (Entry)entryDoc.getRoot();
        this.methodName = this.entry.getTitle();
        this.date = this.entry.getUpdated();
        this.author = this.entry.getAuthor().getName();
        this.fedoraBaseUrl = this.entry.getAuthor().getUri().toString();
        this.pid = this.entry.getSummary();
        this.returnVal = this.entry.getContent();
        this.serverVersion = this.getCategoryTerm(versionPredicate);
        this.format = this.getCategoryTerm(formatPredicate);
    }

    private void setEntryId() {
        this.entry.setId("urn:uuid:" + UUID.randomUUID().toString());
    }

    private void setAuthor() {
        this.entry.addAuthor(this.author, null, this.fedoraBaseUrl);
    }

    private void setTitle() {
        this.entry.setTitle(this.methodName);
    }

    private void setUpdated() {
        this.entry.setUpdated(this.date);
    }

    private void addMethodParameters() {
        Annotation[][] annotations = this.method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            String parameter = AtomAPIMMessage.getParameterName(this.method, i);
            String datatype = fedoraTypes.getDatatype(this.methodName, parameter);
            if (datatype != null) {
                String scheme = "fedora-types:" + parameter;
                this.entry.addCategory(scheme, this.objectToString(this.args[i], datatype), datatype);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Silently dropping parameter not defined in the WSDL: " + parameter);
        }
    }

    private void setReturnValue() {
        String m = this.methodName + "Response";
        String parameter = fedoraTypes.getResponseParameter(m);
        String datatype = fedoraTypes.getDatatype(m, parameter);
        String term = this.objectToString(this.returnVal, datatype);
        this.entry.setContent(term);
    }

    private String objectToString(Object obj, String xsdType) {
        String term;
        if (obj == null) {
            return "null";
        }
        String javaType = obj.getClass().getCanonicalName();
        if (javaType != null && javaType.equals("java.util.Date")) {
            term = DateUtility.convertDateToXSDString((Date)((Date)obj));
        } else if (xsdType.equals("fedora-types:ArrayOfString")) {
            term = AtomAPIMMessage.array2string(obj);
        } else if (xsdType.equals("xsd:boolean")) {
            term = obj.toString();
        } else if (xsdType.equals("xsd:nonNegativeInteger")) {
            term = obj.toString();
        } else if (xsdType.equals("fedora-types:RelationshipTuple")) {
            RelationshipTuple[] tuples = (RelationshipTuple[])obj;
            TupleArrayTripleIterator iter = new TupleArrayTripleIterator(new ArrayList<RelationshipTuple>(Arrays.asList(tuples)));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                iter.toStream(os, RDFFormat.NOTATION_3, false);
            }
            catch (TrippiException e) {
                e.printStackTrace();
            }
            term = new String(os.toByteArray());
        } else if (javaType != null && javaType.equals("java.lang.String")) {
            term = (String)obj;
            term = term.replaceAll("\"", "'");
        } else {
            term = "[OMITTED]";
        }
        return term;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringWriter sWriter = new StringWriter();
            try {
                this.entry.writeTo(abderaWriter, (java.io.Writer)sWriter);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            this.stringValue = ((Object)sWriter).toString();
        }
        return this.stringValue;
    }

    @Override
    public String getBaseUrl() {
        return this.fedoraBaseUrl;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getPID() {
        return this.pid;
    }

    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    private static <A extends Annotation> A getParameterAnnotation(Method m, int paramIndex, Class<A> annot) {
        for (Annotation a : m.getParameterAnnotations()[paramIndex]) {
            if (!annot.isInstance(a)) continue;
            return (A)((Annotation)annot.cast(a));
        }
        return null;
    }

    private static String getParameterName(Method m, int paramIndex) {
        PName pName = AtomAPIMMessage.getParameterAnnotation(m, paramIndex, PName.class);
        if (pName != null) {
            return pName.value();
        }
        return "";
    }

    private static String array2string(Object array) {
        String nullstring = "null";
        String delimiter = ", ";
        if (array == null) {
            return nullstring;
        }
        Object obj = null;
        int length = Array.getLength(array);
        int lastItem = length - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            obj = Array.get(array, i);
            if (obj != null) {
                sb.append(obj);
            } else {
                sb.append(nullstring);
            }
            if (i >= lastItem) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private String getCategoryTerm(String scheme) {
        List categories = this.entry.getCategories(scheme);
        if (categories.isEmpty()) {
            return null;
        }
        return ((Category)categories.get(0)).getTerm();
    }
}

