/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.fcrepo.common.Constants;
import org.fcrepo.utilities.XMLDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraTypes
extends XMLDocument {
    private static final Logger logger = LoggerFactory.getLogger(FedoraTypes.class);
    private final Map<String, String> method2datatype = new HashMap<String, String>();
    private final Map<String, String> response2parameter = new HashMap<String, String>();
    private final Map<String, String> ns2prefix = new HashMap<String, String>();

    public FedoraTypes() throws DocumentException, FileNotFoundException {
        this(FedoraTypes.getXsd());
    }

    public FedoraTypes(InputStream in) throws DocumentException {
        super(in);
        this.ns2prefix.put("xsd", Constants.XML_XSD.uri);
    }

    public String getDatatype(String method, String param) {
        String key = method + "." + param;
        if (!this.method2datatype.containsKey(key)) {
            String query = String.format("/xsd:schema/xsd:element[@name='%s']/xsd:complexType/xsd:sequence/xsd:element[@name='%s']/@type", method, param);
            XPath xpath = DocumentHelper.createXPath((String)query);
            xpath.setNamespaceURIs(this.ns2prefix);
            String datatype = xpath.valueOf((Object)this.getDocument());
            if (datatype.equals("")) {
                datatype = null;
            }
            this.method2datatype.put(key, datatype);
        }
        return this.method2datatype.get(key);
    }

    public String getResponseParameter(String response) {
        if (!this.response2parameter.containsKey(response)) {
            String query = String.format("/xsd:schema/xsd:element[@name='%s']/xsd:complexType/xsd:sequence/xsd:element/@name", response);
            XPath xpath = DocumentHelper.createXPath((String)query);
            xpath.setNamespaceURIs(this.ns2prefix);
            String param = xpath.valueOf((Object)this.getDocument());
            if (param.equals("")) {
                param = null;
            }
            this.response2parameter.put(response, param);
        }
        return this.response2parameter.get(response);
    }

    private static InputStream getXsd() throws FileNotFoundException {
        FileInputStream xsd;
        String fedoraHome = Constants.FEDORA_HOME;
        try {
            xsd = new FileInputStream(new File(new File(fedoraHome), "server/xsd/fedora-types.xsd"));
        }
        catch (FileNotFoundException e) {
            logger.warn(e.getMessage());
            xsd = new FileInputStream("server/src/main/resources/xsd/fedora-types.xsd");
        }
        return xsd;
    }
}

