/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.fcrepo.server.Server;
import org.fcrepo.server.messaging.FedoraMethod;
import org.fcrepo.server.messaging.Messaging;
import org.fcrepo.server.messaging.MessagingModule;
import org.fcrepo.server.proxy.AbstractInvocationHandler;
import org.fcrepo.server.proxy.ModuleConfiguredInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationInvocationHandler
extends AbstractInvocationHandler
implements ModuleConfiguredInvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessagingModule.class);
    private Messaging messaging;
    private final ExecutorService exec = Executors.newCachedThreadPool();

    public NotificationInvocationHandler() {
    }

    public NotificationInvocationHandler(Messaging messaging) {
        if (messaging != null) {
            this.messaging = messaging;
        }
    }

    @Override
    public void init(Server server) {
        this.messaging = (MessagingModule)server.getModule("org.fcrepo.server.messaging.Messaging");
        if (this.messaging == null) {
            logger.warn("Unable to load MessagingModule.");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        try {
            returnValue = method.invoke(this.target, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        if (this.messaging != null && !this.exec.isShutdown()) {
            this.exec.submit(new Notifier(method, args, returnValue));
        }
        return returnValue;
    }

    @Override
    public void close() {
        this.exec.shutdown();
    }

    class Notifier
    implements Callable<Void> {
        private final Method method;
        private final Object[] args;
        private final Object returnValue;

        public Notifier(Method method, Object[] args, Object returnValue) {
            this.method = method;
            this.args = args;
            this.returnValue = returnValue;
        }

        @Override
        public Void call() throws Exception {
            FedoraMethod fm = new FedoraMethod(this.method, this.args, this.returnValue);
            NotificationInvocationHandler.this.messaging.send(fm);
            return null;
        }
    }
}

