/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.oai;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.oai.BadResumptionTokenException;
import org.fcrepo.oai.CannotDisseminateFormatException;
import org.fcrepo.oai.DateGranularitySupport;
import org.fcrepo.oai.DeletedRecordSupport;
import org.fcrepo.oai.IDDoesNotExistException;
import org.fcrepo.oai.NoMetadataFormatsException;
import org.fcrepo.oai.NoRecordsMatchException;
import org.fcrepo.oai.NoSetHierarchyException;
import org.fcrepo.oai.OAIProvider;
import org.fcrepo.oai.Record;
import org.fcrepo.oai.RepositoryException;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.oai.FedoraOAIProvider;
import org.fcrepo.server.search.FieldSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraOAIProviderModule
extends Module
implements OAIProvider {
    private static final Logger logger = LoggerFactory.getLogger(FedoraOAIProviderModule.class);
    private FedoraOAIProvider m_wrappedOAIProvider;

    public FedoraOAIProviderModule(Map params, Server server, String role) throws ModuleInitializationException {
        super(params, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        String maxHeadersString;
        FieldSearch fieldSearch;
        String repositoryName = this.getParameter("repositoryName");
        if (repositoryName == null) {
            throw new ModuleInitializationException("repositoryName must be specified.", this.getRole());
        }
        String repositoryDomainName = this.getParameter("repositoryDomainName");
        if (repositoryDomainName == null) {
            throw new ModuleInitializationException("repositoryDomainName must be specified.", this.getRole());
        }
        String host = this.getServer().getParameter("fedoraServerHost");
        if (host == null) {
            throw new ModuleInitializationException("fedoraServerHost must be specified as primary server config element.", this.getRole());
        }
        String context = this.getServer().getParameter("fedoraAppServerContext");
        if (context == null) {
            throw new ModuleInitializationException("fedoraAppServerContext must be specified as primary server config element.", this.getRole());
        }
        String port = this.getServer().getParameter("fedoraServerPort");
        if (port == null) {
            throw new ModuleInitializationException("fedoraServerPort must be specified as primary server config element.", this.getRole());
        }
        Module mgr = this.getServer().getModule("org.fcrepo.server.storage.DOManager");
        if (mgr == null) {
            throw new ModuleInitializationException("DOManager is required (for pidNamespace param), but isn't loaded.", this.getRole());
        }
        String pidNamespace = mgr.getParameter("pidNamespace");
        if (pidNamespace == null) {
            throw new ModuleInitializationException("DOManager did not specify a pidNamespace, but this module requires that it does.", this.getRole());
        }
        String aes = this.getParameter("adminEmails");
        if (aes == null) {
            throw new ModuleInitializationException("adminEmails must be specified.", this.getRole());
        }
        HashSet<String> adminEmails = new HashSet<String>();
        if (aes.indexOf(" ") == -1) {
            adminEmails.add(aes);
        } else {
            String[] emails;
            for (String element : emails = aes.split(" ")) {
                adminEmails.add(element);
            }
        }
        HashSet<String> friends = new HashSet<String>();
        if (this.getParameter("friends") != null) {
            String f = this.getParameter("friends");
            if (f.indexOf(" ") == -1) {
                friends.add(f);
            } else {
                String[] fs;
                for (String element : fs = f.split(" ")) {
                    friends.add(element);
                }
            }
        }
        if ((fieldSearch = (FieldSearch)((Object)this.getServer().getModule("org.fcrepo.server.search.FieldSearch"))) == null) {
            throw new ModuleInitializationException("FieldSearch module was not loaded, but is required.", this.getRole());
        }
        Module fsModule = this.getServer().getModule("org.fcrepo.server.search.FieldSearch");
        if (fsModule.getParameter("maxResults") == null) {
            throw new ModuleInitializationException("maxResults parameter must be specified in FieldSearch module's configuration.", this.getRole());
        }
        int maxResults = 0;
        try {
            maxResults = Integer.parseInt(fsModule.getParameter("maxResults"));
            if (maxResults < 1) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ModuleInitializationException("maxResults specified in FieldSearch module's configuration must be a positive integer.", this.getRole());
        }
        long maxSets = 100L;
        long maxRecords = maxResults;
        long maxHeaders = maxResults;
        String maxRecordsString = this.getParameter("maxRecords");
        if (maxRecordsString != null) {
            try {
                maxRecords = Long.parseLong(maxRecordsString);
                if (maxRecords > (long)maxResults) {
                    logger.warn("maxRecords was over the limit given by the FieldSearch module, using highest possible value: " + maxResults);
                    maxRecords = maxResults;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleInitializationException("maxRecords value is invalid.", this.getRole());
            }
        }
        if ((maxHeadersString = this.getParameter("maxHeaders")) != null) {
            try {
                maxHeaders = Long.parseLong(maxHeadersString);
                if (maxHeaders > (long)maxResults) {
                    logger.warn("maxHeaders was over the limit given by the FieldSearch module, using highest possible value: " + maxResults);
                    maxHeaders = maxResults;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleInitializationException("maxHeaders value is invalid.", this.getRole());
            }
        }
        this.m_wrappedOAIProvider = new FedoraOAIProvider(repositoryName, repositoryDomainName, host, "/" + context + "/oai", adminEmails, friends, pidNamespace, maxSets, maxRecords, maxHeaders, fieldSearch);
    }

    @Override
    public String getRepositoryName() {
        return this.m_wrappedOAIProvider.getRepositoryName();
    }

    @Override
    public String getBaseURL(String protocol, String port) {
        return this.m_wrappedOAIProvider.getBaseURL(protocol, port);
    }

    @Override
    public String getProtocolVersion() {
        return this.m_wrappedOAIProvider.getProtocolVersion();
    }

    @Override
    public Date getEarliestDatestamp() {
        return this.m_wrappedOAIProvider.getEarliestDatestamp();
    }

    @Override
    public DeletedRecordSupport getDeletedRecordSupport() {
        return this.m_wrappedOAIProvider.getDeletedRecordSupport();
    }

    @Override
    public DateGranularitySupport getDateGranularitySupport() {
        return this.m_wrappedOAIProvider.getDateGranularitySupport();
    }

    @Override
    public Set getAdminEmails() {
        return this.m_wrappedOAIProvider.getAdminEmails();
    }

    @Override
    public Set getSupportedCompressionEncodings() {
        return this.m_wrappedOAIProvider.getSupportedCompressionEncodings();
    }

    @Override
    public Set getDescriptions() {
        return this.m_wrappedOAIProvider.getDescriptions();
    }

    @Override
    public Record getRecord(String identifier, String metadataPrefix) throws CannotDisseminateFormatException, IDDoesNotExistException, RepositoryException {
        return this.m_wrappedOAIProvider.getRecord(identifier, metadataPrefix);
    }

    @Override
    public List getRecords(Date from, Date until, String metadataPrefix, String set) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, RepositoryException {
        return this.m_wrappedOAIProvider.getRecords(from, until, metadataPrefix, set);
    }

    @Override
    public List getRecords(String resumptionToken) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, BadResumptionTokenException, RepositoryException {
        return this.m_wrappedOAIProvider.getRecords(resumptionToken);
    }

    @Override
    public List getHeaders(Date from, Date until, String metadataPrefix, String set) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, RepositoryException {
        return this.m_wrappedOAIProvider.getHeaders(from, until, metadataPrefix, set);
    }

    @Override
    public List getHeaders(String resumptionToken) throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, BadResumptionTokenException, RepositoryException {
        return this.m_wrappedOAIProvider.getHeaders(resumptionToken);
    }

    @Override
    public List getSets() throws NoSetHierarchyException, RepositoryException {
        return this.m_wrappedOAIProvider.getSets();
    }

    @Override
    public List getSets(String resumptionToken) throws BadResumptionTokenException, NoSetHierarchyException, RepositoryException {
        return this.m_wrappedOAIProvider.getSets(resumptionToken);
    }

    @Override
    public Set getMetadataFormats(String id) throws NoMetadataFormatsException, IDDoesNotExistException, RepositoryException {
        return this.m_wrappedOAIProvider.getMetadataFormats(id);
    }

    @Override
    public long getMaxSets() throws RepositoryException {
        return this.m_wrappedOAIProvider.getMaxSets();
    }

    @Override
    public long getMaxRecords() throws RepositoryException {
        return this.m_wrappedOAIProvider.getMaxRecords();
    }

    @Override
    public long getMaxHeaders() throws RepositoryException {
        return this.m_wrappedOAIProvider.getMaxHeaders();
    }
}

