/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.common.rdf.SimpleLiteral;
import org.fcrepo.common.rdf.SimpleTriple;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.resourceIndex.TripleGeneratorBase;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.server.utilities.DCFields;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;

public class FedoraObjectTripleGenerator_3_0
extends TripleGeneratorBase
implements Constants,
TripleGenerator {
    @Override
    public Set<Triple> getTriplesForObject(DOReader reader) throws ResourceIndexException {
        HashSet<Triple> set = new HashSet<Triple>();
        this.addCommonTriples(reader, set);
        return set;
    }

    private URIReference addCommonTriples(DOReader reader, Set<Triple> set) throws ResourceIndexException {
        try {
            Datastream[] datastreams;
            SimpleURIReference objURI = new SimpleURIReference(new URI(PID.toURI((String)reader.GetObjectPID())));
            this.addCoreObjectTriples(reader, (URIReference)objURI, set);
            for (Datastream ds : datastreams = reader.GetDatastreams(null, null)) {
                this.addCoreDatastreamTriples(ds, (URIReference)objURI, set);
                if (!ds.DatastreamID.equals("DC")) continue;
                this.addDCTriples(ds, (URIReference)objURI, set);
            }
            this.addRelationshipTriples(reader, (URIReference)objURI, set);
            return objURI;
        }
        catch (ResourceIndexException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceIndexException("Error generating triples", e);
        }
    }

    private void addCoreObjectTriples(DOReader r, URIReference objURI, Set<Triple> set) throws Exception {
        this.add((SubjectNode)objURI, FedoraObjectTripleGenerator_3_0.MODEL.CREATED_DATE, r.getCreateDate(), set);
        this.add((SubjectNode)objURI, FedoraObjectTripleGenerator_3_0.MODEL.LABEL, r.GetObjectLabel(), set);
        this.add((SubjectNode)objURI, FedoraObjectTripleGenerator_3_0.MODEL.OWNER, r.getOwnerId(), set);
        this.add((SubjectNode)objURI, FedoraObjectTripleGenerator_3_0.MODEL.STATE, (ObjectNode)this.getStateResource(r.GetObjectState()), set);
        this.add((SubjectNode)objURI, FedoraObjectTripleGenerator_3_0.VIEW.LAST_MODIFIED_DATE, r.getLastModDate(), set);
    }

    private void addCoreDatastreamTriples(Datastream ds, URIReference objURI, Set<Triple> set) throws Exception {
        SimpleURIReference dsURI = new SimpleURIReference(new URI(objURI.getURI().toString() + "/" + ds.DatastreamID));
        this.add((SubjectNode)objURI, FedoraObjectTripleGenerator_3_0.VIEW.DISSEMINATES, (ObjectNode)dsURI, set);
        SimpleURIReference dsDissType = new SimpleURIReference(new URI(FedoraObjectTripleGenerator_3_0.FEDORA.uri + "*/" + ds.DatastreamID));
        this.add((SubjectNode)dsURI, FedoraObjectTripleGenerator_3_0.VIEW.DISSEMINATION_TYPE, (ObjectNode)dsDissType, set);
        boolean isVolatile = ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R");
        this.add((SubjectNode)dsURI, FedoraObjectTripleGenerator_3_0.VIEW.IS_VOLATILE, isVolatile, set);
        this.add((SubjectNode)dsURI, FedoraObjectTripleGenerator_3_0.VIEW.LAST_MODIFIED_DATE, ds.DSCreateDT, set);
        this.add((SubjectNode)dsURI, FedoraObjectTripleGenerator_3_0.VIEW.MIME_TYPE, ds.DSMIME, set);
        this.add((SubjectNode)dsURI, FedoraObjectTripleGenerator_3_0.MODEL.STATE, (ObjectNode)this.getStateResource(ds.DSState), set);
    }

    private void addDCTriples(Datastream ds, URIReference objURI, Set<Triple> set) throws Exception {
        DCFields dc = new DCFields(ds.getContentStream());
        Map<RDFName, List<DCField>> map = dc.getMap();
        for (RDFName predicate : map.keySet()) {
            for (DCField dcField : map.get(predicate)) {
                String lang = dcField.getLang();
                if (lang == null) {
                    this.add((SubjectNode)objURI, predicate, dcField.getValue(), set);
                    continue;
                }
                this.add((SubjectNode)objURI, predicate, dcField.getValue(), lang, set);
            }
        }
    }

    private void addRelationshipTriples(DOReader reader, URIReference objURI, Set<Triple> set) throws Exception {
        for (RelationshipTuple tuple : reader.getRelationships()) {
            Object oNode = tuple.isLiteral ? (tuple.datatype != null ? new SimpleLiteral(tuple.object, tuple.datatype) : (tuple.language != null ? new SimpleLiteral(tuple.object, tuple.language) : new SimpleLiteral(tuple.object))) : new SimpleURIReference(new URI(tuple.object));
            set.add((Triple)new SimpleTriple((SubjectNode)new SimpleURIReference(new URI(tuple.subject)), (PredicateNode)new SimpleURIReference(new URI(tuple.predicate)), (ObjectNode)oNode));
        }
    }
}

