/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.storage.DOReader;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.trippi.FlushErrorHandler;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TripleUpdate;
import org.trippi.TriplestoreConnector;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class ResourceIndexImpl
implements ResourceIndex {
    private final TriplestoreConnector _connector;
    private final TriplestoreWriter _writer;
    private final TripleGenerator _generator;
    private final int _indexLevel;
    private final boolean _syncUpdates;

    public ResourceIndexImpl(TriplestoreConnector connector, TripleGenerator generator, int indexLevel, boolean syncUpdates) {
        this._connector = connector;
        this._writer = this._connector.getWriter();
        this._generator = generator;
        this._indexLevel = indexLevel;
        this._syncUpdates = syncUpdates;
    }

    @Override
    public int getIndexLevel() {
        return this._indexLevel;
    }

    @Override
    public void addObject(DOReader reader) throws ResourceIndexException {
        if (this._indexLevel > 0) {
            this.updateTriples(this._generator.getTriplesForObject(reader), false);
        }
    }

    @Override
    public void modifyObject(DOReader oldReader, DOReader newReader) throws ResourceIndexException {
        if (this._indexLevel > 0) {
            this.updateTripleDiffs(this._generator.getTriplesForObject(oldReader), this._generator.getTriplesForObject(newReader));
        }
    }

    @Override
    public void deleteObject(DOReader oldReader) throws ResourceIndexException {
        if (this._indexLevel > 0) {
            this.updateTriples(this._generator.getTriplesForObject(oldReader), true);
        }
    }

    @Override
    public void export(OutputStream out, RDFFormat format) throws ResourceIndexException {
        try {
            TripleIterator it = this._writer.findTriples(null, null, null, 0);
            it.setAliasMap(this._writer.getAliasMap());
            it.toStream(out, format);
        }
        catch (TrippiException e) {
            throw new ResourceIndexException("Unable to export RI", e);
        }
    }

    private void updateTriples(Set<Triple> set, boolean delete) throws ResourceIndexException {
        try {
            if (delete) {
                this._writer.delete(this.getTripleIterator(set), this._syncUpdates);
            } else {
                this._writer.add(this.getTripleIterator(set), this._syncUpdates);
            }
        }
        catch (Exception e) {
            throw new ResourceIndexException("Error updating triples", e);
        }
    }

    private void updateTripleDiffs(Set<Triple> existing, Set<Triple> desired) throws ResourceIndexException {
        HashSet<Triple> obsoleteTriples = new HashSet<Triple>(existing);
        obsoleteTriples.removeAll(desired);
        this.updateTriples(obsoleteTriples, true);
        HashSet<Triple> newTriples = new HashSet<Triple>(desired);
        newTriples.removeAll(existing);
        this.updateTriples(newTriples, false);
    }

    private TripleIterator getTripleIterator(final Set<Triple> set) {
        return new TripleIterator(){
            private final Iterator<Triple> _iter;
            {
                this._iter = set.iterator();
            }

            public boolean hasNext() {
                return this._iter.hasNext();
            }

            public Triple next() {
                return ResourceIndexImpl.this.getLocalizedTriple(this._iter.next());
            }

            public void close() {
            }
        };
    }

    private Triple getLocalizedTriple(Triple triple) {
        try {
            return this._connector.getElementFactory().createTriple((SubjectNode)this.getLocalizedResource((Node)triple.getSubject()), (PredicateNode)this.getLocalizedResource((Node)triple.getPredicate()), this.getLocalizedObject((Node)triple.getObject()));
        }
        catch (GraphElementFactoryException e) {
            throw new RuntimeException("Error localizing triple", e);
        }
    }

    private URIReference getLocalizedResource(Node n) throws GraphElementFactoryException {
        if (n instanceof URIReference) {
            URIReference u = (URIReference)n;
            return this._connector.getElementFactory().createResource(u.getURI());
        }
        throw new RuntimeException("Error localizing triple; " + n.getClass().getName() + " is not a URIReference");
    }

    private ObjectNode getLocalizedObject(Node n) throws GraphElementFactoryException {
        if (n instanceof URIReference) {
            return this.getLocalizedResource(n);
        }
        if (n instanceof Literal) {
            Literal l = (Literal)n;
            GraphElementFactory elementFactory = this._connector.getElementFactory();
            if (l.getDatatypeURI() != null) {
                return elementFactory.createLiteral(l.getLexicalForm(), l.getDatatypeURI());
            }
            if (l.getLanguage() != null) {
                return elementFactory.createLiteral(l.getLexicalForm(), l.getLanguage());
            }
            return elementFactory.createLiteral(l.getLexicalForm());
        }
        throw new RuntimeException("Error localizing triple; " + n.getClass().getName() + " is not a URIReference " + "or a Literal");
    }

    public void setAliasMap(Map<String, String> aliasToPrefix) throws TrippiException {
        this._writer.setAliasMap(aliasToPrefix);
    }

    public Map<String, String> getAliasMap() throws TrippiException {
        return this._writer.getAliasMap();
    }

    public TupleIterator findTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this._writer.findTuples(queryLang, tupleQuery, limit, distinct);
    }

    public int countTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this._writer.countTuples(queryLang, tupleQuery, limit, distinct);
    }

    public TripleIterator findTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this._writer.findTriples(queryLang, tripleQuery, limit, distinct);
    }

    public int countTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this._writer.countTriples(queryLang, tripleQuery, limit, distinct);
    }

    public TripleIterator findTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this._writer.findTriples(subject, predicate, object, limit);
    }

    public int countTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this._writer.countTriples(subject, predicate, object, limit);
    }

    public TripleIterator findTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this._writer.findTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct);
    }

    public int countTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this._writer.countTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct);
    }

    public String[] listTupleLanguages() {
        return this._writer.listTupleLanguages();
    }

    public String[] listTripleLanguages() {
        return this._writer.listTripleLanguages();
    }

    public void close() throws TrippiException {
        this._connector.close();
    }

    public void add(List<Triple> triples, boolean flush) throws IOException, TrippiException {
        this._writer.add(triples, flush);
    }

    public void add(TripleIterator triples, boolean flush) throws IOException, TrippiException {
        this._writer.add(triples, flush);
    }

    public void add(Triple triple, boolean flush) throws IOException, TrippiException {
        this._writer.add(triple, flush);
    }

    public void delete(List<Triple> triples, boolean flush) throws IOException, TrippiException {
        this._writer.delete(triples, flush);
    }

    public void delete(TripleIterator triples, boolean flush) throws IOException, TrippiException {
        this._writer.delete(triples, flush);
    }

    public void delete(Triple triple, boolean flush) throws IOException, TrippiException {
        this._writer.delete(triple, flush);
    }

    public void flushBuffer() throws IOException, TrippiException {
        this._writer.flushBuffer();
    }

    public void setFlushErrorHandler(FlushErrorHandler h) {
        this._writer.setFlushErrorHandler(h);
    }

    public int getBufferSize() {
        return this._writer.getBufferSize();
    }

    public List<TripleUpdate> findBufferedUpdates(SubjectNode subject, PredicateNode predicate, ObjectNode object, int updateType) {
        return this._writer.findBufferedUpdates(subject, predicate, object, updateType);
    }
}

