/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.fcrepo.server.Module;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.resourceIndex.ResourceIndexImpl;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.utilities.rebuild.Rebuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.trippi.TriplestoreConnector;
import org.trippi.impl.mulgara.MulgaraConnector;

public class ResourceIndexRebuilder
implements ApplicationContextAware,
Rebuilder {
    private static Logger logger = LoggerFactory.getLogger((String)ResourceIndexRebuilder.class.getName());
    private static final String moduleName = "org.fcrepo.server.resourceIndex.ResourceIndex";
    private static final String configName = "org.fcrepo.server.resourceIndex.ResourceIndexConfiguration";
    private ModuleConfiguration m_riConfig;
    private GenericApplicationContext m_context;
    private ResourceIndex m_ri;
    private TriplestoreConnector m_conn;
    private TripleGenerator m_generator;

    @Resource(name="org.trippi.TriplestoreConnector")
    public void setTriplestoreConnector(TriplestoreConnector conn) {
        this.m_conn = conn;
    }

    @Resource(name="org.fcrepo.server.resourceIndex.ResourceIndexConfiguration")
    public void setModuleConfiguration(ModuleConfiguration riConfig) {
        this.m_riConfig = riConfig;
    }

    @Override
    public String getAction() {
        return "Rebuild the Resource Index.";
    }

    @Override
    public boolean shouldStopServer() {
        return true;
    }

    @Override
    public void setServerConfiguration(ServerConfiguration serverConfig) {
    }

    @Override
    public void setServerDir(File serverBaseDir) {
    }

    @Override
    public void init() {
    }

    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> m = new HashMap<String, String>();
        return m;
    }

    @Resource(name="org.fcrepo.server.resourceIndex.TripleGenerator")
    public void setTripleGenerator(TripleGenerator generator) {
        this.m_generator = generator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start(Map<String, String> options) throws ResourceIndexException {
        String levelValue;
        if (this.m_riConfig == null) {
            Module riModule = (Module)this.m_context.getBean(moduleName, Module.class);
            if (riModule == null) {
                logger.error("Cannot load ResourceIndex module definition from Spring config or Fedora config");
                throw new ResourceIndexException("Cannot locate ResourceIndex module definition in Spring config or Fedora config");
            }
            logger.warn("ModuleConfiguration bean unavailable; getting Module bean");
            levelValue = riModule.getParameter("level");
        } else {
            levelValue = this.m_riConfig.getParameter("level", Parameter.class).getValue();
        }
        int riLevel = Integer.parseInt(levelValue);
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (Parameter p : this.m_riConfig.getParameters(Parameter.class)) {
            String pName = p.getName();
            String[] parts = pName.split(":");
            if (parts.length != 2 || !parts[0].equals("alias")) continue;
            aliasMap.put(parts[1], p.getValue(p.getIsFilePath()));
        }
        System.out.println("Initializing triplestore interface...");
        try {
            if (this.m_conn instanceof MulgaraConnector) {
                String path = (String)this.m_conn.getConfiguration().get("path");
                this.dropIndex(path);
            }
            this.m_ri = new ResourceIndexImpl(this.m_conn, this.m_generator, riLevel, false);
            this.m_ri.setAliasMap(aliasMap);
            return;
        }
        catch (Exception e) {
            logger.error("Failed to initialize new Resource Index", (Throwable)e);
            e.printStackTrace(System.err);
            throw new ResourceIndexException("Failed to initialize new Resource Index", e);
        }
    }

    private void dropIndex(String tsPath) {
        if (tsPath == null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.println("NOTE: You must now manually re-initialize (clear) ");
            System.out.println("      the existing triplestore.  The RI rebuilder");
            System.out.println("      cannot yet automatically perform this step ");
            System.out.println("      for this type of triplestore.  Press enter");
            System.out.println("      when finished.");
            try {
                reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("OK, continuing...");
        } else {
            System.out.println("Clearing directory " + tsPath + "...");
            this.deleteDirectory(tsPath);
            File cleanDir = new File(tsPath);
            cleanDir.mkdir();
        }
    }

    @Override
    public void addObject(DigitalObject obj) throws ResourceIndexException {
        this.m_ri.addObject(new SimpleDOReader(null, null, null, null, null, obj));
    }

    @Override
    public void finish() throws Exception {
        if (this.m_ri != null) {
            this.m_ri.flushBuffer();
            this.m_ri.close();
        }
    }

    private boolean deleteDirectory(String directory) {
        File file;
        boolean result = false;
        if (directory != null && (file = new File(directory)).exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            result = true;
            for (File f : files) {
                if (f.isFile()) {
                    result = result && f.delete();
                    continue;
                }
                if (!f.isDirectory()) continue;
                result = result && this.deleteDirectory(f.getAbsolutePath());
            }
            file.delete();
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.m_context = (GenericApplicationContext)context;
    }
}

