/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.util.Date;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.common.rdf.SimpleLiteral;
import org.fcrepo.common.rdf.SimpleTriple;
import org.fcrepo.server.errors.ResourceIndexException;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;

public abstract class TripleGeneratorBase {
    protected RDFName getStateResource(String state) throws ResourceIndexException {
        if (state == null) {
            throw new ResourceIndexException("State cannot be null");
        }
        if (state.equals("A")) {
            return Constants.MODEL.ACTIVE;
        }
        if (state.equals("D")) {
            return Constants.MODEL.DELETED;
        }
        if (state.equals("I")) {
            return Constants.MODEL.INACTIVE;
        }
        throw new ResourceIndexException("Unrecognized state: " + state);
    }

    protected void add(SubjectNode subject, RDFName predicate, ObjectNode object, Set<Triple> set) throws ResourceIndexException {
        set.add((Triple)new SimpleTriple(subject, (PredicateNode)predicate, object));
    }

    protected void add(SubjectNode subject, RDFName predicate, String lexicalValue, Set<Triple> set) throws Exception {
        if (lexicalValue != null) {
            set.add((Triple)new SimpleTriple(subject, (PredicateNode)predicate, (ObjectNode)new SimpleLiteral(lexicalValue)));
        }
    }

    protected void add(SubjectNode subject, RDFName predicate, String lexicalValue, String lang, Set<Triple> set) throws Exception {
        if (lexicalValue != null) {
            set.add((Triple)new SimpleTriple(subject, (PredicateNode)predicate, (ObjectNode)new SimpleLiteral(lexicalValue, lang)));
        }
    }

    protected void add(SubjectNode subject, RDFName predicate, Date dateValue, Set<Triple> set) throws Exception {
        if (dateValue != null) {
            String lexicalValue = DateUtility.convertDateToXSDString((Date)dateValue);
            SimpleLiteral object = new SimpleLiteral(lexicalValue, Constants.RDF_XSD.DATE_TIME.getURI());
            set.add((Triple)new SimpleTriple(subject, (PredicateNode)predicate, (ObjectNode)object));
        }
    }

    protected void add(SubjectNode subject, RDFName predicate, boolean booleanValue, Set<Triple> set) throws Exception {
        this.add(subject, predicate, Boolean.toString(booleanValue), set);
    }
}

