/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.errors.DatastreamNotFoundException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.storage.RDFRelationshipReader;
import org.fcrepo.server.storage.types.DatastreamDef;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Property;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatastreamFilenameHelper {
    private static final Logger logger = LoggerFactory.getLogger(DatastreamFilenameHelper.class);
    protected static String m_datastreamContentDispositionInlineEnabled;
    protected static String m_datastreamFilenameSource;
    protected static String m_datastreamExtensionMappingLabel;
    protected static String m_datastreamExtensionMappingId;
    protected static String m_datastreamExtensionMappingRels;
    protected static String m_datastreamExtensionMappingDefault;
    protected static String m_datastreamDefaultFilename;
    protected static String m_datastreamDefaultExtension;
    private static String DATASTREAM_MAPPING_SOURCE_FILE;
    protected static String FILENAME_REL;
    protected static Pattern ILLEGAL_FILENAME_REGEX;
    protected Management m_apiMService;
    protected Access m_apiAService;
    protected static HashMap<String, String> m_extensionMappings;

    public DatastreamFilenameHelper(Server fedoraServer, Management management, Access access) {
        m_datastreamContentDispositionInlineEnabled = fedoraServer.getParameter("datastreamContentDispositionInlineEnabled");
        m_datastreamFilenameSource = fedoraServer.getParameter("datastreamFilenameSource");
        m_datastreamExtensionMappingLabel = fedoraServer.getParameter("datastreamExtensionMappingLabel");
        m_datastreamExtensionMappingId = fedoraServer.getParameter("datastreamExtensionMappingId");
        m_datastreamExtensionMappingRels = fedoraServer.getParameter("datastreamExtensionMappingRels");
        m_datastreamExtensionMappingDefault = fedoraServer.getParameter("datastreamExtensionMappingDefault");
        m_datastreamDefaultFilename = fedoraServer.getParameter("datastreamDefaultFilename");
        m_datastreamDefaultExtension = fedoraServer.getParameter("datastreamDefaultExtension");
        this.m_apiMService = management;
        this.m_apiAService = access;
    }

    private static final String getExtension(String MIMETYPE) throws Exception {
        String extension;
        if (m_extensionMappings == null) {
            m_extensionMappings = DatastreamFilenameHelper.readExtensionMappings(Server.FEDORA_HOME + "/server/" + Server.CONFIG_DIR + "/" + DATASTREAM_MAPPING_SOURCE_FILE);
        }
        if ((extension = m_extensionMappings.get(MIMETYPE)) != null) {
            return extension;
        }
        return "";
    }

    private static final synchronized HashMap<String, String> readExtensionMappings(String mappingFile) throws Exception {
        HashMap<String, String> extensionMappings = new HashMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(new File(mappingFile));
        Element root = doc.getDocumentElement();
        NodeList mappingNodes = root.getChildNodes();
        for (int i = 0; i < mappingNodes.getLength(); ++i) {
            Node mappingNode = mappingNodes.item(i);
            if (mappingNode.getNodeType() != 1 || !mappingNode.getNodeName().equals("mime-mapping")) continue;
            String extension = null;
            String mimeType = null;
            NodeList nl = mappingNode.getChildNodes();
            for (int j = 0; j < nl.getLength(); ++j) {
                Node n = nl.item(j);
                if (n.getNodeType() != 1) continue;
                if (n.getNodeName().equals("extension")) {
                    extension = n.getFirstChild().getNodeValue();
                    continue;
                }
                if (!n.getNodeName().equals("mime-type")) continue;
                mimeType = n.getFirstChild().getNodeValue();
            }
            if (extension != null && mimeType != null) {
                if (!extensionMappings.containsKey(mimeType)) {
                    extensionMappings.put(mimeType, extension);
                    continue;
                }
                logger.warn("Duplicate extension " + extension + " found for mime-type " + mimeType + " in " + mappingFile);
                continue;
            }
            logger.warn("Element mime-mapping is missing child elements mime-type and/or extension in " + mappingFile);
        }
        return extensionMappings;
    }

    public final void addContentDispositionHeader(Context context, String pid, String dsID, String download, Date asOfDateTime, MIMETypedStream stream) throws Exception {
        String headerValue = null;
        String filename = null;
        if (download != null && download.equals("true")) {
            filename = this.getFilename(context, pid, dsID, asOfDateTime, stream.MIMEType);
            headerValue = "attachment; filename=\"" + filename + "\"";
        } else if (m_datastreamContentDispositionInlineEnabled.equals("true")) {
            filename = this.getFilename(context, pid, dsID, asOfDateTime, stream.MIMEType);
            headerValue = "inline; filename=\"" + filename + "\"";
        }
        Property[] header = new Property[]{new Property("content-disposition", headerValue)};
        if (stream.header != null) {
            Property[] headers = new Property[stream.header.length + 1];
            System.arraycopy(stream.header, 0, headers, 0, stream.header.length);
            headers[headers.length - 1] = header[0];
            stream.header = headers;
        } else {
            stream.header = header;
        }
    }

    private final String getFilename(Context context, String pid, String dsid, Date asOfDateTime, String MIMETYPE) throws Exception {
        String filename = "";
        String extension = "";
        for (String source : m_datastreamFilenameSource.split(" ")) {
            if (source.equals("rels")) {
                filename = this.getFilenameFromRels(context, pid, dsid, MIMETYPE);
                if (!filename.equals("")) {
                    extension = DatastreamFilenameHelper.getExtension(filename, m_datastreamExtensionMappingRels, MIMETYPE);
                }
            } else if (source.equals("id")) {
                filename = DatastreamFilenameHelper.getFilenameFromId(pid, dsid, MIMETYPE);
                if (!filename.equals("")) {
                    extension = DatastreamFilenameHelper.getExtension(filename, m_datastreamExtensionMappingId, MIMETYPE);
                }
            } else if (source.equals("label")) {
                filename = this.getFilenameFromLabel(context, pid, dsid, asOfDateTime, MIMETYPE);
                if (!filename.equals("")) {
                    extension = DatastreamFilenameHelper.getExtension(filename, m_datastreamExtensionMappingLabel, MIMETYPE);
                }
            } else {
                logger.warn("Unknown datastream filename source specified in datastreamFilenameSource in fedora.fcfg: " + source + ". Please specify zero or more of: rels id label");
            }
            if (!filename.equals("")) break;
        }
        if (filename.equals("")) {
            filename = m_datastreamDefaultFilename;
            extension = DatastreamFilenameHelper.getExtension(m_datastreamDefaultFilename, m_datastreamExtensionMappingDefault, MIMETYPE);
        }
        if (extension.equals("")) {
            return ILLEGAL_FILENAME_REGEX.matcher(filename).replaceAll("");
        }
        return ILLEGAL_FILENAME_REGEX.matcher(filename + "." + extension).replaceAll("");
    }

    private final String getFilenameFromRels(Context context, String pid, String dsid, String MIMETYPE) throws Exception {
        MIMETypedStream relsInt;
        String filename = "";
        try {
            relsInt = this.m_apiAService.getDatastreamDissemination(context, pid, "RELS-INT", null);
        }
        catch (DatastreamNotFoundException e) {
            return "";
        }
        Set<RelationshipTuple> relsIntTuples = RDFRelationshipReader.readRelationships(relsInt.getStream());
        int matchingTuples = 0;
        for (RelationshipTuple tuple : relsIntTuples) {
            if (!tuple.subject.equals(Constants.FEDORA.uri + pid + "/" + dsid) || !tuple.predicate.equals(FILENAME_REL)) continue;
            if (matchingTuples == 0) {
                if (tuple.isLiteral) {
                    filename = tuple.object;
                } else {
                    logger.warn("Object " + pid + " datastream " + dsid + " specifies a filename which is not a literal in RELS-INT");
                    filename = "";
                }
            }
            ++matchingTuples;
        }
        if (matchingTuples > 1) {
            logger.warn("Object " + pid + " datastream " + dsid + " specifies more than one filename in RELS-INT.");
        }
        return filename;
    }

    private final String getFilenameFromLabel(Context context, String pid, String dsid, Date asOfDateTime, String MIMETYPE) throws Exception {
        DatastreamDef[] datastreams = this.m_apiAService.listDatastreams(context, pid, asOfDateTime);
        String filename = "";
        for (DatastreamDef datastream : datastreams) {
            if (!datastream.dsID.equals(dsid)) continue;
            filename = datastream.dsLabel;
            break;
        }
        return filename;
    }

    private static final String getFilenameFromId(String pid, String dsid, String MIMETYPE) throws Exception {
        return dsid;
    }

    private static final String getExtension(String filename, String mappingType, String MIMETYPE) throws Exception {
        String extension = "";
        if (mappingType.equals("never")) {
            extension = "";
        } else if (mappingType.equals("ifmissing") && filename.contains(".")) {
            extension = "";
        } else if (mappingType.equals("ifmissing") || mappingType.equals("always")) {
            extension = DatastreamFilenameHelper.getExtension(MIMETYPE);
            if (extension.equals("")) {
                extension = m_datastreamDefaultExtension;
            }
        } else {
            logger.warn("Unknown extension mapping type specified in fedora.fcfg");
            extension = m_datastreamDefaultExtension;
        }
        return extension;
    }

    static {
        DATASTREAM_MAPPING_SOURCE_FILE = "mime-to-extensions.xml";
        FILENAME_REL = Constants.MODEL.DOWNLOAD_FILENAME.uri;
        ILLEGAL_FILENAME_REGEX = Pattern.compile("[\\\\/\\*\\?<>:\\|\";,%#\\$]+");
    }
}

