/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.rest.BaseRestResource;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.TupleArrayTripleIterator;
import org.springframework.stereotype.Component;
import org.trippi.RDFFormat;
import org.trippi.TrippiException;

@Path(value="/{pid : ([A-Za-z0-9]|-|\\.)+:(([A-Za-z0-9])|-|\\.|~|_|(%[0-9A-F]{2}))+}/relationships")
@Component
public class RelationshipResource
extends BaseRestResource {
    public RelationshipResource(Server server) {
        super(server);
    }

    @GET
    @Produces(value={"application/rdf+xml", "text/plain", "application/x-turtle", "application/sparql-results+xml"})
    public Response getRelationships(@PathParam(value="pid") String pid, @QueryParam(value="subject") String subject, @QueryParam(value="predicate") String predicate, @QueryParam(value="format") @DefaultValue(value="rdf/xml") String format, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        Context context = this.getContext();
        if (subject == null) {
            subject = PID.toURI((String)pid);
        }
        try {
            MediaType mediaType;
            RDFFormat outputFormat;
            RelationshipTuple[] tuples = this.m_management.getRelationships(context, subject, predicate);
            TupleArrayTripleIterator it = new TupleArrayTripleIterator(new ArrayList<RelationshipTuple>(Arrays.asList(tuples)));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            format = format.toLowerCase();
            if (format.equalsIgnoreCase("xml") || format.equals("rdf/xml")) {
                outputFormat = RDFFormat.RDF_XML;
                mediaType = new MediaType("application", "rdf+xml");
            } else if (format.equals("n-triples") || format.equals("ntriples")) {
                outputFormat = RDFFormat.N_TRIPLES;
                mediaType = MediaType.TEXT_PLAIN_TYPE;
            } else if (format.equals("turtle")) {
                outputFormat = RDFFormat.TURTLE;
                mediaType = new MediaType("application", "x-turtle");
            } else if (format.equals("sparql")) {
                outputFormat = RDFFormat.SPARQL;
                mediaType = new MediaType("application", "sparql-results+xml");
            } else {
                throw new IllegalArgumentException("unknown format: " + format);
            }
            it.toStream(out, outputFormat);
            return Response.ok((Object)out.toString("UTF-8"), (MediaType)mediaType).build();
        }
        catch (ServerException e) {
            return this.handleException(e, flash);
        }
        catch (TrippiException e) {
            return this.handleException((Exception)((Object)e), flash);
        }
        catch (UnsupportedEncodingException e) {
            return this.handleException(e, flash);
        }
    }

    @Path(value="/new")
    @POST
    public Response addRelationship(@PathParam(value="pid") String pid, @QueryParam(value="subject") String subject, @QueryParam(value="predicate") String predicate, @QueryParam(value="object") String object, @QueryParam(value="isLiteral") boolean isLiteral, @QueryParam(value="datatype") String datatype, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        Context context = this.getContext();
        try {
            if (subject == null) {
                subject = PID.toURI((String)pid);
            }
            boolean result = this.m_management.addRelationship(context, subject, predicate, object, isLiteral, datatype);
            return Response.ok((Object)Boolean.toString(result)).build();
        }
        catch (ServerException e) {
            return this.handleException(e, flash);
        }
    }

    @DELETE
    public Response purgeRelationship(@PathParam(value="pid") String pid, @QueryParam(value="subject") String subject, @QueryParam(value="predicate") String predicate, @QueryParam(value="object") String object, @QueryParam(value="isLiteral") boolean isLiteral, @QueryParam(value="datatype") String datatype, @QueryParam(value="flash") @DefaultValue(value="false") boolean flash) {
        Context context = this.getContext();
        try {
            if (subject == null) {
                subject = PID.toURI((String)pid);
            }
            boolean result = this.m_management.purgeRelationship(context, subject, predicate, object, isLiteral, datatype);
            return Response.ok((Object)Boolean.toString(result), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (ServerException e) {
            return this.handleException(e, flash);
        }
    }
}

