/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.rest.param;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class AbstractParam<V> {
    private final V value;
    private final String originalParam;

    public AbstractParam(String param) throws WebApplicationException {
        this.originalParam = param;
        try {
            this.value = this.parse(param);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new WebApplicationException(this.onError(param, e));
        }
    }

    public V getValue() {
        return this.value;
    }

    public String getOriginalParam() {
        return this.originalParam;
    }

    public String toString() {
        return this.value.toString();
    }

    protected abstract V parse(String var1) throws Throwable;

    protected Response onError(String param, Throwable e) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorMessage(param, e)).build();
    }

    protected String getErrorMessage(String param, Throwable e) {
        return String.format("Invalid parameter: \"%s\". %s", param, e.getMessage());
    }
}

