/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.util.ArrayList;
import java.util.List;
import org.fcrepo.server.errors.InvalidOperatorException;
import org.fcrepo.server.errors.QueryParseException;
import org.fcrepo.server.search.Operator;

public class Condition {
    private final String m_property;
    private final Operator m_operator;
    private final String m_value;

    public Condition(String property, Operator operator, String value) throws QueryParseException {
        this.m_property = property;
        this.m_operator = operator;
        if (value.indexOf("'") != -1) {
            throw new QueryParseException("Query cannot contain the ' character.");
        }
        this.m_value = value;
    }

    public Condition(String property, String operator, String value) throws InvalidOperatorException, QueryParseException {
        this.m_property = property;
        this.m_operator = Operator.fromAbbreviation(operator);
        if (value.indexOf("'") != -1) {
            throw new QueryParseException("Query cannot contain the ' character.");
        }
        this.m_value = value;
    }

    public static List<Condition> getConditions(String query) throws QueryParseException {
        StringBuffer prop = new StringBuffer();
        Operator oper = null;
        StringBuffer val = new StringBuffer();
        ArrayList<Condition> ret = new ArrayList<Condition>();
        boolean inProp = true;
        boolean inValue = false;
        boolean firstValueChar = false;
        boolean valueStartsWithQuote = false;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (inProp) {
                char d;
                if (c == '=') {
                    oper = Operator.EQUALS;
                    inProp = false;
                    inValue = true;
                    firstValueChar = true;
                    continue;
                }
                if (c == '~') {
                    oper = Operator.CONTAINS;
                    inProp = false;
                    inValue = true;
                    firstValueChar = true;
                    continue;
                }
                if (c == '>') {
                    if (i + 1 < query.length()) {
                        d = query.charAt(i + 1);
                        if (d == '=') {
                            ++i;
                            oper = Operator.GREATER_OR_EQUAL;
                        } else {
                            oper = Operator.GREATER_THAN;
                        }
                        inProp = false;
                        inValue = true;
                        firstValueChar = true;
                        continue;
                    }
                    throw new QueryParseException("Found <end-of-string> immediately following '>' operator, but expected a value.");
                }
                if (c == '<') {
                    if (i + 1 < query.length()) {
                        d = query.charAt(i + 1);
                        if (d == '=') {
                            ++i;
                            oper = Operator.LESS_OR_EQUAL;
                        } else {
                            oper = Operator.LESS_THAN;
                        }
                        inProp = false;
                        inValue = true;
                        firstValueChar = true;
                        continue;
                    }
                    throw new QueryParseException("Found <end-of-string> immediately following '<' operator, but expected a value.");
                }
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    prop.append(c);
                    continue;
                }
                throw new QueryParseException("Found ' " + c + "' at character " + i + " but expected operator");
            }
            if (!inValue) continue;
            if (prop.toString().length() == 0) {
                throw new QueryParseException("Found operator but expected a non-zero length property.");
            }
            if (firstValueChar) {
                if (c == '\'') {
                    if (++i >= query.length()) {
                        throw new QueryParseException("Found <end-of-string> immediately following start quote, but expected a value.");
                    }
                    c = query.charAt(i);
                    valueStartsWithQuote = true;
                }
                firstValueChar = false;
            }
            if (c == '\'') {
                if (!valueStartsWithQuote) {
                    throw new QueryParseException("Found ' character in value at position " + i + ", but the value " + "did not start with a string, so this can't " + " be a value terminator.");
                }
                if (++i < query.length() && query.charAt(i) != ' ') {
                    throw new QueryParseException("Found value-terminator ' but it was not followed by <end-of-string> or <space>.");
                }
                ret.add(new Condition(prop.toString(), oper, val.toString()));
                prop = new StringBuffer();
                oper = null;
                val = new StringBuffer();
                inValue = false;
                inProp = true;
                valueStartsWithQuote = false;
                continue;
            }
            if (c == '\\') {
                if (++i >= query.length()) {
                    throw new QueryParseException("Found character-escaping character as last item in string.");
                }
                val.append(query.charAt(i));
                continue;
            }
            if (c == ' ') {
                if (valueStartsWithQuote) {
                    val.append(c);
                    continue;
                }
                ret.add(new Condition(prop.toString(), oper, val.toString()));
                prop = new StringBuffer();
                oper = null;
                val = new StringBuffer();
                inValue = false;
                inProp = true;
                continue;
            }
            if (c == '=') {
                throw new QueryParseException("Found <operator> at position " + i + ", but expected <value>");
            }
            if (c == '~') {
                throw new QueryParseException("Found <operator> at position " + i + ", but expected <value>");
            }
            if (c == '>') {
                throw new QueryParseException("Found <operator> at position " + i + ", but expected <value>");
            }
            if (c == '<') {
                throw new QueryParseException("Found <operator> at position " + i + ", but expected <value>");
            }
            val.append(c);
        }
        if (inProp && prop.toString().length() > 0) {
            throw new QueryParseException("String ended before operator was found");
        }
        if (inValue) {
            if (valueStartsWithQuote) {
                throw new QueryParseException("String ended before quoted value's ending quote.");
            }
            ret.add(new Condition(prop.toString(), oper, val.toString()));
        }
        return ret;
    }

    public String getProperty() {
        return this.m_property;
    }

    public Operator getOperator() {
        return this.m_operator;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        Condition that = (Condition)o;
        return this.equivalent(this.m_property, that.m_property) && this.equivalent(this.m_value, that.m_value) && this.equivalent((Object)this.m_operator, (Object)that.m_operator);
    }

    public int hashCode() {
        return this.m_property.hashCode() ^ this.m_operator.hashCode() ^ this.m_value.hashCode();
    }

    public String toString() {
        return "Condition[" + this.m_property + (Object)((Object)this.m_operator) + this.m_value + "]";
    }

    private boolean equivalent(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }
}

