/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StorageDeviceException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnknownSessionTokenException;
import org.fcrepo.server.errors.UnrecognizedFieldException;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.FieldSearchResultSQLImpl;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.server.utilities.DCFields;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.utilities.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSearchSQLImpl
implements FieldSearch {
    private static final Logger logger = LoggerFactory.getLogger(FieldSearchSQLImpl.class);
    private boolean m_indexDCFields = true;
    private final ConnectionPool m_cPool;
    private final RepositoryReader m_repoReader;
    private final int m_maxResults;
    private final int m_maxSecondsPerSession;
    public static String[] DB_COLUMN_NAMES = new String[]{"pid", "label", "state", "ownerId", "cDate", "mDate", "dcmDate", "dcTitle", "dcCreator", "dcSubject", "dcDescription", "dcPublisher", "dcContributor", "dcDate", "dcType", "dcFormat", "dcIdentifier", "dcSource", "dcLanguage", "dcRelation", "dcCoverage", "dcRights"};
    private static boolean[] s_dbColumnNumeric = new boolean[]{false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static String[] DB_COLUMN_NAMES_NODC = new String[]{"pid", "label", "state", "ownerId", "cDate", "mDate", "dcmDate"};
    private static boolean[] s_dbColumnNumericNoDC = new boolean[]{false, false, false, false, true, true, true};
    private final HashMap<String, FieldSearchResultSQLImpl> m_currentResults = new HashMap();

    public FieldSearchSQLImpl(ConnectionPool cPool, RepositoryReader repoReader, int maxResults, int maxSecondsPerSession) {
        this(cPool, repoReader, maxResults, maxSecondsPerSession, true);
    }

    public FieldSearchSQLImpl(ConnectionPool cPool, RepositoryReader repoReader, int maxResults, int maxSecondsPerSession, boolean indexDCFields) {
        logger.debug("Entering constructor");
        this.m_cPool = cPool;
        this.m_repoReader = repoReader;
        this.m_maxResults = maxResults;
        this.m_maxSecondsPerSession = maxSecondsPerSession;
        this.m_indexDCFields = indexDCFields;
        logger.debug("Exiting constructor");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(DOReader reader) throws ServerException {
        logger.debug("Entering update(DOReader)");
        String pid = reader.GetObjectPID();
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.m_cPool.getReadWriteConnection();
            String[] dbRowValues = this.m_indexDCFields ? new String[DB_COLUMN_NAMES.length] : new String[DB_COLUMN_NAMES_NODC.length];
            dbRowValues[0] = reader.GetObjectPID();
            String v = reader.GetObjectLabel();
            if (v != null) {
                v = v.toLowerCase();
            }
            dbRowValues[1] = v;
            dbRowValues[2] = reader.GetObjectState().toLowerCase();
            v = reader.getOwnerId();
            if (v != null) {
                v = v.toLowerCase();
            }
            dbRowValues[3] = v;
            Date date = reader.getCreateDate();
            if (date == null) {
                date = new Date();
            }
            dbRowValues[4] = "" + date.getTime();
            date = reader.getLastModDate();
            if (date == null) {
                date = new Date();
            }
            dbRowValues[5] = "" + date.getTime();
            Datastream dcmd = null;
            try {
                dcmd = reader.GetDatastream("DC", null);
            }
            catch (ClassCastException cce) {
                throw new ObjectIntegrityException("Object " + reader.GetObjectPID() + " has a DC datastream, but it's not inline XML.");
            }
            dbRowValues[6] = dcmd == null ? "0" : "" + dcmd.DSCreateDT.getTime();
            if (dcmd != null && this.m_indexDCFields) {
                int i;
                InputStream in = dcmd.getContentStream();
                DCFields dc = new DCFields(in);
                dbRowValues[7] = FieldSearchSQLImpl.getDbValue(dc.titles());
                dbRowValues[8] = FieldSearchSQLImpl.getDbValue(dc.creators());
                dbRowValues[9] = FieldSearchSQLImpl.getDbValue(dc.subjects());
                dbRowValues[10] = FieldSearchSQLImpl.getDbValue(dc.descriptions());
                dbRowValues[11] = FieldSearchSQLImpl.getDbValue(dc.publishers());
                dbRowValues[12] = FieldSearchSQLImpl.getDbValue(dc.contributors());
                dbRowValues[13] = FieldSearchSQLImpl.getDbValue(dc.dates());
                st = conn.prepareStatement("DELETE FROM dcDates WHERE pid=?");
                st.setString(1, pid);
                st.executeUpdate();
                ArrayList<Date> wellFormedDates = null;
                for (i = 0; i < dc.dates().size(); ++i) {
                    Date p;
                    if (i == 0) {
                        wellFormedDates = new ArrayList<Date>();
                    }
                    if ((p = DateUtility.parseDateLoose((String)dc.dates().get(i).getValue())) == null) continue;
                    wellFormedDates.add(p);
                }
                if (wellFormedDates != null && wellFormedDates.size() > 0) {
                    for (i = 0; i < wellFormedDates.size(); ++i) {
                        Date dt = (Date)wellFormedDates.get(i);
                        String query = "INSERT INTO dcDates (pid, dcDate) values (?, ?)";
                        st = conn.prepareStatement(query);
                        st.setString(1, pid);
                        st.setLong(2, dt.getTime());
                        st.executeUpdate();
                    }
                }
                dbRowValues[14] = FieldSearchSQLImpl.getDbValue(dc.types());
                dbRowValues[15] = FieldSearchSQLImpl.getDbValue(dc.formats());
                dbRowValues[16] = FieldSearchSQLImpl.getDbValue(dc.identifiers());
                dbRowValues[17] = FieldSearchSQLImpl.getDbValue(dc.sources());
                dbRowValues[18] = FieldSearchSQLImpl.getDbValue(dc.languages());
                dbRowValues[19] = FieldSearchSQLImpl.getDbValue(dc.relations());
                dbRowValues[20] = FieldSearchSQLImpl.getDbValue(dc.coverages());
                dbRowValues[21] = FieldSearchSQLImpl.getDbValue(dc.rights());
                logger.debug("Formulating SQL and inserting/updating WITH DC...");
                SQLUtility.replaceInto(conn, "doFields", DB_COLUMN_NAMES, dbRowValues, "pid", s_dbColumnNumeric);
                return;
            }
            logger.debug("Formulating SQL and inserting/updating WITHOUT DC...");
            SQLUtility.replaceInto(conn, "doFields", DB_COLUMN_NAMES_NODC, dbRowValues, "pid", s_dbColumnNumericNoDC);
            return;
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Error attempting FieldSearch update of " + pid, sqle);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    this.m_cPool.free(conn);
                }
            }
            catch (SQLException sqle2) {
                throw new StorageDeviceException("Error closing statement while attempting update of object" + sqle2.getMessage());
            }
            finally {
                st = null;
                logger.debug("Exiting update(DOReader)");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(String pid) throws ServerException {
        logger.debug("Entering delete(String)");
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.m_cPool.getReadWriteConnection();
            st = conn.prepareStatement("DELETE FROM doFields WHERE pid=?");
            st.setString(1, pid);
            st.executeUpdate();
            st = conn.prepareStatement("DELETE FROM dcDates WHERE pid=?");
            st.setString(1, pid);
            st.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Error attempting delete of object with pid '" + pid + "': " + sqle.getMessage());
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    this.m_cPool.free(conn);
                }
            }
            catch (SQLException sqle2) {
                throw new StorageDeviceException("Error closing statement while attempting update of object" + sqle2.getMessage());
            }
            finally {
                st = null;
                logger.debug("Exiting delete(String)");
            }
        }
    }

    @Override
    public FieldSearchResult findObjects(String[] resultFields, int maxResults, FieldSearchQuery query) throws UnrecognizedFieldException, ObjectIntegrityException, RepositoryConfigurationException, StreamIOException, ServerException, StorageDeviceException {
        this.closeAndForgetOldResults();
        int actualMax = maxResults;
        if (this.m_maxResults < maxResults) {
            actualMax = this.m_maxResults;
        }
        try {
            return this.stepAndRemember(new FieldSearchResultSQLImpl(this.m_cPool, this.m_repoReader, resultFields, actualMax, this.m_maxSecondsPerSession, query));
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Error querying sql db: " + sqle.getMessage(), sqle);
        }
    }

    @Override
    public FieldSearchResult resumeFindObjects(String sessionToken) throws UnrecognizedFieldException, ObjectIntegrityException, RepositoryConfigurationException, StreamIOException, ServerException, UnknownSessionTokenException {
        this.closeAndForgetOldResults();
        FieldSearchResultSQLImpl result = this.m_currentResults.remove(sessionToken);
        if (result == null) {
            throw new UnknownSessionTokenException("Session is expired or never existed.");
        }
        return this.stepAndRemember(result);
    }

    private FieldSearchResult stepAndRemember(FieldSearchResultSQLImpl result) throws UnrecognizedFieldException, ObjectIntegrityException, RepositoryConfigurationException, StreamIOException, ServerException, UnrecognizedFieldException {
        result.step();
        if (result.getToken() != null) {
            this.m_currentResults.put(result.getToken(), result);
        }
        return result;
    }

    private void closeAndForgetOldResults() {
        Iterator<FieldSearchResultSQLImpl> iter = this.m_currentResults.values().iterator();
        ArrayList<String> toRemove = new ArrayList<String>();
        while (iter.hasNext()) {
            FieldSearchResultSQLImpl r = iter.next();
            if (!r.isExpired()) continue;
            logger.debug("listSession " + r.getToken() + " expired; will forget it.");
            toRemove.add(r.getToken());
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            String token = (String)toRemove.get(i);
            this.m_currentResults.remove(token);
        }
    }

    private static String getDbValue(List<DCField> dcFields) {
        if (dcFields.size() == 0) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        for (DCField dcField : dcFields) {
            out.append(" ");
            out.append(dcField.getValue().toLowerCase());
        }
        out.append(" .");
        return out.toString();
    }

    private static String getDbValueCaseSensitive(List<String> dcItem) {
        if (dcItem.size() == 0) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < dcItem.size(); ++i) {
            String val = dcItem.get(i);
            out.append(" ");
            out.append(val);
        }
        out.append(" .");
        return out.toString();
    }
}

