/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.util.Map;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ConnectionPoolNotFoundException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.FieldSearchSQLImpl;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSearchSQLModule
extends Module
implements FieldSearch {
    private static final Logger logger = LoggerFactory.getLogger(FieldSearchSQLModule.class);
    private FieldSearchSQLImpl m_wrappedFieldSearch;

    public FieldSearchSQLModule(Map params, Server server, String role) throws ModuleInitializationException {
        super(params, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
        ConnectionPoolManager cpm;
        if (this.getParameter("maxResults") == null) {
            throw new ModuleInitializationException("maxResults parameter must be specified.", this.getRole());
        }
        int maxResults = 0;
        try {
            maxResults = Integer.parseInt(this.getParameter("maxResults"));
            if (maxResults < 1) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ModuleInitializationException("maxResults must be a positive integer.", this.getRole());
        }
        if (this.getParameter("maxSecondsPerSession") == null) {
            throw new ModuleInitializationException("maxSecondsPerSession parameter must be specified.", this.getRole());
        }
        int maxSecondsPerSession = 0;
        try {
            maxSecondsPerSession = Integer.parseInt(this.getParameter("maxSecondsPerSession"));
            if (maxSecondsPerSession < 1) {
                throw new NumberFormatException("");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ModuleInitializationException("maxSecondsPerSession must be a positive integer.", this.getRole());
        }
        boolean indexDCFields = true;
        String indexDCFieldsValue = this.getParameter("indexDCFields");
        if (indexDCFieldsValue != null) {
            String val = indexDCFieldsValue.trim().toLowerCase();
            if (val.equals("false") || val.equals("no")) {
                indexDCFields = false;
            } else if (!val.equals("true") && !val.equals("yes")) {
                throw new ModuleInitializationException("indexDCFields param was not a boolean", this.getRole());
            }
        }
        if ((cpm = (ConnectionPoolManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ConnectionPoolManager"))) == null) {
            throw new ModuleInitializationException("ConnectionPoolManager module was required, but apparently has not been loaded.", this.getRole());
        }
        String cPoolName = this.getParameter("connectionPool");
        ConnectionPool cPool = null;
        try {
            if (cPoolName == null) {
                logger.debug("connectionPool unspecified; using default from ConnectionPoolManager.");
                cPool = cpm.getPool();
            } else {
                logger.debug("connectionPool specified: " + cPoolName);
                cPool = cpm.getPool(cPoolName);
            }
        }
        catch (ConnectionPoolNotFoundException cpnfe) {
            throw new ModuleInitializationException("Could not find requested connectionPool.", this.getRole());
        }
        DOManager doManager = (DOManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.DOManager"));
        if (doManager == null) {
            throw new ModuleInitializationException("DOManager module was required, but apparently has not been loaded.", this.getRole());
        }
        this.m_wrappedFieldSearch = new FieldSearchSQLImpl(cPool, doManager, maxResults, maxSecondsPerSession, indexDCFields);
    }

    @Override
    public String[] getRequiredModuleRoles() {
        return new String[]{"org.fcrepo.server.storage.ConnectionPoolManager", "org.fcrepo.server.storage.DOManager"};
    }

    @Override
    public void update(DOReader reader) throws ServerException {
        this.m_wrappedFieldSearch.update(reader);
    }

    @Override
    public boolean delete(String pid) throws ServerException {
        return this.m_wrappedFieldSearch.delete(pid);
    }

    @Override
    public FieldSearchResult findObjects(String[] resultFields, int maxResults, FieldSearchQuery query) throws ServerException {
        return this.m_wrappedFieldSearch.findObjects(resultFields, maxResults, query);
    }

    @Override
    public FieldSearchResult resumeFindObjects(String sessionToken) throws ServerException {
        return this.m_wrappedFieldSearch.resumeFindObjects(sessionToken);
    }
}

