/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.fcrepo.common.PID;
import org.fcrepo.server.security.BackendSecurityDeserializer;
import org.fcrepo.server.security.BackendSecuritySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendPolicies {
    private static final Logger logger = LoggerFactory.getLogger(BackendPolicies.class);
    public static final String FEDORA_INTERNAL_CALL = "fedoraInternalCall-1";
    public static final String BACKEND_SERVICE_CALL_UNSECURE = "fedoraInternalCall-2";
    private String inFilePath = null;
    private String outFilePath = null;
    private BackendSecuritySpec backendSecuritySpec = null;

    public BackendPolicies(String inFilePath, String outFilePath) {
        this.inFilePath = inFilePath;
        this.outFilePath = outFilePath;
    }

    public BackendPolicies(String inFilePath) {
        this(inFilePath, null);
    }

    public Hashtable generateBackendPolicies() throws Exception {
        logger.debug("in BackendPolicies.generateBackendPolicies() 1");
        Hashtable tempfiles = null;
        if (this.inFilePath.endsWith(".xml")) {
            logger.debug("in BackendPolicies.generateBackendPolicies() .xml 1");
            BackendSecurityDeserializer bds = new BackendSecurityDeserializer("UTF-8", false);
            logger.debug("in BackendPolicies.generateBackendPolicies() .xml 2");
            this.backendSecuritySpec = bds.deserialize(this.inFilePath);
            logger.debug("in BackendPolicies.generateBackendPolicies() .xml 3");
            tempfiles = this.writePolicies();
            logger.debug("in BackendPolicies.generateBackendPolicies() .xml 4");
        }
        return tempfiles;
    }

    private static final String[] parseForSlash(String key) throws Exception {
        int lastSlash = key.lastIndexOf("/");
        if (lastSlash + 1 == key.length()) {
            throw new Exception("BackendPolicies.newWritePolicies() can't handle key ending with '/'");
        }
        if (lastSlash != key.indexOf("/")) {
            throw new Exception("BackendPolicies.newWritePolicies() can't handle key containing multiple instances of '/'");
        }
        String[] parts = null;
        parts = -1 < lastSlash && lastSlash < key.length() ? key.split("/") : new String[]{key};
        return parts;
    }

    private static final String getExcludedRolesText(String key, Set roles) {
        StringBuffer excludedRolesText = new StringBuffer();
        if ("default".equals(key) && roles.size() > 1) {
            excludedRolesText.append("\t\t<ExcludedRoles>\n");
            Iterator excludedRoleIterator = roles.iterator();
            while (excludedRoleIterator.hasNext()) {
                logger.debug("in BackendPolicies.newWritePolicies() another inner it");
                String excludedRole = (String)excludedRoleIterator.next();
                if ("default".equals(excludedRole)) continue;
                logger.debug("in BackendPolicies.newWritePolicies() excludedRole=" + excludedRole);
                excludedRolesText.append("\t\t\t<ExcludedRole>");
                excludedRolesText.append(excludedRole);
                excludedRolesText.append("</ExcludedRole>\n");
            }
            excludedRolesText.append("\t\t</ExcludedRoles>\n");
        }
        return excludedRolesText.toString();
    }

    private static final String writeRules(String callbackBasicAuth, String callbackSsl, String iplist, String role, Set roles) throws Exception {
        StringBuffer temp = new StringBuffer();
        temp.append("\t<Rule RuleId=\"1\" Effect=\"Permit\">\n");
        temp.append(BackendPolicies.getExcludedRolesText(role, roles));
        if ("true".equals(callbackBasicAuth)) {
            temp.append("\t\t<AuthnRequired/>\n");
        }
        if ("true".equals(callbackSsl)) {
            temp.append("\t\t<SslRequired/>\n");
        }
        logger.debug("DEBUGGING IPREGEX0 [" + iplist + "]");
        String[] ipRegexes = new String[]{};
        if (iplist != null && !"".equals(iplist.trim())) {
            ipRegexes = iplist.trim().split("\\s");
        }
        logger.debug("DEBUGGING IPREGEX1 [" + iplist.trim() + "]");
        if (ipRegexes.length != 0) {
            temp.append("\t\t<IpRegexes>\n");
            for (String element : ipRegexes) {
                logger.debug("DEBUGGING IPREGEX2 " + element);
                temp.append("\t\t\t<IpRegex>");
                temp.append(element);
                temp.append("</IpRegex>\n");
            }
            temp.append("\t\t</IpRegexes>\n");
        }
        temp.append("\t</Rule>\n");
        if ("true".equals(callbackBasicAuth) || "true".equals(callbackSsl) || ipRegexes.length != 0) {
            temp.append("\t<Rule RuleId=\"2\" Effect=\"Deny\">\n");
            temp.append(BackendPolicies.getExcludedRolesText(role, roles));
            temp.append("\t</Rule>\n");
        }
        return temp.toString();
    }

    private Hashtable writePolicies() throws Exception {
        logger.debug("in BackendPolicies.newWritePolicies() 1");
        StringBuffer sb = null;
        Hashtable<String, String> tempfiles = new Hashtable<String, String>();
        for (String key : this.backendSecuritySpec.listRoleKeys()) {
            String iplist;
            String[] parts = BackendPolicies.parseForSlash(key);
            String filename1 = "";
            String filename2 = "";
            switch (parts.length) {
                case 2: {
                    filename2 = "-method-" + parts[1];
                }
                case 1: {
                    filename1 = -1 == parts[0].indexOf(":") ? "callback-by:" + parts[0] : "callback-by-sdep-" + parts[0];
                    if (!"".equals(filename2) || "default".equals(parts[0])) break;
                    filename2 = "-other-methods";
                    break;
                }
                default: {
                    throw new Exception("BackendPolicies.newWritePolicies() didn't correctly parse key " + key);
                }
            }
            sb = new StringBuffer();
            logger.debug("in BackendPolicies.newWritePolicies() another outer it, key={}", (Object)key);
            Hashtable<String, String> properties = this.backendSecuritySpec.getSecuritySpec(key);
            logger.debug("in BackendPolicies.newWritePolicies() properties.size()=" + properties.size());
            logger.debug("in BackendPolicies.newWritePolicies() properties.get(BackendSecurityDeserializer.ROLE)=" + properties.get("role"));
            String callbackBasicAuth = properties.get("callbackBasicAuth");
            if (callbackBasicAuth == null) {
                callbackBasicAuth = "false";
            }
            logger.debug("in BackendPolicies.newWritePolicies() CallbackBasicAuth=" + callbackBasicAuth);
            String callbackSsl = properties.get("callbackSSL");
            if (callbackSsl == null) {
                callbackSsl = "false";
            }
            if ((iplist = properties.get("iplist")) == null) {
                iplist = "";
            }
            logger.debug("in BackendPolicies.newWritePolicies() coarseIplist=" + iplist);
            String id = "generated_for_" + key.replace(':', '-');
            logger.debug("in BackendPolicies.newWritePolicies() id=" + id);
            logger.debug("in BackendPolicies.newWritePolicies() " + filename1 + " " + filename2);
            String filename = filename1 + filename2;
            logger.debug("in BackendPolicies.newWritePolicies() " + filename);
            PID tempPid = new PID(filename);
            logger.debug("in BackendPolicies.newWritePolicies() got PID " + tempPid);
            filename = tempPid.toFilename();
            logger.debug("in BackendPolicies.newWritePolicies() filename=" + filename);
            sb.append("<Policy xmlns=\"urn:oasis:names:tc:xacml:1.0:policy\" PolicyId=\"" + id + "\">\n");
            sb.append("\t<Description>this policy is machine-generated at each Fedora server startup.  edit beSecurity.xml to change this policy.</Description>\n");
            sb.append("\t<Target>\n");
            sb.append("\t\t<Subjects>\n");
            if ("default".equals(key)) {
                sb.append("\t\t\t<AnySubject/>\n");
            } else {
                sb.append("\t\t\t<Subject>\n");
                sb.append("\t\t\t\t<SubjectMatch>\n");
                sb.append("\t\t\t\t\t<AttributeValue>" + key + "</AttributeValue>\n");
                sb.append("\t\t\t\t</SubjectMatch>\n");
                sb.append("\t\t\t</Subject>\n");
            }
            sb.append("\t\t</Subjects>\n");
            sb.append("\t</Target>\n");
            String temp = BackendPolicies.writeRules(callbackBasicAuth, callbackSsl, iplist, key, this.backendSecuritySpec.listRoleKeys());
            sb.append(temp);
            sb.append("</Policy>\n");
            logger.debug("\ndumping policy\n" + sb + "\n");
            File outfile = null;
            outfile = this.outFilePath == null ? File.createTempFile(filename, ".xml") : new File(this.outFilePath + File.separator + filename + ".xml");
            tempfiles.put(filename + ".xml", outfile.getAbsolutePath());
            PrintStream pos = new PrintStream(new FileOutputStream(outfile));
            pos.println(sb);
            pos.close();
        }
        logger.debug("finished writing temp files");
        return tempfiles;
    }

    public static void main(String[] args) throws Exception {
        BackendPolicies backendPolicies = new BackendPolicies(args[0], args[1]);
        backendPolicies.generateBackendPolicies();
    }
}

