/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import java.util.Hashtable;
import java.util.Set;
import org.fcrepo.server.errors.GeneralException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendSecuritySpec {
    private static final Logger logger = LoggerFactory.getLogger(BackendSecuritySpec.class);
    private final Hashtable<String, Hashtable<String, String>> rolePropertiesTable = new Hashtable();

    public void setSecuritySpec(String serviceRoleID, String methodName, Hashtable<String, String> properties) throws GeneralException {
        logger.debug(">>>>>> setSecuritySpec:  serviceRoleID=" + serviceRoleID + " methodName=" + methodName + " property count=" + properties.size());
        if (serviceRoleID == null || serviceRoleID.equals("")) {
            throw new GeneralException("serviceRoleID is missing.");
        }
        if (methodName == null || methodName.equals("")) {
            this.rolePropertiesTable.put(serviceRoleID, properties);
        } else {
            Hashtable<String, String> serviceProps = this.rolePropertiesTable.get(serviceRoleID);
            if (serviceProps == null) {
                throw new GeneralException("Cannot add method-level security properties if there are no properties defined for the backend service that the  method is part of. ");
            }
            String roleKey = serviceRoleID + "/" + methodName;
            this.rolePropertiesTable.put(roleKey, properties);
        }
    }

    public Hashtable<String, String> getDefaultSecuritySpec() {
        return this.rolePropertiesTable.get("default");
    }

    public Hashtable<String, String> getSecuritySpec(String serviceRoleID, String methodName) {
        if (serviceRoleID == null || serviceRoleID.equals("")) {
            return this.getDefaultSecuritySpec();
        }
        if (methodName == null || methodName.equals("")) {
            return this.rolePropertiesTable.get(serviceRoleID);
        }
        String roleKey = serviceRoleID + "/" + methodName;
        Hashtable<String, String> properties = this.rolePropertiesTable.get(roleKey);
        if (properties == null) {
            properties = this.rolePropertiesTable.get(serviceRoleID);
        }
        if (properties == null) {
            properties = this.getDefaultSecuritySpec();
        }
        return properties;
    }

    public Hashtable<String, String> getSecuritySpec(String roleKey) {
        return this.rolePropertiesTable.get(roleKey);
    }

    public Set<String> listRoleKeys() {
        return this.rolePropertiesTable.keySet();
    }
}

